/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;

public abstract class HistogramTextControl
implements FocusListener,
KeyListener {
    protected final HistogramView fParentView;
    private final Composite fParent;
    private Font fFont;
    private final Composite fComposite;
    private final Label fLabel;
    protected final Text fTextValue;
    private long fValue;

    public HistogramTextControl(HistogramView parentView, Composite parent, String label, long value) {
        this.fParentView = parentView;
        this.fParent = parent;
        Font font = parent.getFont();
        FontData fontData = font.getFontData()[0];
        this.fFont = new Font(font.getDevice(), fontData.getName(), fontData.getHeight() + -1, fontData.getStyle());
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fComposite = new Composite(this.fParent, 0);
        this.fComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        Label filler = new Label(this.fComposite, 0);
        filler.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.fLabel = new Label(this.fComposite, 0);
        this.fLabel.setText(label);
        this.fLabel.setFont(this.fFont);
        this.fLabel.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.fTextValue = new Text(this.fComposite, 2048);
        this.fTextValue.setFont(this.fFont);
        this.fTextValue.setLayoutData((Object)gridData);
        this.fTextValue.addFocusListener((FocusListener)this);
        this.fTextValue.addKeyListener((KeyListener)this);
        TmfSignalManager.register((Object)this);
    }

    public void dispose() {
        this.fFont.dispose();
        TmfSignalManager.deregister((Object)this);
    }

    public boolean isDisposed() {
        return this.fComposite.isDisposed();
    }

    protected abstract void updateValue();

    public void setLayoutData(GridData layoutData) {
        this.fComposite.setLayoutData((Object)layoutData);
    }

    public void setEnabled(boolean enabled) {
        this.fTextValue.setEnabled(enabled);
    }

    protected void setValue(long time, String displayTime) {
        Display display = Display.getCurrent();
        if (display != null) {
            if (!this.isDisposed()) {
                this.fValue = time;
                this.fTextValue.setText(displayTime);
                this.fComposite.layout();
                this.fParent.getParent().layout();
            }
            return;
        }
        if (!this.isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.setValue(time, displayTime);
                }
            });
        }
    }

    public abstract void setValue(long var1);

    public long getValue() {
        return this.fValue;
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.fTextValue.addMouseWheelListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.fTextValue.removeMouseWheelListener(listener);
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        this.updateValue();
    }

    public void keyPressed(KeyEvent event) {
        switch (event.character) {
            case '\r': {
                this.updateValue();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

