/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.navigator.ContainerFolder;
import org.eclipse.wst.jsdt.internal.ui.navigator.deferred.LoadingModelNode;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;

public class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private PackageExplorerContentProvider fContentProvider;
    private Map fWorkingSetImages;
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();

    public PackageExplorerLabelProvider(PackageExplorerContentProvider cp) {
        super(3977070998716458L, 3);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
        this.fWorkingSetImages = null;
    }

    @Override
    public ColoredString getRichTextLabel(Object element) {
        String text = this.getSpecificText(element);
        if (text != null) {
            return new ColoredString(this.decorateText(text, element));
        }
        return super.getRichTextLabel(element);
    }

    private String getSpecificText(Object element) {
        if (!this.fIsFlatLayout && element instanceof IPackageFragment) {
            IPackageFragment fragment = (IPackageFragment)element;
            Object parent = this.fContentProvider.getHierarchicalPackageParent(fragment);
            if (parent instanceof IPackageFragment) {
                return this.getNameDelta((IPackageFragment)parent, fragment);
            }
            if (parent instanceof IFolder) {
                return this.getNameDelta((IFolder)parent, fragment);
            }
        } else if (element instanceof IWorkingSet) {
            return ((IWorkingSet)element).getLabel();
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof ContainerFolder) {
            return ((ContainerFolder)element).toString();
        }
        if (element instanceof LoadingModelNode) {
            return ((LoadingModelNode)element).getText();
        }
        String text = this.getSpecificText(element);
        if (text != null) {
            return this.decorateText(text, element);
        }
        text = super.getText(element);
        if (!this.isFlatLayout() && element instanceof IJavaScriptElement) {
            switch (((IJavaScriptElement)element).getElementType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: {
                    int groupEnd = text.lastIndexOf(46);
                    if (groupEnd > 0 && groupEnd < text.length() - 1) {
                        text = text.substring(groupEnd + 1);
                    }
                    return text;
                }
            }
        }
        if (!(element instanceof IClassFile) && element instanceof IJavaScriptUnit) {
            text = ((IJavaScriptUnit)element).getPath().lastSegment();
        }
        return text;
    }

    private String getNameDelta(IPackageFragment parent, IPackageFragment fragment) {
        String prefix = String.valueOf(parent.getElementName()) + '/';
        String fullName = fragment.getElementName();
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    public boolean isFlatLayout() {
        return this.fIsFlatLayout;
    }

    private String getNameDelta(IFolder parent, IPackageFragment fragment) {
        IPath fullPath;
        IPath prefix = parent.getFullPath();
        if (prefix.isPrefixOf(fullPath = fragment.getPath())) {
            StringBuffer buf = new StringBuffer();
            int i = prefix.segmentCount();
            while (i < fullPath.segmentCount()) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(fullPath.segment(i));
                ++i;
            }
            return buf.toString();
        }
        return fragment.getElementName();
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof ContainerFolder) {
            return super.getImage(((ContainerFolder)element).getParentObject());
        }
        if (element instanceof LoadingModelNode) {
            return ((LoadingModelNode)element).getImage();
        }
        if (element instanceof IWorkingSet) {
            Image result;
            ImageDescriptor image = ((IWorkingSet)element).getImageDescriptor();
            if (this.fWorkingSetImages == null) {
                this.fWorkingSetImages = new HashMap();
            }
            if ((result = (Image)this.fWorkingSetImages.get(image)) == null) {
                result = image.createImage();
                this.fWorkingSetImages.put(image, result);
            }
            return this.decorateImage(result, element);
        }
        return super.getImage(element);
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }

    @Override
    public void dispose() {
        if (this.fWorkingSetImages != null) {
            Iterator iter = this.fWorkingSetImages.values().iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
        }
        super.dispose();
    }
}

