/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.participants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.ui.internal.console.ansi.AnsiConsoleUtils;
import org.eclipse.ui.internal.console.ansi.participants.AnsiConsolePageParticipant;
import org.eclipse.ui.internal.console.ansi.participants.AnsiPosition;
import org.eclipse.ui.internal.console.ansi.preferences.AnsiConsolePreferenceUtils;
import org.eclipse.ui.internal.console.ansi.utils.AnsiConsoleAttributes;
import org.eclipse.ui.internal.console.ansi.utils.AnsiConsoleColorPalette;

public class AnsiConsoleStyleListener
implements LineStyleListener,
IPositionUpdater {
    private static final Font MONO_FONT = new Font(null, "Monospaced", 6, 0);
    private final DefaultPositionUpdater defaultPositionUpdater = new DefaultPositionUpdater("ansi_color");
    private final HashMap<Integer, List<StyleRange>> offsetToStyleRangeCache = new HashMap();
    private IDocument document;
    private boolean documentEverScanned = false;
    private boolean isCdtBuildConsole = false;
    private int oldEventTime;
    private AnsiConsoleAttributes lastVisibleAttribute = new AnsiConsoleAttributes();

    public AnsiConsoleStyleListener(IDocument document) {
        this.setDocument(document);
        AnsiConsoleColorPalette.setPalette(AnsiConsolePreferenceUtils.getPreferredPalette());
    }

    private void setDocument(IDocument newDocument) {
        this.offsetToStyleRangeCache.clear();
        this.documentEverScanned = false;
        this.document = newDocument;
        this.isCdtBuildConsole = this.document.getClass().getSimpleName().equals("BuildConsoleDocument");
        this.document.addPositionCategory("ansi_color");
        if (!this.hasPositionUpdater(this)) {
            this.document.addPositionUpdater((IPositionUpdater)this);
        }
    }

    public boolean hasPositionUpdater(IPositionUpdater updater) {
        IPositionUpdater[] iPositionUpdaterArray = this.document.getPositionUpdaters();
        int n = iPositionUpdaterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPositionUpdater posUpdater = iPositionUpdaterArray[n2];
            if (posUpdater == updater) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void addRange(List<StyleRange> ranges, int start, int length, AnsiConsoleAttributes attributes, Color foreground, boolean isCode) {
        StyleRange range = new StyleRange(start, length, foreground, null);
        AnsiConsoleAttributes.updateRangeStyle(range, attributes);
        if (isCode) {
            if (AnsiConsolePreferenceUtils.showAnsiEscapes()) {
                range.font = MONO_FONT;
            } else {
                range.metrics = new GlyphMetrics(0, 0, 0);
            }
        }
        ranges.add(range);
    }

    public void lineGetStyle(LineStyleEvent event) {
        Position[] positions;
        if (event == null || event.lineText == null || event.lineText.length() == 0) {
            return;
        }
        if (this.document == null) {
            return;
        }
        if (!AnsiConsolePreferenceUtils.isAnsiConsoleEnabled()) {
            return;
        }
        if ((this.oldEventTime != event.time || this.isCdtBuildConsole) && event.getSource() instanceof StyledText) {
            this.oldEventTime = event.time;
            StyledText text = (StyledText)event.getSource();
            IDocument newDocument = AnsiConsolePageParticipant.getDocument(text);
            if (newDocument != null && !newDocument.equals(this.document)) {
                this.setDocument(newDocument);
            }
        }
        int eventOffset = event.lineOffset;
        int eventLength = event.lineText.length();
        List<StyleRange> cachedRanges = this.offsetToStyleRangeCache.get(eventOffset);
        if (cachedRanges != null) {
            event.styles = cachedRanges.toArray(new StyleRange[0]);
            return;
        }
        if (event.styles == null) {
            event.styles = new StyleRange[0];
        }
        if (!this.documentEverScanned) {
            this.calculateDocumentAnsiPositions(this.document, 0, 0, null);
        }
        try {
            positions = this.document.getPositions("ansi_color");
        }
        catch (BadPositionCategoryException e) {
            return;
        }
        if (positions.length == 0) {
            return;
        }
        Color errorColor = AnsiConsolePreferenceUtils.getDebugConsoleErrorColor();
        Color foregroundColor = AnsiConsolePreferenceUtils.getDebugConsoleFgColor();
        if (AnsiConsolePreferenceUtils.tryPreservingStdErrColor()) {
            StyleRange[] styleRangeArray = event.styles;
            int n = event.styles.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                if (errorColor.equals((Object)range.foreground)) {
                    foregroundColor = errorColor;
                    break;
                }
                ++n2;
            }
        }
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        AnsiConsoleAttributes prevAttr = this.lastVisibleAttribute;
        int prevPos = eventOffset;
        Position[] positionArray = positions;
        int n = positions.length;
        int n3 = 0;
        while (n3 < n) {
            Position position = positionArray[n3];
            AnsiPosition apos = (AnsiPosition)position;
            if (apos.getOffset() > eventOffset + eventLength) break;
            if (apos.overlapsWith(eventOffset, eventLength)) {
                if (apos.offset != prevPos) {
                    AnsiConsoleStyleListener.addRange(ranges, prevPos, apos.offset - prevPos, prevAttr, foregroundColor, false);
                }
                AnsiConsoleStyleListener.addRange(ranges, apos.offset, apos.length, apos.attributes, foregroundColor, true);
                prevPos = apos.offset + apos.length;
            }
            if (apos.attributes != null) {
                prevAttr = apos.attributes;
            }
            ++n3;
        }
        AnsiConsoleStyleListener.addRange(ranges, prevPos, eventOffset + eventLength - prevPos, prevAttr, foregroundColor, false);
        if (!ranges.isEmpty()) {
            positionArray = event.styles;
            n = event.styles.length;
            n3 = 0;
            while (n3 < n) {
                Position range = positionArray[n3];
                if (range.foreground != null) {
                    if (range.foreground.equals((Object)AnsiConsolePreferenceUtils.getHyperlinkColor())) {
                        ranges.add((StyleRange)range);
                    }
                    if (this.isCdtBuildConsole && !range.foreground.equals((Object)AnsiConsolePreferenceUtils.getCdtOutputStreamColor())) {
                        ranges.add((StyleRange)range);
                    }
                }
                ++n3;
            }
            this.offsetToStyleRangeCache.put(eventOffset, ranges);
            event.styles = ranges.toArray(new StyleRange[0]);
        }
    }

    private static List<AnsiPosition> findPositions(int offset, String currentText) {
        ArrayList<AnsiPosition> result = new ArrayList<AnsiPosition>();
        Matcher matcher = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_TXT.matcher(currentText);
        while (matcher.find()) {
            int start = matcher.start();
            String group = matcher.group();
            result.add(new AnsiPosition(start + offset, group));
        }
        return result;
    }

    private void calculateDocumentAnsiPositions(IDocument eventDocument, int offset, int length, String text) {
        String txt;
        String string = txt = text != null ? text : eventDocument.get();
        if (length != 0) {
            return;
        }
        if (this.documentEverScanned && offset + txt.length() != eventDocument.getLength()) {
            return;
        }
        this.documentEverScanned = true;
        try {
            List<AnsiPosition> newPos = AnsiConsoleStyleListener.findPositions(offset, txt);
            for (AnsiPosition apos : newPos) {
                eventDocument.addPosition("ansi_color", (Position)apos);
            }
        }
        catch (BadLocationException | BadPositionCategoryException throwable) {
            // empty catch block
        }
    }

    public void update(DocumentEvent event) {
        if (!AnsiConsolePreferenceUtils.isAnsiConsoleEnabled()) {
            return;
        }
        IDocument eventDocument = event.getDocument();
        int offset = event.getOffset();
        int length = event.getLength();
        String text = event.getText();
        try {
            if (offset == 0 && length != 0) {
                Position[] positionArray = eventDocument.getPositions("ansi_color");
                int n = positionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Position pos = positionArray[n2];
                    if (pos.offset >= length) break;
                    AnsiConsoleAttributes attributes = ((AnsiPosition)pos).attributes;
                    if (attributes != null) {
                        this.lastVisibleAttribute = attributes;
                    }
                    ++n2;
                }
            }
            this.defaultPositionUpdater.update(event);
            this.calculateDocumentAnsiPositions(eventDocument, offset, length, text);
            this.offsetToStyleRangeCache.clear();
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }
}

