/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.applications;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.PlatformExtension;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;

public class RunHeadlessScript
implements IApplication {
    private static final String HELP = "-help";
    private static final String ENGINE = "-engine";
    private static final String SCRIPT_ARGUMENTS = "scriptArguments";
    private static final String SCRIPT = "-script";
    private static final String REFRESH_WORKSPACE = "-refreshWorkspace";
    private static final String WORKSPACE = "-workspace";

    private static void loadStartupExtension(PlatformExtension extension) {
        try {
            Logger.info("org.eclipse.ease", String.format("Loading early startup extension: %s", extension.getAttribute("class")));
            extension.createInstance("class", IStartup.class).earlyStartup();
        }
        catch (ClassCastException e) {
            RunHeadlessScript.printError(String.format("Failed to execute earlyStartup(): %s", e.getMessage()));
        }
        catch (CoreException e) {
            RunHeadlessScript.printError(String.format("Could not create instance for startup code: %s", extension.getAttribute("class")));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> extractInputParameters(String[] arguments) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(SCRIPT_ARGUMENTS, new ArrayList());
        int index = 0;
        while (index < arguments.length) {
            if (parameters.containsKey(SCRIPT)) {
                ((List)parameters.get(SCRIPT_ARGUMENTS)).add(arguments[index]);
            } else if (SCRIPT.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("script name is missing");
                parameters.put(SCRIPT, arguments[index + 1]);
                ((List)parameters.get(SCRIPT_ARGUMENTS)).add(arguments[index + 1]);
                ++index;
            } else if (WORKSPACE.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("workspace name is missing");
                parameters.put(WORKSPACE, arguments[index + 1]);
                ++index;
            } else if (REFRESH_WORKSPACE.equals(arguments[index])) {
                parameters.put(REFRESH_WORKSPACE, true);
            } else if (ENGINE.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("engine ID is missing");
                parameters.put(ENGINE, arguments[index + 1]);
                ++index;
            } else {
                if (!HELP.equals(arguments[index])) throw new IllegalArgumentException(String.format("invalid argument: %s", arguments[index]));
                return null;
            }
            ++index;
        }
        return parameters;
    }

    private static void printUsage() {
        RunHeadlessScript.getOutputStream().println("SYNTAX: [-workspace <workspace location> [-refreshWorkspace]] [-engine <engineID>]-script <script name> <script parameters>");
        RunHeadlessScript.getOutputStream().println("");
        RunHeadlessScript.getOutputStream().println("\t\t<script name> is a path like 'file://C/myfolder/myscript.js'");
        RunHeadlessScript.getOutputStream().println("\t\t<engineID> provides a dedicated script engine ID. Use org.eclipse.ease.listEngines application.");
        RunHeadlessScript.getOutputStream().println("\t\t<workspace location> is a file system path like 'C:\\somefolder\\myworkspace'");
        RunHeadlessScript.getOutputStream().println("\t\t\tif you provide a workspace you can use workspace:// identifiers in your scripts");
        RunHeadlessScript.getOutputStream().println("\t\t\tif you provide a workspace you may ask to refresh it first prior to script execution");
        RunHeadlessScript.getOutputStream().println("\t\t<script parameters> will be passed to the script as String[] in the variable 'argv'");
    }

    private static void printError(String message) {
        RunHeadlessScript.getOutputStream().println("ERROR: " + message);
    }

    private static PrintStream getOutputStream() {
        return System.out;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        block13: {
            try {
                Object object = context.getArguments().get("application.args");
                if (!(object instanceof String[])) break block13;
                Map<String, Object> parameters = RunHeadlessScript.extractInputParameters((String[])object);
                if (parameters != null) {
                    Location location = this.loadWorkspace(parameters);
                    this.loadEarlyStartupExtensions();
                    try {
                        if (parameters.containsKey(SCRIPT)) {
                            String scriptLocation = parameters.get(SCRIPT).toString();
                            String engineID = parameters.containsKey(ENGINE) ? parameters.get(ENGINE).toString() : null;
                            String[] arguments = ((List)parameters.get(SCRIPT_ARGUMENTS)).toArray(new String[0]);
                            try {
                                Object result = ScriptService.getInstance().executeScript(scriptLocation, engineID, arguments);
                                Integer n = this.getScriptResult(result);
                                return n;
                            }
                            catch (Throwable throwable) {
                                Integer n;
                                block14: {
                                    n = -1;
                                    if (location == null) break block14;
                                    ResourcesPlugin.getWorkspace().save(true, null);
                                    location.release();
                                }
                                return n;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Parameter '%s' is required", SCRIPT));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (location != null) {
                            ResourcesPlugin.getWorkspace().save(true, null);
                            location.release();
                        }
                    }
                }
                RunHeadlessScript.printUsage();
            }
            catch (IOException e) {
                RunHeadlessScript.printError(String.format(e.getMessage(), new Object[0]));
                RunHeadlessScript.printUsage();
            }
            catch (IllegalArgumentException e) {
                RunHeadlessScript.printError(String.format("invalid command line argument%n\t%s%n", e.getMessage()));
                RunHeadlessScript.printUsage();
            }
        }
        return -1;
    }

    private int getScriptResult(Object result) {
        if (result != null) {
            if (ScriptResult.VOID.equals(result)) {
                return 0;
            }
            Integer adaptedResult = (Integer)Adapters.adapt((Object)result, Integer.class);
            if (adaptedResult != null) {
                return adaptedResult;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.valueOf(result.toString()).intValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    return Boolean.parseBoolean(result.toString()) ? 0 : -1;
                }
            }
        }
        return 0;
    }

    private Location loadWorkspace(Map<String, Object> parameters) throws MalformedURLException, IOException, CoreException {
        Location location = null;
        if (parameters.containsKey(WORKSPACE)) {
            location = Platform.getInstanceLocation();
            URL workspaceURL = new File(parameters.get(WORKSPACE).toString()).toURL();
            if (!location.isSet()) {
                if (!location.set(workspaceURL, true)) {
                    throw new IOException(String.format("Could not set the workspace to '%s'", location.getURL()));
                }
            } else if (!location.getURL().toString().equals(workspaceURL.toString())) {
                throw new IOException(String.format("Could not set the workspace as it is already set to '%s'", location.getURL()));
            }
            if (parameters.containsKey(REFRESH_WORKSPACE)) {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return location;
    }

    private void loadEarlyStartupExtensions() {
        Collection<PlatformExtension> headlessExtensions = PlatformExtension.createFor("org.eclipse.ease.headless");
        List blacklistedStartups = headlessExtensions.stream().filter(e -> "startupBlacklist".equals(e.getConfigurationElement().getName())).map(e -> e.getAttribute("className")).collect(Collectors.toList());
        Collection<PlatformExtension> earlyStartups = PlatformExtension.createFor("org.eclipse.ui.startup");
        earlyStartups.stream().filter(e -> "startup".equals(e.getConfigurationElement().getName())).filter(e -> !blacklistedStartups.contains(e.getAttribute("class"))).forEach(RunHeadlessScript::loadStartupExtension);
    }

    public void stop() {
    }
}

