/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.ApiEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.HostThreadIdentifier;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old.RocmCallStackStateProvider;
import org.eclipse.tracecompass.incubator.rocm.core.analysis.dependency.IDependencyMaker;
import org.eclipse.tracecompass.incubator.rocm.core.trace.GpuAspect;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class HipActivityEventHandler
extends AbstractGpuEventHandler {
    public HipActivityEventHandler(RocmCallStackStateProvider stateProvider) {
        super(stateProvider);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) throws AttributeNotFoundException {
        int callStackQuark = HipActivityEventHandler.getCallStackQuark(ssb, event);
        ITmfEventField content = event.getContent();
        Long timestamp = event.getTimestamp().toNanos();
        String eventName = (String)content.getFieldValue(String.class, new String[]{"name"});
        if (eventName != null && eventName.equals("KernelExecution")) {
            Integer queueId;
            Map<Long, ITmfEvent> apiEventCorrelationMap;
            ITmfEvent apiEvent;
            int hipStreamCallStackQuark = -1;
            Long correlationId = (Long)content.getFieldValue(Long.class, new String[]{"correlation_id"});
            int gpuId = HipActivityEventHandler.getGpuId(event);
            int hipStreamId = -1;
            String kernelName = "KernelExecution";
            IDependencyMaker dependencyMaker = this.fStateProvider.getDependencyMaker();
            if (dependencyMaker != null && (apiEvent = (apiEventCorrelationMap = dependencyMaker.getApiEventCorrelationMap()).get(correlationId)) != null) {
                hipStreamId = Integer.parseInt(ApiEventHandler.getArg(apiEvent.getContent(), 4));
                hipStreamCallStackQuark = HipActivityEventHandler.getHipStreamCallStackQuark(ssb, apiEvent, gpuId);
                kernelName = ApiEventHandler.getArg(apiEvent.getContent(), 6);
            }
            if ((queueId = (Integer)content.getFieldValue(Integer.class, new String[]{"queue_id"})) == null || correlationId == null) {
                return;
            }
            Long timestampEnd = (Long)content.getFieldValue(Long.class, new String[]{"end"});
            if (timestampEnd != null) {
                this.pushParallelActivityOnCallStack(ssb, callStackQuark, kernelName, timestamp, ((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue()));
                if (hipStreamCallStackQuark > 0) {
                    this.pushParallelActivityOnCallStack(ssb, hipStreamCallStackQuark, kernelName, timestamp, ((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue()));
                }
            }
            HostThreadIdentifier queueHostThreadIdentifier = new HostThreadIdentifier((int)queueId, HostThreadIdentifier.KERNEL_CATEGORY.QUEUE, gpuId);
            this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), queueHostThreadIdentifier, callStackQuark);
            if (hipStreamCallStackQuark > 0) {
                HostThreadIdentifier streamHostThreadIdentifier = new HostThreadIdentifier(hipStreamId, HostThreadIdentifier.KERNEL_CATEGORY.STREAM, gpuId);
                this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), streamHostThreadIdentifier, hipStreamCallStackQuark);
            }
        } else {
            if (eventName == null) {
                ssb.modifyAttribute(timestamp.longValue(), null, callStackQuark);
                return;
            }
            Long timestampEnd = (Long)content.getFieldValue(Long.class, new String[]{"end"});
            ssb.pushAttribute(timestamp.longValue(), (Object)eventName, callStackQuark);
            if (timestampEnd != null) {
                this.fStateProvider.addFutureEvent(((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue()), timestampEnd, callStackQuark, ITmfStateProvider.FutureEventType.POP);
            }
            HostThreadIdentifier hostThreadIdentifier = new HostThreadIdentifier();
            this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), hostThreadIdentifier, callStackQuark);
        }
    }

    private static int getCallStackQuark(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        String eventName = (String)event.getContent().getFieldValue(String.class, new String[]{"name"});
        if (eventName == null) {
            return -1;
        }
        if (eventName.equals("KernelExecution")) {
            Long queueId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"queue_id"});
            Long gpuId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"device_id"});
            if (queueId == null || gpuId == null) {
                return -1;
            }
            int gpuQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "GPU " + gpuId.toString()});
            int queuesQuark = ssb.getQuarkRelativeAndAdd(gpuQuark, new String[]{"Queues"});
            int queueQuark = ssb.getQuarkRelativeAndAdd(queuesQuark, new String[]{"Queue " + Long.toString(queueId)});
            return ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{"CallStack"});
        }
        int copyQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Memory"});
        int tempQuark1 = ssb.getQuarkRelativeAndAdd(copyQuark, new String[]{""});
        int tempQuark2 = ssb.getQuarkRelativeAndAdd(tempQuark1, new String[]{"Memory Transfers"});
        return ssb.getQuarkRelativeAndAdd(tempQuark2, new String[]{"CallStack"});
    }

    private static int getHipStreamCallStackQuark(ITmfStateSystemBuilder ssb, @NonNull ITmfEvent event, Integer gpuId) {
        int gpuQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "GPU " + gpuId.toString()});
        int hipStreamsQuark = ssb.getQuarkRelativeAndAdd(gpuQuark, new String[]{"HIP Streams"});
        int hipStreamId = Integer.parseInt(ApiEventHandler.getArg(event.getContent(), 4));
        int hipStreamQuark = ssb.getQuarkRelativeAndAdd(hipStreamsQuark, new String[]{"Stream " + Integer.toString(hipStreamId)});
        return ssb.getQuarkRelativeAndAdd(hipStreamQuark, new String[]{"CallStack"});
    }

    private static int getGpuId(ITmfEvent event) {
        Integer gpuId = (Integer)TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), GpuAspect.class, (ITmfEvent)event);
        if (gpuId != null) {
            return gpuId;
        }
        return -1;
    }
}

