/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor.Ros2ExecutorAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.executor.Ros2ExecutorStateInstance;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Ros2ExecutorStateProvider
extends AbstractRos2StateProvider {
    private static final int VERSION_NUMBER = 0;
    private final ITmfStateSystem fObjectsSs;

    public Ros2ExecutorStateProvider(ITmfTrace trace, ITmfStateSystem objectsSs) {
        super(trace, Ros2ExecutorAnalysis.getFullAnalysisId());
        this.fObjectsSs = objectsSs;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new Ros2ExecutorStateProvider(this.getTrace(), this.fObjectsSs);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (!Ros2ExecutorStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        Ros2ExecutorStateInstance state = null;
        if (Ros2ExecutorStateProvider.isEvent(event, LAYOUT.eventRclcppExecutorGetNextReady())) {
            state = new Ros2ExecutorStateInstance(Ros2ExecutorStateInstance.ExecutorState.GET_NEXT_READY, null);
        } else if (Ros2ExecutorStateProvider.isEvent(event, LAYOUT.eventRclcppExecutorWaitForWork())) {
            state = new Ros2ExecutorStateInstance(Ros2ExecutorStateInstance.ExecutorState.WAIT_FOR_WORK, null);
        } else if (Ros2ExecutorStateProvider.isEvent(event, LAYOUT.eventRclcppExecutorExecute())) {
            long handle = (Long)Ros2ExecutorStateProvider.getField(event, LAYOUT.fieldHandle());
            state = new Ros2ExecutorStateInstance(Ros2ExecutorStateInstance.ExecutorState.EXECUTE, handle);
        }
        if (state != null) {
            int executorQuark = Ros2ExecutorStateProvider.getQuarkAndAdd(ss, event);
            ss.modifyAttribute(timestamp, (Object)state, executorQuark);
        }
    }

    private static int getQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull ITmfEvent event) {
        HostInfo hostInfo = Ros2ExecutorStateProvider.hostInfoFrom(event);
        int traceQuark = ss.getQuarkAbsoluteAndAdd(new String[]{event.getTrace().getName()});
        ss.updateOngoingState((Object)hostInfo, traceQuark);
        return ss.getQuarkRelativeAndAdd(traceQuark, new String[]{Ros2ExecutorStateProvider.getPid(event).toString(), Ros2ExecutorStateProvider.getTid(event).toString()});
    }
}

