/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ShutdownHandler
implements EventHandler,
IWorkbenchListener {
    Collection<IScript> fShutdownScripts = new HashSet<IScript>();
    private long fShutdownTimeout = 10000L;
    Collection<IScriptEngine> fEngines = null;
    private long fStartTime;

    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        if (value == null) {
            this.fShutdownScripts.remove(script);
        } else {
            this.fShutdownScripts.add(script);
            if (!value.isEmpty()) {
                try {
                    this.fShutdownTimeout = Math.max(this.fShutdownTimeout, (long)(Integer.parseInt(value) * 1000));
                }
                catch (NumberFormatException e) {
                    Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Invalid onShutdown timeout for script: " + script.getLocation()));
                }
            }
        }
        if (this.fShutdownScripts.isEmpty()) {
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
        } else {
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        if (!forced && !this.fShutdownScripts.isEmpty()) {
            this.fStartTime = System.currentTimeMillis();
            this.fEngines = new HashSet<IScriptEngine>();
            for (IScript script : this.fShutdownScripts) {
                this.fEngines.add(script.run());
            }
            new ShutdownJob().schedule();
            return false;
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    private class ShutdownJob
    extends Job {
        public ShutdownJob() {
            super("Wait for shutdown scripts");
        }

        protected IStatus run(IProgressMonitor monitor) {
            for (IScriptEngine engine : ShutdownHandler.this.fEngines) {
                long timeout = ShutdownHandler.this.fStartTime + ShutdownHandler.this.fShutdownTimeout - System.currentTimeMillis();
                if (timeout <= 0L) break;
                try {
                    engine.joinEngine(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (IScriptEngine engine : ShutdownHandler.this.fEngines) {
                if (engine.isFinished()) continue;
                engine.terminate();
            }
            Display.getDefault().asyncExec(() -> {
                ShutdownHandler.this.fShutdownScripts.clear();
                PlatformUI.getWorkbench().close();
            });
            return Status.OK_STATUS;
        }
    }
}

