/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.ViewFilterDialog;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public abstract class AbstractStateSystemTimeGraphView
extends AbstractTimeGraphView {
    private static final @NonNull Comparator<ITmfStateInterval> INTERVALS_COMPARATOR = Comparator.comparing(ITmfStateInterval::getStartTime).thenComparing(ITmfStateInterval::getEndTime);
    private static final @NonNull Comparator<ITimeEvent> TIME_EVENT_COMPARATOR = Comparator.comparing(ITimeEvent::getTime).thenComparing(ITimeEvent::getDuration);
    private static final long MAX_INTERVALS = 1000000L;
    private final Map<ITmfStateSystem, List<@NonNull TimeGraphEntry>> fSSEntryListMap = new HashMap<ITmfStateSystem, List<TimeGraphEntry>>();
    private final Multimap<ITmfTrace, ITmfStateSystem> fTraceSSMap = HashMultimap.create();
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractStateSystemTimeGraphView.class);
    private static final int DEFAULT_BUFFER_SIZE = 3;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Table<ITimeGraphEntry, @NonNull Pair<Long, Long>, List<ITimeEvent>> regroupOverlappingGaps(Map<? extends ITimeGraphEntry, List<ITimeEvent>> gapsMap) {
        @NonNull HashBasedTable gapsTable = HashBasedTable.create();
        PriorityQueue<ITimeEvent> queue = new PriorityQueue<ITimeEvent>(TIME_EVENT_COMPARATOR);
        gapsMap.values().forEach(events -> {
            boolean bl = queue.addAll((Collection<ITimeEvent>)events);
        });
        Pair<Long, Long> previous = null;
        while (!queue.isEmpty()) {
            Pair<Long, Long> result;
            ITimeEvent event = Objects.requireNonNull(queue.poll());
            ITimeGraphEntry entry = event.getEntry();
            Pair<Long, Long> pair = result = previous != null && event.getTime() < (Long)previous.getRight() && event.getTime() + event.getDuration() > (Long)previous.getLeft() ? previous : null;
            if (result != null) {
                Pair<Long, Long> merged = AbstractStateSystemTimeGraphView.mergeInterval(result, event);
                HashMap column = new HashMap(gapsTable.column(result));
                if (!result.equals(merged)) {
                    gapsTable.columnKeySet().remove(result);
                    result = merged;
                    for (Map.Entry row : column.entrySet()) {
                        gapsTable.put((Object)((ITimeGraphEntry)row.getKey()), result, (Object)((List)row.getValue()));
                    }
                }
            } else {
                result = Objects.requireNonNull(Pair.of((Object)event.getTime(), (Object)(event.getTime() + event.getDuration())));
            }
            previous = result;
            ArrayList<ITimeEvent> events2 = (ArrayList<ITimeEvent>)gapsTable.get((Object)entry, (Object)result);
            if (events2 == null) {
                events2 = new ArrayList<ITimeEvent>();
                gapsTable.put((Object)entry, result, events2);
            }
            events2.add(event);
        }
        return gapsTable;
    }

    private static @NonNull Pair<Long, Long> mergeInterval(Pair<Long, Long> source, ITimeEvent event) {
        long left = Math.min((Long)source.getLeft(), event.getTime());
        long right = Math.max((Long)source.getRight(), event.getTime() + event.getDuration());
        return Objects.requireNonNull(Pair.of((Object)left, (Object)right));
    }

    public AbstractStateSystemTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id, pres);
    }

    protected void getEnventListGaps(@NonNull TimeGraphEntry entry, List<ITimeEvent> eventList, Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
    }

    protected @NonNull Collection<@NonNull Integer> getQuarksForEntry(@NonNull ITimeGraphEntry entry, ITmfStateSystem ss) {
        return IntStream.range(0, ss.getNbAttributes()).boxed().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable List<@NonNull TimeGraphEntry> getEntryList(ITmfStateSystem ss) {
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            return this.fSSEntryListMap.get(ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.addToEntryList(trace, AbstractStateSystemTimeGraphView.getRootEntries(list));
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.addToEntryList(trace, AbstractStateSystemTimeGraphView.getRootEntries(list));
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<@NonNull TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList == null) {
                this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                entryList.addAll(list);
            }
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, ITmfStateSystem ss, List<TimeGraphEntry> list) {
        super.removeFromEntryList(trace, list);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList != null) {
                entryList.removeAll(list);
                if (entryList.isEmpty()) {
                    this.fTraceSSMap.remove((Object)trace, (Object)ss);
                }
            }
        }
    }

    private static List<@NonNull TimeGraphEntry> getRootEntries(List<@NonNull TimeGraphEntry> list) {
        LinkedHashSet<@NonNull TimeGraphEntry> roots = new LinkedHashSet<TimeGraphEntry>();
        Iterator<TimeGraphEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeGraphEntry entry;
            TimeGraphEntry root = entry = iterator.next();
            while (root.getParent() != null) {
                root = root.getParent();
            }
            roots.add(root);
        }
        return new ArrayList<TimeGraphEntry>(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected @Nullable AbstractTimeGraphView.ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        ArrayList<ITmfStateSystem> ssList = null;
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            ssList = new ArrayList<ITmfStateSystem>(this.fTraceSSMap.get((Object)this.getTrace()));
        }
        if (ssList.isEmpty()) {
            return null;
        }
        return new ZoomThreadByTime(this.getVisibleItems(3), ssList, startTime, endTime, resolution, restart);
    }

    protected void queryFullStates(ITmfStateSystem ss, long start, long end, long resolution, @NonNull IProgressMonitor monitor, @NonNull IQueryHandler handler) {
        if (end < start) {
            return;
        }
        ArrayList<List<ITmfStateInterval>> fullStates = new ArrayList<List<ITmfStateInterval>>();
        List prevFullState = null;
        try {
            long time = start;
            while (!monitor.isCanceled()) {
                List fullState = ss.queryFullState(time);
                fullStates.add(fullState);
                if ((long)(fullStates.size() * fullState.size()) > 1000000L) {
                    handler.handle(fullStates, prevFullState);
                    prevFullState = (List)fullStates.get(fullStates.size() - 1);
                    fullStates.clear();
                }
                if (time >= end) break;
                time = Math.min(end, time + resolution);
            }
            if (!fullStates.isEmpty()) {
                handler.handle(fullStates, prevFullState);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void queryRangeStates(ITmfStateSystem ss, long start, long end, @NonNull Collection<@NonNull Integer> quarks, long resolution, @NonNull IProgressMonitor monitor, @NonNull IQueryHandler handler) {
        if (end < start) {
            return;
        }
        try {
            @NonNull Iterable intervals = ss.query2D(quarks, start, end);
            HashMap<Integer, Integer> ptr = new HashMap<Integer, Integer>();
            HashMap<Integer, List<ITmfStateInterval>> itvs = new HashMap<Integer, List<ITmfStateInterval>>();
            intervals.forEach(itv -> {
                int key = itv.getAttribute();
                ArrayList<ITmfStateInterval> set = (ArrayList<ITmfStateInterval>)itvs.get(key);
                if (set == null) {
                    set = new ArrayList<ITmfStateInterval>();
                    itvs.put(key, set);
                    ptr.put(key, 0);
                }
                set.add((ITmfStateInterval)itv);
            });
            for (Map.Entry entry : itvs.entrySet()) {
                ((List)entry.getValue()).sort(INTERVALS_COMPARATOR);
            }
            ArrayList<List<ITmfStateInterval>> fullStates = new ArrayList<List<ITmfStateInterval>>();
            List prevFullState = null;
            long time = start;
            while (!monitor.isCanceled()) {
                int nbAttributes = ss.getNbAttributes();
                List<ITmfStateInterval> fullState = AbstractStateSystemTimeGraphView.getFullStateForTime(time, itvs, ptr, nbAttributes);
                fullStates.add(fullState);
                if ((long)(fullStates.size() * fullState.size()) > 1000000L) {
                    handler.handle(fullStates, prevFullState);
                    prevFullState = (List)fullStates.get(fullStates.size() - 1);
                    fullStates.clear();
                }
                if (time >= end) break;
                time = Math.min(end, time + resolution);
            }
            if (!fullStates.isEmpty()) {
                handler.handle(fullStates, prevFullState);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private static List<ITmfStateInterval> getFullStateForTime(long time, @NonNull Map<@NonNull Integer, @NonNull List<@NonNull ITmfStateInterval>> itvs, @NonNull Map<@NonNull Integer, @NonNull Integer> ptr, int nbAttributes) {
        ArrayList<ITmfStateInterval> fullState = new ArrayList<ITmfStateInterval>();
        int key = 0;
        while (key < nbAttributes) {
            fullState.add(null);
            ++key;
        }
        for (Map.Entry<Integer, List<ITmfStateInterval>> entry : itvs.entrySet()) {
            List<ITmfStateInterval> intervals = entry.getValue();
            int key2 = Objects.requireNonNull(entry.getKey());
            int index = Objects.requireNonNull(ptr.get(key2));
            ITmfStateInterval interval = Objects.requireNonNull(intervals.get(index));
            while (!AbstractStateSystemTimeGraphView.isBounded(time, interval) && ++index < intervals.size()) {
                interval = Objects.requireNonNull(intervals.get(index));
                ptr.put(key2, index);
            }
            if (index >= intervals.size()) continue;
            fullState.set(key2, interval);
        }
        return fullState;
    }

    private static boolean isBounded(long time, ITmfStateInterval interval) {
        return interval.getStartTime() <= time && interval.getEndTime() >= time;
    }

    protected abstract @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, ITmfStateSystem var2, @NonNull List<List<ITmfStateInterval>> var3, @Nullable List<ITmfStateInterval> var4, @NonNull IProgressMonitor var5);

    protected @NonNull List<ILinkEvent> getLinkList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetView(ITmfTrace viewTrace) {
        super.resetView(viewTrace);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            for (ITmfStateSystem ss : this.fTraceSSMap.removeAll((Object)viewTrace)) {
                this.fSSEntryListMap.remove(ss);
            }
        }
    }

    public static interface IQueryHandler {
        public void handle(@NonNull List<List<ITmfStateInterval>> var1, @Nullable List<ITmfStateInterval> var2);
    }

    private class ZoomThreadByTime
    extends AbstractTimeGraphView.ZoomThread {
        private static final int BG_SEARCH_RESOLUTION = 1;
        private final @NonNull Collection<@NonNull TimeGraphEntry> fVisibleEntries;
        private final @NonNull List<ITmfStateSystem> fZoomSSList;
        private boolean fClearZoomedLists;

        public ZoomThreadByTime(@NonNull Collection<TimeGraphEntry> entries, List<ITmfStateSystem> ssList, long startTime, long endTime, long resolution, boolean restart) {
            super(startTime, endTime, resolution);
            this.fZoomSSList = ssList;
            this.fClearZoomedLists = !restart;
            this.fVisibleEntries = entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            ArrayList<ILinkEvent> links = new ArrayList<ILinkEvent>();
            ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List<TimeGraphEntry> entryList = null;
                Map<ITmfStateSystem, List<TimeGraphEntry>> map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                this.zoomByTime(ss, entryList, links, markers, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            }
            if (!this.getMonitor().isCanceled()) {
                markers.addAll(AbstractStateSystemTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                this.applyResults(() -> {
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setLinks(links);
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkerCategories(AbstractStateSystemTimeGraphView.this.getMarkerCategories());
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkers(markers);
                });
            } else {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"TimeGraphView:ZoomThreadCanceled", (Object[])new Object[0]);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void zoomByTime(ITmfStateSystem ss, List<TimeGraphEntry> entryList, List<ILinkEvent> links, List<IMarkerEvent> markers, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
            boolean fullRange;
            long start = Math.max(startTime, ss.getStartTime());
            long end = Math.min(endTime, ss.getCurrentEndTime());
            boolean bl = fullRange = this.getZoomStartTime() <= AbstractStateSystemTimeGraphView.this.getStartTime() && this.getZoomEndTime() >= AbstractStateSystemTimeGraphView.this.getEndTime();
            if (end < start) {
                return;
            }
            ViewFilterDialog timeEventFilterDialog = AbstractStateSystemTimeGraphView.this.getViewFilterDialog();
            boolean isFilterActive = timeEventFilterDialog != null && timeEventFilterDialog.isFilterActive();
            AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setTimeEventFilterApplied(isFilterActive);
            boolean hasSavedFilter = timeEventFilterDialog != null && timeEventFilterDialog.hasActiveSavedFilters();
            AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setSavedFilterStatus(hasSavedFilter);
            if (fullRange) {
                AbstractStateSystemTimeGraphView.this.redraw();
            }
            @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = AbstractStateSystemTimeGraphView.this.generateRegexPredicate();
            TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(this.getZoomStartTime(), this.getZoomEndTime(), predicates, this.getResolution());
            @NonNull Iterable incorrectSample = Iterables.filter(this.fVisibleEntries, entry -> !sampling.equals(entry.getSampling()));
            @NonNull Iterable entries = Iterables.filter((Iterable)incorrectSample, entry -> this.isMember((TimeGraphEntry)entry, entryList));
            HashMap<TimeGraphEntry, List<ITimeEvent>> gaps = isFilterActive ? new HashMap<TimeGraphEntry, List<ITimeEvent>>() : null;
            this.doZoom(ss, links, markers, resolution, monitor, start, end, sampling, entries, predicates, gaps);
            if (isFilterActive && gaps != null && !gaps.isEmpty()) {
                this.doBgSearch(ss, 1, monitor, gaps, predicates);
            }
        }

        private void doZoom(ITmfStateSystem ss, List<ILinkEvent> links, List<IMarkerEvent> markers, long resolution, @NonNull IProgressMonitor monitor, long start, long end, TimeGraphEntry.Sampling sampling, Iterable<@NonNull TimeGraphEntry> entries, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
            AbstractStateSystemTimeGraphView.this.queryFullStates(ss, start, end, resolution, monitor, (fullStates, prevFullState) -> {
                Throwable throwable = null;
                Object var12_15 = null;
                try (TraceCompassLogUtils.ScopeLog scope = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingStates", new Object[0]);){
                    for (TimeGraphEntry entry : entries) {
                        if (sampling.equals(entry.getSampling())) continue;
                        this.zoom((TimeGraphEntry)NonNullUtils.checkNotNull((Object)entry), ss, fullStates, prevFullState, predicates, monitor, gaps);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var12_15 = null;
                try (TraceCompassLogUtils.ScopeLog linksLogger1 = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingLinks", new Object[0]);){
                    links.addAll(AbstractStateSystemTimeGraphView.this.getLinkList(ss, fullStates, prevFullState, monitor));
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                throwable = null;
                var12_15 = null;
                try (TraceCompassLogUtils.ScopeLog linksLogger2 = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingMarkers", new Object[0]);){
                    markers.addAll(AbstractStateSystemTimeGraphView.this.getViewMarkerList(ss, fullStates, prevFullState, monitor));
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                AbstractStateSystemTimeGraphView.this.refresh();
            });
            if (!monitor.isCanceled()) {
                this.applyResults(() -> entries.forEach(entry -> {
                    if (!sampling.equals(entry.getSampling())) {
                        if (!predicates.isEmpty()) {
                            ArrayList eventList = Lists.newArrayList(entry.getTimeEventsIterator(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution()));
                            AbstractStateSystemTimeGraphView.this.doFilterEventList((TimeGraphEntry)entry, eventList, predicates);
                            entry.setZoomedEventList(eventList);
                        }
                        entry.setSampling(sampling);
                    }
                }));
            }
            AbstractStateSystemTimeGraphView.this.refresh();
        }

        private void zoom(@NonNull TimeGraphEntry entry, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, @NonNull IProgressMonitor monitor, Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
            List<ITimeEvent> eventList = AbstractStateSystemTimeGraphView.this.getEventList(entry, ss, fullStates, prevFullState, monitor);
            if (gaps != null) {
                AbstractStateSystemTimeGraphView.this.getEnventListGaps(entry, eventList, gaps);
            }
            if (eventList != null && !monitor.isCanceled()) {
                AbstractStateSystemTimeGraphView.this.doFilterEventList(entry, eventList, predicates);
                this.applyResults(() -> {
                    for (ITimeEvent event : eventList) {
                        entry.addZoomedEvent(event);
                    }
                });
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void doBgSearch(ITmfStateSystem ss, int resolution, @NonNull IProgressMonitor monitor, Map<TimeGraphEntry, List<ITimeEvent>> gaps, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (TraceCompassLogUtils.ScopeLog poc = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "TimegraphBgSearch", new Object[0]);){
                ViewFilterDialog timeEventFilterDialog = AbstractStateSystemTimeGraphView.this.getViewFilterDialog();
                boolean hasActiveSavedFilters = timeEventFilterDialog.hasActiveSavedFilters();
                Table<ITimeGraphEntry, @NonNull Pair<Long, Long>, List<ITimeEvent>> gapsTable = AbstractStateSystemTimeGraphView.regroupOverlappingGaps(gaps);
                HashMap<ITimeGraphEntry, Collection<Integer>> quarksPerEntry = new HashMap<ITimeGraphEntry, Collection<Integer>>();
                for (ITimeGraphEntry iTimeGraphEntry : gapsTable.rowKeySet()) {
                    Collection<Integer> quarks = AbstractStateSystemTimeGraphView.this.getQuarksForEntry(iTimeGraphEntry, ss);
                    quarksPerEntry.put(iTimeGraphEntry, quarks);
                }
                for (Map.Entry entry : gapsTable.columnMap().entrySet()) {
                    Map row = (Map)entry.getValue();
                    ArrayList<Integer> quarks = new ArrayList<Integer>();
                    for (ITimeGraphEntry entry2 : row.keySet()) {
                        Collection entryQuarks = (Collection)quarksPerEntry.get(entry2);
                        if (entryQuarks == null) continue;
                        entryQuarks.forEach(quark -> {
                            boolean bl = quarks.add((Integer)quark);
                        });
                    }
                    AbstractStateSystemTimeGraphView.this.queryRangeStates(ss, (Long)((Pair)entry.getKey()).getLeft(), (Long)((Pair)entry.getKey()).getRight(), quarks, resolution, monitor, (fullStates, prevFullState) -> {
                        for (Map.Entry entryGap : row.entrySet()) {
                            List gapEvents = (List)entryGap.getValue();
                            @NonNull @NonNull TimeGraphEntry entry = (TimeGraphEntry)entryGap.getKey();
                            List<ITimeEvent> eventList = AbstractStateSystemTimeGraphView.this.getEventList(Objects.requireNonNull(entry), ss, fullStates, prevFullState, monitor);
                            if (eventList == null || eventList.isEmpty() || monitor.isCanceled()) continue;
                            AbstractStateSystemTimeGraphView.this.doFilterEventList(entry, eventList, predicates);
                            for (ITimeEvent event : eventList) {
                                int pos = Collections.binarySearch(gapEvents, event, TimeGraphEntry.WITHIN_COMPARATOR);
                                if (pos < 0) continue;
                                ITimeEvent gap = (ITimeEvent)gapEvents.get(pos);
                                if (monitor.isCanceled()) continue;
                                boolean dimmed = gap.isPropertyActive(1);
                                if (dimmed && !event.isPropertyActive(1)) {
                                    gap.setProperty(1, false);
                                }
                                if (!hasActiveSavedFilters || event.isPropertyActive(4)) continue;
                                gap.setProperty(4, false);
                                this.applyResults(() -> entry.updateZoomedEvent(gap));
                            }
                        }
                    });
                    AbstractStateSystemTimeGraphView.this.refresh();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearZoomedLists() {
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List<TimeGraphEntry> entryList = null;
                Map<ITmfStateSystem, List<TimeGraphEntry>> map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                for (TimeGraphEntry entry : entryList) {
                    this.clearZoomedList(entry);
                }
            }
            this.fClearZoomedLists = false;
        }

        private void clearZoomedList(TimeGraphEntry entry) {
            entry.setZoomedEventList(null);
            entry.setSampling(null);
            for (TimeGraphEntry child : entry.getChildren()) {
                this.clearZoomedList(child);
            }
        }

        private boolean isMember(TimeGraphEntry entry, List<TimeGraphEntry> ssEntryList) {
            TimeGraphEntry ssEntry = entry;
            while (ssEntry != null) {
                if (ssEntryList.contains(ssEntry)) {
                    return true;
                }
                ssEntry = ssEntry.getParent();
            }
            return false;
        }
    }
}

