/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.event;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;

public class GenericFtraceAspects {
    private static Iterable<@NonNull ITmfEventAspect<?>> sfAspects;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Iterable<@NonNull ITmfEventAspect<?>> getAspects() {
        @NonNull ImmutableList aspectSet = sfAspects;
        if (aspectSet == null) {
            sfAspects = aspectSet = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)((Object)new FtraceCpuAspect()), (Object)TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect(), (Object)((Object)new FtracePidAspect()));
        }
        return aspectSet;
    }

    private static class FtraceCpuAspect
    extends TmfCpuAspect {
        private FtraceCpuAspect() {
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            if (!(event instanceof GenericFtraceEvent)) {
                return null;
            }
            return ((GenericFtraceEvent)event).getField().getCpu();
        }
    }

    private static class FtracePidAspect
    extends LinuxPidAspect {
        private FtracePidAspect() {
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            if (event instanceof GenericFtraceEvent) {
                GenericFtraceEvent ftraceEvent = (GenericFtraceEvent)event;
                return ftraceEvent.getField().getPid();
            }
            return null;
        }
    }
}

