/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;

public class CASTElaboratedTypeSpecifier
extends CASTBaseDeclSpecifier
implements ICASTElaboratedTypeSpecifier,
IASTCompletionContext {
    private int kind;
    private IASTName name;

    public CASTElaboratedTypeSpecifier() {
    }

    public CASTElaboratedTypeSpecifier(int kind, IASTName name) {
        this.kind = kind;
        this.setName(name);
    }

    @Override
    public CASTElaboratedTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTElaboratedTypeSpecifier copy(IASTNode.CopyStyle style) {
        CASTElaboratedTypeSpecifier copy = new CASTElaboratedTypeSpecifier(this.kind, this.name == null ? null : this.name.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public void setKind(int value) {
        this.assertNotFrozen();
        this.kind = value;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.visitAlignmentSpecifiers(action)) {
            return false;
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        IASTNode node;
        IASTDeclarator[] dtors;
        if (n != this.name) {
            return 3;
        }
        IASTNode parent = this.getParent();
        if (!(parent instanceof IASTDeclaration)) {
            return 1;
        }
        if (parent instanceof IASTSimpleDeclaration && (dtors = ((IASTSimpleDeclaration)parent).getDeclarators()).length == 0) {
            return 0;
        }
        IBinding binding = this.name.resolveBinding();
        if (binding instanceof ICInternalBinding && (node = ((ICInternalBinding)((Object)binding)).getPhysicalNode()) == this.name) {
            return 0;
        }
        return 1;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] result = CVisitor.findBindingsForContentAssist(n, isPrefix);
        int nextPos = 0;
        int i = 0;
        while (i < result.length) {
            IBinding b;
            block16: {
                block15: {
                    b = result[i];
                    if (!(b instanceof ICompositeType)) break block15;
                    ICompositeType ct = (ICompositeType)b;
                    switch (ct.getKey()) {
                        case 1: {
                            if (this.getKind() != 1) {
                                b = null;
                                break;
                            }
                            break block16;
                        }
                        case 2: {
                            if (this.getKind() == 2) break block16;
                            b = null;
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block16;
                }
                if (b instanceof IEnumeration) {
                    if (this.getKind() != 0) {
                        b = null;
                    }
                } else if (b instanceof ITypedef) {
                    b = null;
                }
            }
            if (b != null) {
                result[nextPos++] = b;
            }
            ++i;
        }
        if (nextPos != result.length) {
            IBinding[] copy = new IBinding[nextPos];
            System.arraycopy(result, 0, copy, 0, nextPos);
            return copy;
        }
        return result;
    }
}

