/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.connections;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections.RosConnectionsStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.AbstractRosPresentationProvider;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.Messages;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;

public class RosConnectionsPresentationProvider
extends AbstractRosPresentationProvider {
    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        String label = event.getLabel();
        if (label == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String channelType = event.getEntry().getParent().getParent().getName();
        String connectionName = event.getEntry().getParent().getName();
        String nodeName = event.getEntry().getParent().getParent().getParent().getName();
        Pair<String, String> localRemoteHost = RosConnectionsPresentationProvider.getLocalAndRemoteHosts(label);
        builder.put((Object)Messages.AbstractRosPresentationProvider_ConnectionChannelType, (Object)channelType);
        builder.put((Object)Messages.AbstractRosPresentationProvider_ConnectionName, (Object)connectionName);
        builder.put((Object)Messages.AbstractRosPresentationProvider_NodeName, (Object)nodeName);
        builder.put((Object)Messages.AbstractRosPresentationProvider_ConnectionHosts, (Object)"");
        builder.put((Object)("\t" + Messages.AbstractRosPresentationProvider_ConnectionHostLocal), (Object)((String)localRemoteHost.getFirst()));
        builder.put((Object)("\t" + Messages.AbstractRosPresentationProvider_ConnectionHostRemote), (Object)((String)localRemoteHost.getSecond()));
        return builder.build();
    }

    private static Pair<String, String> getLocalAndRemoteHosts(String label) {
        @NonNull String[] remoteLocal = label.split(RosConnectionsStateProvider.CONNECTION_HOST_SEPARATOR);
        return new Pair((Object)remoteLocal[0], (Object)remoteLocal[1]);
    }
}

