/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.spawner.Spawner;

class SpawnerInputStream
extends InputStream {
    private Spawner.IChannel channel;

    static {
        System.loadLibrary("spawner");
    }

    public SpawnerInputStream(Spawner.IChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.channel == null) {
            return -1;
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = off > 0 ? new byte[len] : buf;
        len = this.read0(this.channel, tmpBuf, len);
        if (len <= 0) {
            return -1;
        }
        if (tmpBuf != buf) {
            System.arraycopy(tmpBuf, 0, buf, off, len);
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        int status = this.close0(this.channel);
        if (status == -1) {
            throw new IOException(Messages.Util_exception_closeError);
        }
        this.channel = null;
    }

    @Override
    public int available() throws IOException {
        if (this.channel == null) {
            return 0;
        }
        try {
            return this.available0(this.channel);
        }
        catch (UnsatisfiedLinkError e) {
            return super.available();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native int read0(Spawner.IChannel var1, byte[] var2, int var3) throws IOException;

    private native int close0(Spawner.IChannel var1) throws IOException;

    private native int available0(Spawner.IChannel var1) throws IOException;
}

