/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferencePage;
import org.eclipse.ui.internal.util.PrefUtil;

public class EditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Composite editorReuseGroup;
    private Button reuseEditors;
    protected Button useIPersistableEditor;
    private Composite editorReuseIndentGroup;
    private Composite editorReuseThresholdGroup;
    private IntegerFieldEditor reuseEditorsThreshold;
    private IntegerFieldEditor recentFilesEditor;
    private IPropertyChangeListener validityChangeListener = event -> {
        if (event.getProperty().equals("field_editor_is_valid")) {
            this.updateValidState();
        }
    };
    private Button promptWhenStillOpenEditor;
    private Button allowInplaceEditor;
    private ComboFieldEditor multiPageEditorTabPositionComboField;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createEditorHistoryGroup(composite);
        this.createSpace(composite);
        this.createAllowInplaceEditorPref(composite);
        this.createUseIPersistablePref(composite);
        this.createPromptWhenStillOpenPref(composite);
        this.createEditorReuseGroup(composite);
        this.updateValidState();
        this.applyDialogFont(composite);
        this.setHelpContext(parent);
        return composite;
    }

    protected void setHelpContext(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.workbench_editor_preference_page_context");
    }

    protected void createSpace(Composite parent) {
        WorkbenchPreferencePage.createSpace(parent);
    }

    protected void createAllowInplaceEditorPref(Composite composite) {
        this.allowInplaceEditor = new Button(composite, 32);
        this.allowInplaceEditor.setText(WorkbenchMessages.WorkbenchPreference_allowInplaceEditingButton);
        this.allowInplaceEditor.setSelection(!this.getAPIPreferenceStore().getBoolean("DISABLE_OPEN_EDITOR_IN_PLACE"));
        this.setButtonLayoutData(this.allowInplaceEditor);
    }

    protected void createUseIPersistablePref(Composite composite) {
        this.useIPersistableEditor = new Button(composite, 32);
        this.useIPersistableEditor.setText(WorkbenchMessages.WorkbenchPreference_useIPersistableEditorButton);
        this.useIPersistableEditor.setSelection(this.getPreferenceStore().getBoolean("USE_IPERSISTABLE_EDITORS"));
        this.setButtonLayoutData(this.useIPersistableEditor);
    }

    protected void createPromptWhenStillOpenPref(Composite composite) {
        this.promptWhenStillOpenEditor = new Button(composite, 32);
        this.promptWhenStillOpenEditor.setText(WorkbenchMessages.WorkbenchPreference_promptWhenStillOpenButton);
        this.promptWhenStillOpenEditor.setSelection(this.getAPIPreferenceStore().getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN"));
        this.setButtonLayoutData(this.promptWhenStillOpenEditor);
    }

    protected void createAlignMultiPageEditorTabs(Composite parent) {
        Composite comboComposite = new Composite(parent, 0);
        comboComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        comboComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        String name = "ALIGN_MULTI_PAGE_EDITOR_TABS";
        String label = WorkbenchMessages.WorkbenchPreference_AlignMultiPageEditorTabs;
        String[][] namesAndValues = new String[][]{{Action.removeMnemonics((String)WorkbenchMessages.WorkbenchPreference_AlignMultiPageEditorTabs_Top), String.valueOf(128)}, {Action.removeMnemonics((String)WorkbenchMessages.WorkbenchPreference_AlignMultiPageEditorTabs_Bottom), String.valueOf(1024)}};
        this.multiPageEditorTabPositionComboField = new ComboFieldEditor(name, label, namesAndValues, comboComposite);
        this.multiPageEditorTabPositionComboField.setPreferenceStore(this.getAPIPreferenceStore());
        this.multiPageEditorTabPositionComboField.setPage((DialogPage)this);
        this.multiPageEditorTabPositionComboField.load();
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        return composite;
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.allowInplaceEditor.setSelection(!this.getAPIPreferenceStore().getDefaultBoolean("DISABLE_OPEN_EDITOR_IN_PLACE"));
        this.useIPersistableEditor.setSelection(store.getDefaultBoolean("USE_IPERSISTABLE_EDITORS"));
        this.promptWhenStillOpenEditor.setSelection(this.getAPIPreferenceStore().getDefaultBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN"));
        this.reuseEditors.setSelection(store.getDefaultBoolean("REUSE_OPEN_EDITORS_BOOLEAN"));
        this.reuseEditorsThreshold.loadDefault();
        this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.getTextControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.recentFilesEditor.loadDefault();
        this.multiPageEditorTabPositionComboField.loadDefault();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.multiPageEditorTabPositionComboField.store();
        this.getAPIPreferenceStore().setValue("DISABLE_OPEN_EDITOR_IN_PLACE", !this.allowInplaceEditor.getSelection());
        store.setValue("USE_IPERSISTABLE_EDITORS", this.useIPersistableEditor.getSelection());
        this.getAPIPreferenceStore().setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", this.promptWhenStillOpenEditor.getSelection());
        store.setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.store();
        this.recentFilesEditor.store();
        PrefUtil.savePrefs();
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected IPreferenceStore getAPIPreferenceStore() {
        return PrefUtil.getAPIPreferenceStore();
    }

    protected void updateValidState() {
        if (!this.recentFilesEditor.isValid()) {
            this.setErrorMessage(this.recentFilesEditor.getErrorMessage());
            this.setValid(false);
        } else if (!this.reuseEditorsThreshold.isValid()) {
            this.setErrorMessage(this.reuseEditorsThreshold.getErrorMessage());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    protected void createEditorReuseGroup(Composite composite) {
        this.editorReuseGroup = new Composite(composite, 16384);
        this.editorReuseGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(0, 0).create());
        this.editorReuseGroup.setLayoutData((Object)new GridData(768));
        this.reuseEditors = new Button(this.editorReuseGroup, 32);
        this.reuseEditors.setText(WorkbenchMessages.WorkbenchPreference_reuseEditors);
        this.reuseEditors.setLayoutData((Object)new GridData());
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.reuseEditors.setSelection(store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN"));
        this.reuseEditors.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
            this.reuseEditorsThreshold.getTextControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        }));
        this.editorReuseIndentGroup = new Composite(this.editorReuseGroup, 16384);
        this.editorReuseIndentGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.editorReuseIndentGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.editorReuseThresholdGroup = new Composite(this.editorReuseIndentGroup, 16384);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.editorReuseThresholdGroup.setLayout((Layout)layout);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData.widthHint = 35;
        this.editorReuseThresholdGroup.setLayoutData((Object)gridData);
        this.reuseEditorsThreshold = new IntegerFieldEditor("REUSE_OPEN_EDITORS", "", this.editorReuseThresholdGroup);
        this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).dispose();
        this.reuseEditorsThreshold.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.reuseEditorsThreshold.setPage((DialogPage)this);
        this.reuseEditorsThreshold.setTextLimit(2);
        this.reuseEditorsThreshold.setErrorMessage(WorkbenchMessages.WorkbenchPreference_reuseEditorsThresholdError);
        this.reuseEditorsThreshold.setValidateStrategy(0);
        this.reuseEditorsThreshold.setValidRange(1, 99);
        this.reuseEditorsThreshold.load();
        this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.getTextControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.setPropertyChangeListener(this.validityChangeListener);
        LabelFactory.newLabel((int)0).text(WorkbenchMessages.WorkbenchPreference_reuseEditors_closing).create((Widget)this.editorReuseGroup);
    }

    protected void createEditorHistoryGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.recentFilesEditor = new IntegerFieldEditor("RECENT_FILES", WorkbenchMessages.WorkbenchPreference_recentFiles, groupComposite);
        this.recentFilesEditor.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.recentFilesEditor.setPage((DialogPage)this);
        this.recentFilesEditor.setTextLimit(Integer.toString(100).length());
        this.recentFilesEditor.setErrorMessage(NLS.bind((String)WorkbenchMessages.WorkbenchPreference_recentFilesError, (Object)100));
        this.recentFilesEditor.setValidateStrategy(0);
        this.recentFilesEditor.setValidRange(0, 100);
        this.recentFilesEditor.load();
        this.recentFilesEditor.setPropertyChangeListener(this.validityChangeListener);
    }
}

