/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.statistics;

import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.statistics.NumberComparator;

public class Statistics<@NonNull E>
implements IStatistics<E> {
    private static final NumberComparator COMPARATOR = new NumberComparator();
    private final Function<E, @Nullable ? extends Number> fMapper;
    private @Nullable E fMin = null;
    private @Nullable E fMax = null;
    private Number fMinNum = Long.MAX_VALUE;
    private Number fMaxNum = Long.MIN_VALUE;
    private long fNbElements = 0L;
    private double fMean = 0.0;
    private double fVariance = 0.0;
    private double fTotal = 0.0;

    public Statistics() {
        this(e -> {
            if (!(e instanceof Number)) {
                throw new IllegalStateException("The object " + e + " is not a number");
            }
            return (Number)e;
        });
    }

    public Statistics(Function<E, @Nullable ? extends @Nullable Number> mapper) {
        this.fMapper = mapper;
    }

    @Override
    public long getMin() {
        return this.fMinNum.longValue();
    }

    @Override
    public Number getMaxNumber() {
        return this.fMaxNum;
    }

    @Override
    public long getMax() {
        return this.fMaxNum.longValue();
    }

    @Override
    public Number getMinNumber() {
        return this.fMinNum;
    }

    @Override
    public @Nullable E getMinObject() {
        return this.fMin;
    }

    @Override
    public @Nullable E getMaxObject() {
        return this.fMax;
    }

    @Override
    public long getNbElements() {
        return this.fNbElements;
    }

    @Override
    public double getMean() {
        return this.fMean;
    }

    @Override
    public double getStdDev() {
        return this.fNbElements > 2L ? Math.sqrt(this.fVariance / (double)(this.fNbElements - 1L)) : Double.NaN;
    }

    @Override
    public double getTotal() {
        return this.fTotal;
    }

    @Override
    public void update(E object) {
        Number number = this.fMapper.apply(object);
        if (number == null) {
            return;
        }
        double doubleValue = number.doubleValue();
        this.updateMin(object, number);
        this.updateMax(object, number);
        ++this.fNbElements;
        double delta = doubleValue - this.fMean;
        this.fMean += delta / (double)this.fNbElements;
        this.fVariance += delta * (doubleValue - this.fMean);
        this.fTotal += doubleValue;
    }

    private void updateMax(@Nullable E object, Number number) {
        if (object == null) {
            return;
        }
        @Nullable E max = this.fMax;
        if (max == null || COMPARATOR.compare(number, this.fMaxNum) > 0) {
            this.fMax = object;
            this.fMaxNum = number;
        }
    }

    private void updateMin(@Nullable E object, Number number) {
        if (object == null) {
            return;
        }
        @Nullable E min = this.fMin;
        if (min == null || COMPARATOR.compare(number, this.fMinNum) < 0) {
            this.fMin = object;
            this.fMinNum = number;
        }
    }

    @Override
    public void merge(IStatistics<E> o) {
        if (!(o instanceof Statistics)) {
            throw new IllegalArgumentException("Can only merge statistics of the same class");
        }
        Statistics other = (Statistics)o;
        if (other.fNbElements == 0L) {
            return;
        }
        if (this.fNbElements == 0L) {
            this.copy(other);
        } else if (other.fNbElements == 1L) {
            this.update(NonNullUtils.checkNotNull(other.getMaxObject()));
        } else if (this.fNbElements == 1L) {
            Statistics<Object> copyOther = new Statistics<Object>(this.fMapper);
            copyOther.copy(other);
            copyOther.update(NonNullUtils.checkNotNull(this.getMaxObject()));
            this.copy(copyOther);
        } else {
            this.internalMerge(other);
        }
    }

    private void internalMerge(Statistics<E> other) {
        this.updateMin(other.getMinObject(), other.fMinNum);
        this.updateMax(other.getMaxObject(), other.fMaxNum);
        long oldNbSeg = this.fNbElements;
        double oldAverage = this.fMean;
        long otherSegments = other.getNbElements();
        double otherAverage = other.getMean();
        this.fNbElements += otherSegments;
        this.fTotal += other.getTotal();
        this.fMean = ((double)oldNbSeg * oldAverage + otherAverage * (double)otherSegments) / (double)this.fNbElements;
        double avg1Sq = oldAverage * oldAverage;
        double avg2sq = otherAverage * otherAverage;
        double avgtSq = this.fMean * this.fMean;
        double variance1 = this.fVariance / (double)(oldNbSeg - 1L);
        double variance2 = other.fVariance / (double)(otherSegments - 1L);
        this.fVariance = (variance1 + avg1Sq - avgtSq) * (double)(oldNbSeg - 1L) + (variance2 + avg2sq - avgtSq) * (double)(otherSegments - 1L);
    }

    private void copy(Statistics<E> copyOther) {
        this.fMean = copyOther.fMean;
        this.fMax = copyOther.fMax;
        this.fMin = copyOther.fMin;
        this.fMinNum = copyOther.fMinNum;
        this.fMaxNum = copyOther.fMaxNum;
        this.fNbElements = copyOther.fNbElements;
        this.fTotal = copyOther.fTotal;
        this.fVariance = copyOther.fVariance;
    }

    public String toString() {
        return this.getClass() + ": Avg: " + this.getMean() + " on " + this.getNbElements() + " elements";
    }
}

