/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.GraphTreeNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.HTNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.HtIo;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdgeInterval;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfVertex;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.exceptions.RangeException;

public class GraphHistoryTree {
    private static final int HISTORY_MAGIC_NUMBER = 100647134;
    private static final int FILE_VERSION = 1;
    private static final int TREE_HEADER_SIZE = 4096;
    private final File fHistoryFile;
    private final int fBlockSize;
    private final int fMaxChildren;
    private final int fProviderVersion;
    private final long fTreeStart;
    private final IHTIntervalReader<TmfEdgeInterval> fEdgeIntervalReader;
    private HtIo fTreeIO;
    private long fTreeEnd;
    private int fNodeCount;
    private final List<GraphTreeNode> fLatestBranch;
    private final ReentrantReadWriteLock fRwl;
    private transient @Nullable List<GraphTreeNode> fLatestBranchSnapshot;

    public GraphHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart, IHTIntervalReader<TmfEdgeInterval> edgeIntervalReader) throws IOException {
        this.fRwl = new ReentrantReadWriteLock(false);
        this.fLatestBranchSnapshot = null;
        if (blockSize < 4096) {
            throw new IllegalArgumentException();
        }
        this.fHistoryFile = stateHistoryFile;
        this.fBlockSize = blockSize;
        this.fMaxChildren = maxChildren;
        this.fProviderVersion = providerVersion;
        this.fTreeStart = treeStart;
        this.fEdgeIntervalReader = edgeIntervalReader;
        this.fTreeEnd = treeStart;
        this.fNodeCount = 0;
        this.fLatestBranch = (List)NonNullUtils.checkNotNull(Collections.synchronizedList(new ArrayList()));
        this.fTreeIO = new HtIo(stateHistoryFile, blockSize, maxChildren, true, this.getNodeFactory(), this.fEdgeIntervalReader);
        GraphTreeNode firstNode = this.initNewLeafNode(-1, treeStart);
        this.fLatestBranch.add(firstNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphHistoryTree(File existingStateFile, int expectedProviderVersion, IHTIntervalReader<TmfEdgeInterval> edgeIntervalReader) throws IOException {
        long startTime;
        int rootNodeSeqNb;
        block19: {
            this.fRwl = new ReentrantReadWriteLock(false);
            this.fLatestBranchSnapshot = null;
            if (!existingStateFile.exists()) {
                throw new IOException("Selected state file does not exist");
            }
            if (existingStateFile.length() <= 0L) {
                throw new IOException("Empty target file");
            }
            Throwable throwable = null;
            Object var11_6 = null;
            try {
                FileInputStream fis = new FileInputStream(existingStateFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(4096);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.clear();
                        int res = fc.read(buffer);
                        if (res != 4096) {
                            throw new IOException("Invalid header size");
                        }
                        buffer.flip();
                        res = buffer.getInt();
                        if (res != 100647134) {
                            throw new IOException("Wrong magic number");
                        }
                        res = buffer.getInt();
                        if (res != 1) {
                            throw new IOException("Mismatching History Tree file format versions");
                        }
                        res = buffer.getInt();
                        if (res != expectedProviderVersion) {
                            throw new IOException("Mismatching event handler versions");
                        }
                        int bs = buffer.getInt();
                        int maxc = buffer.getInt();
                        this.fNodeCount = buffer.getInt();
                        rootNodeSeqNb = buffer.getInt();
                        startTime = buffer.getLong();
                        this.fHistoryFile = existingStateFile;
                        this.fBlockSize = bs;
                        this.fMaxChildren = maxc;
                        this.fProviderVersion = expectedProviderVersion;
                        this.fTreeStart = startTime;
                        this.fEdgeIntervalReader = edgeIntervalReader;
                    }
                    if (fis == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.fTreeIO = new HtIo(this.fHistoryFile, this.fBlockSize, this.fMaxChildren, false, this.getNodeFactory(), this.fEdgeIntervalReader);
        this.fLatestBranch = this.buildLatestBranch(rootNodeSeqNb);
        this.fTreeEnd = this.getRootNode().getNodeEnd();
        if (startTime == this.getRootNode().getNodeStart()) return;
        throw new IOException("Inconsistent start times in the history file, it might be corrupted.");
    }

    private List<GraphTreeNode> buildLatestBranch(int rootNodeSeqNb) throws ClosedChannelException {
        ArrayList<GraphTreeNode> list = new ArrayList<GraphTreeNode>();
        GraphTreeNode nextChildNode = this.fTreeIO.readNode(rootNodeSeqNb);
        list.add(nextChildNode);
        while (nextChildNode.getNodeType() == HTNode.NodeType.CORE) {
            nextChildNode = this.fTreeIO.readNode(nextChildNode.getLatestChild());
            list.add(nextChildNode);
        }
        return Collections.synchronizedList(list);
    }

    public long getTreeStart() {
        return this.fTreeStart;
    }

    public long getTreeEnd() {
        return this.fTreeEnd;
    }

    public int getNodeCount() {
        return this.fNodeCount;
    }

    public GraphTreeNode getRootNode() {
        return this.fLatestBranch.get(0);
    }

    public long getFileSize() {
        return this.fHistoryFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected final List<GraphTreeNode> getLatestBranch() {
        ImmutableList latestBranchSnapshot = this.fLatestBranchSnapshot;
        if (latestBranchSnapshot == null) {
            List<GraphTreeNode> list = this.fLatestBranch;
            synchronized (list) {
                this.fLatestBranchSnapshot = latestBranchSnapshot = ImmutableList.copyOf(this.fLatestBranch);
            }
        }
        return latestBranchSnapshot;
    }

    protected GraphTreeNode getLatestNode(int depth) {
        if (depth > this.fLatestBranch.size()) {
            throw new IndexOutOfBoundsException("Trying to get latest node too deep");
        }
        return this.fLatestBranch.get(depth);
    }

    protected HTNode.IHTNodeFactory<GraphTreeNode> getNodeFactory() {
        return (t, b, m, seq, p, start) -> new GraphTreeNode(t, b, m, seq, p, start);
    }

    @VisibleForTesting
    protected GraphTreeNode getNode(int seqNum) throws ClosedChannelException {
        for (GraphTreeNode node : this.fLatestBranch) {
            if (node.getSequenceNumber() != seqNum) continue;
            return node;
        }
        return this.fTreeIO.readNode(seqNum);
    }

    @VisibleForTesting
    HtIo getTreeIO() {
        return this.fTreeIO;
    }

    public FileInputStream supplyATReader() {
        this.fRwl.readLock().lock();
        try {
            FileInputStream fileInputStream = this.fTreeIO.supplyATReader(this.getNodeCount());
            return fileInputStream;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public File supplyATWriterFile() {
        return this.fHistoryFile;
    }

    public long supplyATWriterFilePos() {
        return 4096L + (long)this.getNodeCount() * (long)this.fBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphTreeNode readNode(int seqNumber) throws ClosedChannelException {
        List<GraphTreeNode> list = this.fLatestBranch;
        synchronized (list) {
            for (GraphTreeNode node : this.fLatestBranch) {
                if (node.getSequenceNumber() != seqNumber) continue;
                return node;
            }
        }
        this.fRwl.readLock().lock();
        try {
            GraphTreeNode graphTreeNode = this.fTreeIO.readNode(seqNumber);
            return graphTreeNode;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public void writeNode(GraphTreeNode node) {
        this.fRwl.readLock().lock();
        try {
            this.fTreeIO.writeNode(node);
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public void closeFile() {
        this.fRwl.writeLock().lock();
        try {
            this.fTreeIO.closeFile();
            this.clearContent();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void deleteFile() {
        this.fRwl.writeLock().lock();
        try {
            this.fTreeIO.deleteFile();
            this.clearContent();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void cleanFile() throws IOException {
        this.fRwl.writeLock().lock();
        try {
            this.closeTree(this.fTreeEnd);
            this.fTreeIO.deleteFile();
            this.fTreeIO = new HtIo(this.fHistoryFile, this.fBlockSize, this.fMaxChildren, true, this.getNodeFactory(), this.fEdgeIntervalReader);
            this.clearContent();
            GraphTreeNode firstNode = this.initNewLeafNode(-1, this.fTreeStart);
            this.fLatestBranch.add(firstNode);
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    private void clearContent() {
        this.fNodeCount = 0;
        this.fLatestBranch.clear();
    }

    public synchronized void insert(TmfEdgeInterval interval) throws RangeException {
        if (interval.getStart() < this.fTreeStart) {
            throw new RangeException("Interval Start:" + interval.getStart() + ", Config Start:" + this.fTreeStart);
        }
        this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
    }

    protected final GraphTreeNode initNewCoreNode(int parentSeqNumber, long startTime) {
        GraphTreeNode newNode = this.getNodeFactory().createNode(HTNode.NodeType.CORE, this.fBlockSize, this.fMaxChildren, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    protected final GraphTreeNode initNewLeafNode(int parentSeqNumber, long startTime) {
        GraphTreeNode newNode = this.getNodeFactory().createNode(HTNode.NodeType.LEAF, this.fBlockSize, this.fMaxChildren, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    protected final void tryInsertAtNode(TmfEdgeInterval interval, int depth) {
        GraphTreeNode targetNode = this.fLatestBranch.get(depth);
        this.informInsertingAtDepth(depth);
        if (interval.getSizeOnDisk() > targetNode.getNodeFreeSpace()) {
            this.addSiblingNode(depth, this.getNewBranchStart(depth, interval));
            this.tryInsertAtNode(interval, this.getLatestBranch().size() - 1);
            return;
        }
        if (interval.getStart() < targetNode.getNodeStart()) {
            this.tryInsertAtNode(interval, depth - 1);
            return;
        }
        targetNode.add(interval);
        this.updateEndTime(interval);
    }

    @VisibleForTesting
    protected void informInsertingAtDepth(int depth) {
    }

    private long getNewBranchStart(int depth, TmfEdgeInterval interval) {
        return Math.max(interval.getStart(), this.getLatestNode(depth).getNodeStart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSiblingNode(int depth, long newNodeStartTime) {
        List<GraphTreeNode> list = this.fLatestBranch;
        synchronized (list) {
            long splitTime = this.fTreeEnd;
            this.fLatestBranchSnapshot = null;
            if (depth >= this.fLatestBranch.size()) {
                throw new IllegalStateException();
            }
            if (depth == 0) {
                this.addNewRootNode(newNodeStartTime);
                return;
            }
            if (this.fLatestBranch.get(depth - 1).getNbChildren() == this.fMaxChildren || newNodeStartTime < this.fLatestBranch.get(depth - 1).getNodeStart()) {
                this.addSiblingNode(depth - 1, newNodeStartTime);
                return;
            }
            int i = this.fLatestBranch.size() - 1;
            while (i >= depth) {
                this.fLatestBranch.get(i).closeThisNode(splitTime);
                this.fTreeIO.writeNode(this.fLatestBranch.get(i));
                --i;
            }
            i = depth;
            while (i < this.fLatestBranch.size()) {
                GraphTreeNode newNode;
                GraphTreeNode prevNode = this.fLatestBranch.get(i - 1);
                switch (this.fLatestBranch.get(i).getNodeType()) {
                    case CORE: {
                        newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    case LEAF: {
                        newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                prevNode.linkNewChild(newNode);
                this.fLatestBranch.set(i, newNode);
                ++i;
            }
        }
    }

    private void addNewRootNode(long newNodeStartTime) {
        long nodeEnd = this.fTreeEnd;
        GraphTreeNode oldRootNode = this.fLatestBranch.get(0);
        GraphTreeNode newRootNode = this.initNewCoreNode(-1, this.fTreeStart);
        oldRootNode.setParentSequenceNumber(newRootNode.getSequenceNumber());
        int i = this.fLatestBranch.size() - 1;
        while (i >= 0) {
            this.fLatestBranch.get(i).closeThisNode(nodeEnd);
            this.fTreeIO.writeNode(this.fLatestBranch.get(i));
            --i;
        }
        newRootNode.linkNewChild(oldRootNode);
        int depth = this.fLatestBranch.size();
        this.fLatestBranch.clear();
        this.fLatestBranch.add(newRootNode);
        int i2 = 1;
        while (i2 < depth) {
            GraphTreeNode prevNode = this.fLatestBranch.get(i2 - 1);
            GraphTreeNode newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
            prevNode.linkNewChild(newNode);
            this.fLatestBranch.add(newNode);
            ++i2;
        }
        GraphTreeNode prevNode = this.fLatestBranch.get(depth - 1);
        GraphTreeNode newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
        prevNode.linkNewChild(newNode);
        this.fLatestBranch.add(newNode);
    }

    protected void updateEndTime(TmfEdgeInterval interval) {
        this.fTreeEnd = Math.max(this.fTreeEnd, interval.getEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTree(long requestedEndTime) {
        List<GraphTreeNode> list = this.fLatestBranch;
        synchronized (list) {
            this.fTreeEnd = requestedEndTime;
            int i = this.fLatestBranch.size() - 1;
            while (i >= 0) {
                this.fLatestBranch.get(i).closeThisNode(this.fTreeEnd);
                this.fTreeIO.writeNode(this.fLatestBranch.get(i));
                --i;
            }
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (FileOutputStream fc = this.fTreeIO.getFileWriter(-1);){
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.clear();
                    buffer.putInt(100647134);
                    buffer.putInt(1);
                    buffer.putInt(this.fProviderVersion);
                    buffer.putInt(this.fBlockSize);
                    buffer.putInt(this.fMaxChildren);
                    buffer.putInt(this.fNodeCount);
                    buffer.putInt(this.fLatestBranch.get(0).getSequenceNumber());
                    buffer.putLong(this.fLatestBranch.get(0).getNodeStart());
                    buffer.flip();
                    fc.write(buffer.array());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("State system write error");
            }
        }
    }

    public int size() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.getNodeCount()) {
                GraphTreeNode node = this.readNode(seq);
                total += (long)node.getNumIntervals();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            return 0;
        }
        return (int)total;
    }

    private @Nullable TmfEdgeInterval queryEdge(long ts, Predicate<TmfEdgeInterval> predicate, boolean tsIsExactEnd) throws ClosedChannelException {
        TimeRangeCondition rc = TimeRangeCondition.singleton((long)ts);
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(this.getRootNode().getSequenceNumber());
        TmfEdgeInterval interval = null;
        while (interval == null && !queue.isEmpty()) {
            int sequenceNumber = (Integer)queue.pop();
            GraphTreeNode currentNode = this.readNode(sequenceNumber);
            if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                queue.addAll(currentNode.selectNextChildren(rc));
            }
            interval = currentNode.getMatchingInterval(ts, predicate, tsIsExactEnd);
        }
        return interval;
    }

    public @Nullable TmfEdgeInterval queryEdgeFrom(TmfVertex vertex, boolean horizontal) throws ClosedChannelException {
        long ts = vertex.getTimestamp();
        Predicate<TmfEdgeInterval> predicate = horizontal ? edge -> edge.getIntervalType() != TmfEdgeInterval.EdgeIntervalType.VERTICAL && edge.getStart() == ts && edge.getFromWorkerId() == vertex.getWorkerId() : edge -> edge.getIntervalType() == TmfEdgeInterval.EdgeIntervalType.VERTICAL && edge.getStart() == ts && edge.getFromWorkerId() == vertex.getWorkerId();
        return this.queryEdge(ts, predicate, false);
    }

    public @Nullable TmfEdgeInterval queryVertex(TmfVertex vertex) throws ClosedChannelException {
        return this.queryEdge(vertex.getTimestamp(), edge -> edge.getStart() == vertex.getTimestamp() && edge.getFromWorkerId() == vertex.getWorkerId() || edge.getEnd() == vertex.getTimestamp() && edge.getToWorkerId() == vertex.getWorkerId(), false);
    }

    public @Nullable TmfEdgeInterval queryEdgeTo(TmfVertex vertex, boolean horizontal) throws ClosedChannelException {
        long ts = vertex.getTimestamp();
        Predicate<TmfEdgeInterval> predicate = horizontal ? edge -> edge.getIntervalType() != TmfEdgeInterval.EdgeIntervalType.VERTICAL && edge.getEnd() == ts && edge.getToWorkerId() == vertex.getWorkerId() : edge -> edge.getIntervalType() == TmfEdgeInterval.EdgeIntervalType.VERTICAL && edge.getEnd() == ts && edge.getToWorkerId() == vertex.getWorkerId();
        return this.queryEdge(ts, predicate, true);
    }

    public String toString() {
        return "Information on the current tree:\n\nBlocksize: " + this.fBlockSize + "\n" + "Max nb. of children per node: " + this.fMaxChildren + "\n" + "Number of nodes: " + this.fNodeCount + "\n" + "Depth of the tree: " + this.fLatestBranch.size() + "\n" + "Size of the treefile: " + this.getFileSize() + "\n" + "Root node has sequence number: " + this.fLatestBranch.get(0).getSequenceNumber() + "\n" + "'Latest leaf' has sequence number: " + this.fLatestBranch.get(this.fLatestBranch.size() - 1).getSequenceNumber();
    }
}

