/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.cdt.internal.formatter.InactivePosition;
import org.eclipse.cdt.internal.formatter.Location;
import org.eclipse.cdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.cdt.internal.formatter.align.Alignment;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe {
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final int INITIAL_SIZE = 100;
    private final DefaultCodeFormatterOptions preferences;
    public final Scanner scanner;
    public int column = 1;
    public Alignment currentAlignment;
    public Alignment memberAlignment;
    public AlignmentException currentAlignmentException;
    private Runnable tailFormatter;
    public Token currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    public int indentationLevel;
    public int numberOfIndentations;
    public int indentationSize;
    private final String lineSeparator;
    private final boolean indentEmptyLines;
    private final int pageWidth;
    private boolean preserveNewLines;
    private boolean checkLineWrapping;
    public int lastNumberOfNewLines;
    private boolean preserveLineBreakIndentation;
    boolean formatBrace;
    public int line;
    public boolean needSpace;
    public boolean pendingSpace;
    public int tabLength;
    public int tabChar;
    private final boolean useTabsOnlyForLeadingIndents;
    private int textRegionEnd;
    private int textRegionStart;
    public int scannerEndPosition;
    private List<InactivePosition> fSkipInactivePositions = Collections.emptyList();
    private boolean inactiveState = false;
    private boolean skipOverInactive;
    private int fSkipStartOffset = Integer.MAX_VALUE;
    private int fSkipEndOffset;
    private int fSkippedIndentations;
    private static final int NO_TRAILING_COMMENT = 0;
    private static final int BASIC_TRAILING_COMMENT = 256;
    private int[] lineOffsets;
    private int numLines;
    final LineComment lastLineComment = new LineComment();

    Scribe(CodeFormatterVisitor formatter, int offset, int length) {
        this.scanner = new Scanner();
        this.preferences = formatter.preferences;
        this.pageWidth = this.preferences.page_width;
        this.tabLength = this.preferences.tab_size;
        this.indentationLevel = 0;
        this.numberOfIndentations = 0;
        this.useTabsOnlyForLeadingIndents = this.preferences.use_tabs_only_for_leading_indentations;
        this.indentEmptyLines = this.preferences.indent_empty_lines;
        this.tabChar = this.preferences.tab_char;
        this.indentationSize = this.tabChar == 4 ? this.preferences.indentation_size : this.tabLength;
        this.lineSeparator = this.preferences.line_separator;
        this.indentationLevel = this.preferences.initial_indentation_level * this.indentationSize;
        this.preserveNewLines = false;
        this.textRegionStart = offset;
        this.textRegionEnd = offset + length;
        this.reset();
    }

    private final void addDeleteEdit(int start, int end) {
        if (!this.inactiveState) {
            this.addOptimizedReplaceEdit(start, end - start + 1, EMPTY_STRING);
        }
    }

    public final void addInsertEdit(int insertPosition, CharSequence insertedString) {
        if (!this.inactiveState) {
            this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
        }
    }

    public final void addReplaceEdit(int start, int end, CharSequence replacement) {
        if (!this.inactiveState) {
            this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
        }
    }

    private final void addOptimizedReplaceEdit(int offset, int length, CharSequence replacement) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        --this.editsIndex;
                        this.appendOptimizedReplaceEdit(previousOffset, previousLength + length, String.valueOf(previousReplacement) + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        int i = previousOffset;
                        while (i < previousOffset + previousReplacementLength) {
                            if (this.scanner.source[i] != previousReplacement.charAt(i - previousOffset)) {
                                --this.editsIndex;
                                this.appendOptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                                canBeRemoved = false;
                                break;
                            }
                            ++i;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        --this.editsIndex;
                        this.appendOptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    --this.editsIndex;
                    this.appendOptimizedReplaceEdit(previousOffset, previousLength, String.valueOf(previousReplacement) + replacement);
                }
            } else {
                assert (endOffsetOfPreviousEdit < offset);
                this.appendOptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.appendOptimizedReplaceEdit(offset, length, replacement);
        }
    }

    private void appendOptimizedReplaceEdit(int offset, int length, CharSequence replacement) {
        int replacementLength = replacement.length();
        int i = 0;
        while (i < length && i < replacementLength) {
            if (this.scanner.source[offset] != replacement.charAt(i)) break;
            ++i;
            ++offset;
        }
        length -= i;
        if (i > 0) {
            CharSequence charSequence = replacement = i == replacementLength ? EMPTY_STRING : replacement.subSequence(i, replacementLength);
        }
        if (length > 0 || replacement.length() > 0) {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.alignFragment(fragmentIndex);
    }

    public void consumeNextToken() {
        this.printComment();
        this.currentToken = this.scanner.nextToken();
        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if ((current.mode & 0x100) != 0) {
                int indentSize = this.indentationSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (current.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int indentSize = this.indentationSize;
                        switch (current.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment alignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        alignment.breakIndentationLevel = this.indentationLevel;
        return alignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.numberOfIndentations = alignment.location.numberOfIndentations;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.numberOfIndentations = current.location.numberOfIndentations;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    private int getIndentationOfOffset(int offset) {
        int beginningOfLine = this.getLineStart(offset);
        int indent = 0;
        int i = beginningOfLine;
        while (i < offset) {
            indent = this.computeIndentation(this.scanner.source[i], indent);
            ++i;
        }
        return indent;
    }

    private int computeIndentation(char c, int indent) {
        switch (c) {
            case '\t': {
                return this.tabLength > 0 ? indent + this.tabLength - indent % this.tabLength : indent;
            }
            case '\n': 
            case '\r': {
                return 0;
            }
        }
        return indent + 1;
    }

    private int computeIndentation(char[] text, int indent) {
        if (text == null) {
            return indent;
        }
        int length = text.length;
        int i = 0;
        while (i < length) {
            indent = this.computeIndentation(text[i], indent);
            ++i;
        }
        return indent;
    }

    private int computeIndentation(CharSequence text, int indent) {
        if (text == null) {
            return indent;
        }
        int length = text.length();
        int i = 0;
        while (i < length) {
            indent = this.computeIndentation(text.charAt(i), indent);
            ++i;
        }
        return indent;
    }

    public String getEmptyLines(int linesNumber) {
        StringBuilder buffer = new StringBuilder();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return EMPTY_STRING;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            int i = 0;
            while (i < realNewLineNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        }
        return String.valueOf(buffer);
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int someColumn) {
        int indent = someColumn - 1;
        if (indent == 0) {
            return this.indentationLevel;
        }
        if (this.tabChar == 1 && !this.useTabsOnlyForLeadingIndents) {
            return (indent += this.indentationSize - 1) - indent % this.indentationSize;
        }
        return indent;
    }

    private String getPreserveEmptyLines(int count) {
        if (count == 0 && !this.preserveNewLines) {
            if (!this.preferences.join_wrapped_lines && this.lastNumberOfNewLines == 0) {
                StringBuilder tempBuffer = new StringBuilder();
                tempBuffer.append(this.getNewLine());
                if (this.currentAlignment != null && !this.formatBrace) {
                    this.indentationLevel = this.currentAlignment.breakIndentationLevel;
                }
                this.preserveLineBreakIndentation = true;
                this.printIndentationIfNecessary(tempBuffer);
                return tempBuffer.toString();
            }
            return EMPTY_STRING;
        }
        if (this.preferences.number_of_empty_lines_to_preserve != 0) {
            int linesToPreserve = Math.min(count, this.preferences.number_of_empty_lines_to_preserve);
            return this.getEmptyLines(linesToPreserve);
        }
        if (this.preserveNewLines) {
            return this.getNewLine();
        }
        return EMPTY_STRING;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit edit = null;
        int length = this.textRegionEnd - this.textRegionStart;
        edit = this.textRegionStart <= 0 ? (length <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, this.textRegionEnd)) : new MultiTextEdit(this.textRegionStart, length);
        int i = 0;
        int max = this.editsIndex;
        while (i < max) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (this.isValidEdit(currentEdit)) {
                edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
            }
            ++i;
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null && targetAlignment.tieBreakRule == 2) {
            if (targetAlignment.couldBreak()) {
                this.throwAlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        relativeDepth = 0;
        int outerMostDepth = -1;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            this.throwAlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                this.throwAlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    private void throwAlignmentException(int kind, int relativeDepth) {
        AlignmentException e;
        this.currentAlignmentException = e = new AlignmentException(kind, relativeDepth);
        throw e;
    }

    public void indent() {
        if (this.shouldSkip(this.scanner.getCurrentPosition())) {
            ++this.fSkippedIndentations;
            return;
        }
        this.indentationLevel += this.indentationSize;
        ++this.numberOfIndentations;
    }

    public void initializeScanner(char[] translationUnitSource) {
        this.scanner.setSource(translationUnitSource);
        this.scannerEndPosition = translationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition);
        this.edits = new OptimizedReplaceEdit[100];
        this.lineOffsets = new int[200];
        this.numLines = 0;
        this.lineOffsets[this.numLines++] = 0;
        int i = 0;
        while (i < translationUnitSource.length) {
            if (translationUnitSource[i] == '\n') {
                int len = this.lineOffsets.length;
                if (this.numLines >= len) {
                    this.lineOffsets = new int[len + (len + 1) / 2];
                    System.arraycopy(this.lineOffsets, 0, this.lineOffsets, 0, len);
                }
                this.lineOffsets[this.numLines++] = i + 1;
            }
            ++i;
        }
    }

    public void setSkipInactivePositions(List<InactivePosition> list) {
        this.fSkipInactivePositions = list;
        this.skipOverInactive = !list.isEmpty();
    }

    private int getLineStart(int offset) {
        int down = 0;
        int up = this.numLines;
        while (true) {
            int mid = (down + up) / 2;
            int lineOffset = this.lineOffsets[mid];
            if (mid == down) {
                return lineOffset;
            }
            if (lineOffset > offset) {
                up = mid;
                continue;
            }
            down = mid;
        }
    }

    private boolean isOnFirstColumn(int offset) {
        return this.getLineStart(offset) == offset;
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0) {
            if (this.textRegionStart <= editOffset && editOffset + editLength <= this.textRegionEnd) {
                if (editReplacementLength != 0 && editLength == editReplacementLength) {
                    int i = editOffset;
                    int max = editOffset + editLength;
                    while (i < max) {
                        if (this.scanner.source[i] != edit.replacement.charAt(i - editOffset)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                return true;
            }
            if (editOffset + editLength == this.textRegionStart) {
                int i = editOffset;
                int max = editOffset + editLength;
                while (i < max) {
                    int replacementStringIndex = i - editOffset;
                    if (replacementStringIndex >= editReplacementLength || this.scanner.source[i] != edit.replacement.charAt(replacementStringIndex)) break;
                    ++i;
                }
                if (i - editOffset != editReplacementLength && i != editOffset + editLength - 1) {
                    edit.offset = this.textRegionStart;
                    edit.length = 0;
                    edit.replacement = edit.replacement.substring(i - editOffset);
                    return true;
                }
            }
        } else {
            if (this.textRegionStart <= editOffset && editOffset < this.textRegionEnd) {
                return true;
            }
            if (editOffset == this.scannerEndPosition && editOffset == this.textRegionEnd) {
                return true;
            }
        }
        return false;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        } else {
            this.printNewLine(insertPosition);
        }
    }

    public void printRaw(int startOffset, int length) {
        this.printRaw(startOffset, length, true);
    }

    private void printRaw(int startOffset, int length, boolean skipInactive) {
        if (length <= 0) {
            return;
        }
        int currentPosition = this.scanner.getCurrentPosition();
        if (this.shouldSkip(currentPosition)) {
            return;
        }
        if (startOffset > currentPosition) {
            this.printComment();
            currentPosition = this.scanner.getCurrentPosition();
        }
        if (startOffset + length < currentPosition) {
            return;
        }
        boolean savedPreserveNL = this.preserveNewLines;
        boolean savedSkipOverInactive = this.skipOverInactive;
        int savedScannerEndPos = this.scannerEndPosition;
        this.preserveNewLines = true;
        if (skipInactive) {
            this.skipOverInactive = false;
        }
        this.scannerEndPosition = startOffset + length;
        try {
            this.scanner.resetTo(Math.max(startOffset, currentPosition), startOffset + length);
            int parenLevel = 0;
            while (true) {
                boolean hasWhitespace = this.printComment();
                this.currentToken = this.scanner.nextToken();
                if (this.currentToken == null) {
                    if (hasWhitespace) {
                        this.space();
                    }
                    break;
                }
                if (this.pendingSpace) {
                    this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), SPACE);
                    this.pendingSpace = false;
                    this.needSpace = false;
                }
                switch (this.currentToken.type) {
                    case 12: {
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition);
                        this.formatOpeningBrace(this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
                        if (!this.preferences.indent_statements_compare_to_block) break;
                        this.indent();
                        break;
                    }
                    case 13: {
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition);
                        if (this.preferences.indent_statements_compare_to_block) {
                            this.unIndent();
                        }
                        this.formatClosingBrace(this.preferences.brace_position_for_block);
                        break;
                    }
                    case 8: {
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        if (++parenLevel <= 0) break;
                        this.indentForContinuation();
                        if (this.column > this.indentationLevel) break;
                        this.column = this.indentationLevel + 1;
                        break;
                    }
                    case 9: {
                        if (--parenLevel >= 0) {
                            this.unIndentForContinuation();
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        break;
                    }
                    case 5: {
                        this.print(this.currentToken.getLength(), this.preferences.insert_space_before_semicolon);
                        break;
                    }
                    case 63: 
                    case 76: {
                        if (this.preferences.insert_new_line_before_else_in_if_statement) {
                            this.printNewLine(this.currentToken.offset);
                        } else {
                            hasWhitespace = true;
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        break;
                    }
                    default: {
                        if (this.currentToken.isVisibilityModifier() && !this.preferences.indent_access_specifier_compare_to_type_header) {
                            int indentLevel = this.indentationLevel;
                            if (this.indentationLevel > 0) {
                                this.unIndent();
                            }
                            this.print(this.currentToken.getLength(), hasWhitespace);
                            while (this.indentationLevel < indentLevel) {
                                this.indent();
                            }
                            break;
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                    }
                }
                hasWhitespace = false;
            }
        }
        finally {
            this.scannerEndPosition = savedScannerEndPos;
            this.scanner.resetTo(startOffset + length, this.scannerEndPosition);
            this.skipOverInactive = savedSkipOverInactive;
            this.preserveNewLines = savedPreserveNL;
        }
    }

    public void indentForContinuation() {
        int i = 0;
        while (i < this.preferences.continuation_indentation) {
            this.indent();
            ++i;
        }
    }

    public void unIndentForContinuation() {
        int i = 0;
        while (i < this.preferences.continuation_indentation) {
            this.unIndent();
            ++i;
        }
    }

    public void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.printNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.printNewLine();
            this.indent();
        }
        this.printNextToken(12, insertSpaceBeforeBrace);
        this.printTrailingComment();
    }

    public void formatClosingBrace(String block_brace_position) {
        this.printNextToken(13);
        this.printTrailingComment();
        if ("next_line_shifted".equals(block_brace_position)) {
            this.unIndent();
        }
    }

    private void print(int length, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && length + this.column - 1 > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        if (this.indentationLevel != 0) {
            this.printIndentationIfNecessary();
        }
        if (considerSpaceIfAny) {
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), SPACE);
        }
        if (this.checkLineWrapping && length + this.column - 1 > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.pendingSpace = false;
        this.column += length;
        this.needSpace = true;
    }

    private void printBlockComment(boolean forceNewLine) {
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        boolean oldState = this.inactiveState;
        if (currentTokenStartPosition > 0 && !this.preferences.format_block_comment || currentTokenStartPosition == 0 && !this.preferences.format_header_comment) {
            this.inactiveState = true;
        }
        try {
            int currentCharacter;
            this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition);
            boolean isNewLine = false;
            int start = currentTokenStartPosition;
            int nextCharacterStart = currentTokenStartPosition;
            this.printIndentationIfNecessary();
            if (this.pendingSpace) {
                this.addInsertEdit(currentTokenStartPosition, SPACE);
            }
            this.needSpace = false;
            this.pendingSpace = false;
            int previousStart = currentTokenStartPosition;
            while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
                nextCharacterStart = this.scanner.getCurrentPosition();
                switch (currentCharacter) {
                    case 13: {
                        if (isNewLine) {
                            ++this.line;
                        }
                        start = previousStart;
                        isNewLine = true;
                        if (!this.scanner.getNextChar('\n')) break;
                        currentCharacter = 10;
                        nextCharacterStart = this.scanner.getCurrentPosition();
                        break;
                    }
                    case 10: {
                        if (isNewLine) {
                            ++this.line;
                        }
                        start = previousStart;
                        isNewLine = true;
                        break;
                    }
                    default: {
                        if (isNewLine) {
                            if (Character.isWhitespace((char)currentCharacter)) {
                                int previousStartPosition = this.scanner.getCurrentPosition();
                                while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && Character.isWhitespace((char)currentCharacter)) {
                                    previousStart = nextCharacterStart;
                                    previousStartPosition = this.scanner.getCurrentPosition();
                                    currentCharacter = this.scanner.getNextChar();
                                    nextCharacterStart = this.scanner.getCurrentPosition();
                                }
                                if (currentCharacter == 13 || currentCharacter == 10) {
                                    nextCharacterStart = previousStartPosition;
                                }
                            }
                            this.column = 1;
                            ++this.line;
                            StringBuilder buffer = new StringBuilder();
                            buffer.append(this.lineSeparator);
                            this.printIndentationIfNecessary(buffer);
                            buffer.append(' ');
                            this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                        } else {
                            this.column += nextCharacterStart - previousStart;
                        }
                        isNewLine = false;
                    }
                }
                previousStart = nextCharacterStart;
                this.scanner.setCurrentPosition(nextCharacterStart);
            }
            this.lastNumberOfNewLines = 0;
            this.needSpace = false;
            this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition);
            if (forceNewLine) {
                this.startNewLine();
            }
        }
        finally {
            this.inactiveState = oldState;
        }
    }

    private void printPreprocessorDirective() {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition);
        boolean isNewLine = false;
        int nextCharacterStart = currentTokenStartPosition;
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.getCurrentPosition();
            switch (currentCharacter) {
                case 13: {
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.getCurrentPosition();
                    break;
                }
                case 10: {
                    isNewLine = true;
                    break;
                }
                default: {
                    if (isNewLine) {
                        this.column = 1;
                        ++this.line;
                    } else {
                        this.column += nextCharacterStart - previousStart;
                    }
                    isNewLine = false;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.setCurrentPosition(nextCharacterStart);
        }
        this.lastNumberOfNewLines = isNewLine ? 1 : 0;
        this.needSpace = false;
        if (this.currentAlignment != null) {
            this.indentationLevel = this.currentAlignment.breakIndentationLevel;
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition);
    }

    public void printEndOfTranslationUnit() {
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        if (currentTokenStartPosition <= this.scannerEndPosition) {
            this.printRaw(currentTokenStartPosition, this.scannerEndPosition - currentTokenStartPosition + 1, false);
        }
    }

    public boolean printComment() {
        return this.printComment(0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean printComment(int trailing) {
        currentTokenStartPosition = this.scanner.getCurrentPosition();
        if (this.shouldSkip(currentTokenStartPosition)) {
            return false;
        }
        hasComment = false;
        hasLineComment = false;
        hasWhitespace = false;
        whiteSpaces = CharArrayUtils.EMPTY_CHAR_ARRAY;
        lines = 0;
        while ((this.currentToken = this.scanner.nextToken()) != null) {
            block61: {
                if (!this.skipOverInactive || (inactivePos = this.getInactivePosAt(this.scanner.getCurrentTokenStartPosition())) == null || (startOffset = Math.min(this.scanner.getCurrentTokenStartPosition(), inactivePos.getOffset())) >= (endOffset = Math.min(this.scannerEndPosition, inactivePos.getOffset() + inactivePos.getLength()))) break block61;
                savedIndentLevel = this.indentationLevel;
                this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scanner.eofPosition);
                try {
                    this.inactiveState = true;
                    if (inactivePos.isPreprocessorRegion() && this.editsIndex > 0 && this.lineSeparator.equals(this.edits[this.editsIndex - 1].replacement)) {
                        --this.editsIndex;
                    }
                    this.printRaw(startOffset, endOffset - startOffset);
                    if (true) ** GOTO lbl24
                }
                finally {
                    this.inactiveState = false;
                }
                do {
                    this.unIndent();
lbl24:
                    // 2 sources

                } while (this.indentationLevel > savedIndentLevel);
                while (this.indentationLevel < savedIndentLevel) {
                    this.indent();
                }
                this.scanner.resetTo(endOffset, this.scanner.eofPosition);
                continue;
            }
            tokenStartPosition = this.scanner.getCurrentTokenStartPosition();
            switch (this.currentToken.type) {
                case 1000: {
                    whiteSpaces = this.scanner.getCurrentTokenSource();
                    whitespacesEndPosition = this.scanner.getCurrentTokenEndPosition();
                    lines = 0;
                    i = 0;
                    max = whiteSpaces.length;
                    while (i < max) {
                        switch (whiteSpaces[i]) {
                            case '\r': {
                                if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                    ++i;
                                }
                                ++lines;
                                break;
                            }
                            case '\n': {
                                ++lines;
                            }
                        }
                        ++i;
                    }
                    v0 = realTrailing = trailing != 0;
                    if (realTrailing && this.scanner.peekNextChar() == 47 && lines == 0) {
                        canChangeTrailing = false;
                        if (trailing == 256 && hasLineComment) {
                            currentCommentIndentation = this.computeIndentation(whiteSpaces, 0);
                            relativeIndentation = currentCommentIndentation - this.lastLineComment.currentIndentation;
                            if (this.tabLength == 0) {
                                canChangeTrailing = relativeIndentation == 0;
                            } else {
                                v1 = canChangeTrailing = relativeIndentation > -this.tabLength;
                            }
                        }
                        if (canChangeTrailing) {
                            currentTokenPosition = this.scanner.getCurrentTokenStartPosition();
                            if (this.scanner.getNextToken() == 1001) {
                                realTrailing = hasLineComment == false;
                                switch (this.scanner.getNextToken()) {
                                    case 1001: {
                                        realTrailing = false;
                                        break;
                                    }
                                    case 1000: {
                                        if (this.scanner.getNextToken() != 1001) break;
                                        realTrailing = false;
                                    }
                                }
                            }
                            this.scanner.resetTo(currentTokenPosition, this.scanner.eofPosition);
                            this.scanner.getNextToken();
                        }
                    }
                    if (realTrailing) {
                        if (hasLineComment) {
                            if (lines >= 1) {
                                currentTokenStartPosition = tokenStartPosition;
                                this.preserveEmptyLines(lines, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, whitespacesEndPosition);
                                this.scanner.resetTo(this.scanner.getCurrentPosition(), this.scannerEndPosition);
                                return hasWhitespace;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition);
                            return hasWhitespace;
                        }
                        if (lines >= 1) {
                            if (hasComment) {
                                this.printNewLine(tokenStartPosition);
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition);
                            return hasWhitespace;
                        }
                        hasWhitespace = true;
                        currentTokenStartPosition = this.scanner.getCurrentPosition();
                        this.addDeleteEdit(tokenStartPosition, whitespacesEndPosition);
                    } else if (lines == 0) {
                        hasWhitespace = true;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (hasComment) {
                        if (lines == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        } else {
                            this.preserveEmptyLines(lines - 1, this.scanner.getCurrentTokenStartPosition());
                        }
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (hasLineComment) {
                        this.preserveEmptyLines(lines, this.scanner.getCurrentTokenStartPosition());
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (!(lines == 0 || this.preferences.join_wrapped_lines && this.preferences.number_of_empty_lines_to_preserve == 0)) {
                        preservedEmptyLines = this.getPreserveEmptyLines(lines - 1);
                        this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), preservedEmptyLines);
                        hasWhitespace = preservedEmptyLines.length() == 0;
                    } else {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        hasWhitespace = true;
                    }
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1001: {
                    if (lines >= 1) {
                        if (lines > 1) {
                            this.preserveEmptyLines(lines - 1, this.scanner.getCurrentTokenStartPosition());
                        } else if (lines == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        }
                    } else if (hasWhitespace) {
                        if (lines > 1 || lines == 1 && hasLineComment) {
                            this.lastLineComment.contiguous = false;
                        }
                        this.lastLineComment.leadingSpaces = whiteSpaces;
                        this.lastLineComment.lines = lines;
                    }
                    whiteSpaces = CharArrayUtils.EMPTY_CHAR_ARRAY;
                    hasWhitespace = false;
                    this.printLineComment();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = true;
                    lines = 0;
                    break;
                }
                case 1002: {
                    if (lines >= 1) {
                        if (lines > 1) {
                            this.preserveEmptyLines(lines - 1, this.scanner.getCurrentTokenStartPosition());
                        } else if (lines == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        }
                    } else if (hasWhitespace) {
                        this.space();
                    }
                    whiteSpaces = CharArrayUtils.EMPTY_CHAR_ARRAY;
                    hasWhitespace = false;
                    this.printBlockComment(false);
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = false;
                    hasComment = true;
                    lines = 0;
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    if (this.column != 1) {
                        this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                    }
                    if (lines >= 1 && lines > 1) {
                        this.preserveEmptyLines(lines - 1, this.scanner.getCurrentTokenStartPosition());
                    }
                    whiteSpaces = CharArrayUtils.EMPTY_CHAR_ARRAY;
                    hasWhitespace = false;
                    this.printPreprocessorDirective();
                    this.printNewLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = false;
                    hasComment = false;
                    lines = 0;
                    break;
                }
                default: {
                    this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition);
                    return hasWhitespace;
                }
            }
        }
        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition);
        return hasWhitespace;
    }

    private InactivePosition getInactivePosAt(int offset) {
        for (InactivePosition pos : this.fSkipInactivePositions) {
            if (!pos.includes(offset)) continue;
            return pos;
        }
        return null;
    }

    private void printLineComment() {
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition);
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        boolean oldState = this.inactiveState;
        if (currentTokenStartPosition > 0 && !this.preferences.format_line_comment || currentTokenStartPosition == 0 && !this.preferences.format_header_comment) {
            this.inactiveState = true;
        }
        try {
            int commentIndentationLevel;
            boolean onFirstColumn = this.isOnFirstColumn(start);
            if (!this.preferences.comment_line_up_line_comment_in_blocks_on_first_column && this.indentationLevel == 0) {
                commentIndentationLevel = this.column - 1;
            } else if (onFirstColumn && this.preferences.never_indent_line_comments_on_first_column) {
                commentIndentationLevel = this.column - 1;
            } else if (this.lastLineComment.contiguous) {
                int currentCommentIndentation = this.computeIndentation(this.lastLineComment.leadingSpaces, 0);
                int relativeIndentation = currentCommentIndentation - this.lastLineComment.currentIndentation;
                boolean similarCommentsIndentation = false;
                if (this.tabLength == 0) {
                    similarCommentsIndentation = relativeIndentation == 0;
                } else if (relativeIndentation > -this.tabLength) {
                    boolean bl = similarCommentsIndentation = relativeIndentation == 0 || currentCommentIndentation != 0 && this.lastLineComment.currentIndentation != 0;
                }
                if (similarCommentsIndentation && this.lastLineComment.indentation != this.indentationLevel) {
                    int currentIndentationLevel = this.indentationLevel;
                    this.indentationLevel = this.lastLineComment.indentation;
                    this.printIndentationIfNecessary();
                    this.indentationLevel = currentIndentationLevel;
                    commentIndentationLevel = this.lastLineComment.indentation;
                } else {
                    this.printIndentationIfNecessary();
                    commentIndentationLevel = this.column - 1;
                }
            } else {
                this.printIndentationIfNecessary();
                commentIndentationLevel = this.column - 1;
            }
            StringBuilder whitespace = null;
            if (!(this.lastLineComment.contiguous || commentIndentationLevel == this.indentationLevel || this.preferences.never_indent_line_comments_on_first_column && onFirstColumn)) {
                whitespace = new StringBuilder();
                int whitespaceStartPosition = currentTokenStartPosition - this.lastLineComment.leadingSpaces.length;
                int indent = this.getIndentationOfOffset(whitespaceStartPosition);
                int distance = this.computeIndentation(this.lastLineComment.leadingSpaces, indent) - indent;
                if (this.preferences.comment_preserve_white_space_between_code_and_line_comment && distance >= this.preferences.comment_min_distance_between_code_and_line_comment) {
                    whitespace.append(this.lastLineComment.leadingSpaces);
                } else {
                    int i = 0;
                    while (i < this.preferences.comment_min_distance_between_code_and_line_comment) {
                        whitespace.append(' ');
                        ++i;
                    }
                }
            }
            this.lastLineComment.currentIndentation = this.getIndentationOfOffset(currentTokenStartPosition);
            this.lastLineComment.contiguous = true;
            while (true) {
                int currentCharacter;
                Location location = new Location(this, this.scanner.getCurrentPosition());
                int commentIndent = commentIndentationLevel;
                if (whitespace != null) {
                    this.addInsertEdit(currentTokenStartPosition, whitespace);
                    commentIndent = this.computeIndentation(whitespace, commentIndentationLevel);
                    this.needSpace = false;
                    this.pendingSpace = false;
                }
                this.lastLineComment.indentation = commentIndent;
                int previousStart = currentTokenStartPosition;
                int indent = commentIndent;
                block8: while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
                    nextCharacterStart = this.scanner.getCurrentPosition();
                    switch (currentCharacter) {
                        case 10: 
                        case 13: {
                            start = previousStart;
                            break block8;
                        }
                        default: {
                            indent = this.computeIndentation((char)currentCharacter, indent);
                            previousStart = nextCharacterStart;
                        }
                    }
                }
                if (start != currentTokenStartPosition) {
                    this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
                    ++this.line;
                    this.column = 1;
                    this.lastNumberOfNewLines = 1;
                }
                if (!this.checkLineWrapping || indent <= this.pageWidth || whitespace == null || commentIndent - commentIndentationLevel <= this.preferences.comment_min_distance_between_code_and_line_comment) break;
                whitespace.deleteCharAt(whitespace.length() - 1);
                if (this.computeIndentation(this.lastLineComment.leadingSpaces, commentIndentationLevel) - commentIndentationLevel < this.preferences.comment_min_distance_between_code_and_line_comment) {
                    whitespace.delete(0, whitespace.length());
                    int i = 0;
                    while (i < this.preferences.comment_min_distance_between_code_and_line_comment) {
                        whitespace.append(' ');
                        ++i;
                    }
                }
                this.resetAt(location);
                this.scanner.resetTo(location.inputOffset, this.scanner.eofPosition);
            }
            this.needSpace = false;
            this.pendingSpace = false;
            if (this.currentAlignment != null) {
                if (this.memberAlignment != null) {
                    if (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset) {
                        if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                            this.currentAlignment.performFragmentEffect();
                        }
                    } else {
                        this.indentationLevel = Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel);
                    }
                } else if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                    this.currentAlignment.performFragmentEffect();
                }
                if (this.currentAlignment.name.equals("binaryExpression") && this.currentAlignment.enclosing != null && this.currentAlignment.enclosing.equals("binaryExpression") && this.indentationLevel < this.currentAlignment.breakIndentationLevel) {
                    this.indentationLevel = this.currentAlignment.breakIndentationLevel;
                }
            }
            this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition);
        }
        finally {
            this.inactiveState = oldState;
        }
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int linesNumber, int insertPosition) {
        String buffer = this.getEmptyLines(linesNumber);
        if (!buffer.isEmpty()) {
            this.addInsertEdit(insertPosition, buffer);
        }
    }

    void printIndentationIfNecessary() {
        if (this.column > this.indentationLevel) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        this.printIndentationIfNecessary(buffer);
        if (buffer.length() > 0) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer);
            this.pendingSpace = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printIndentationIfNecessary(StringBuilder buffer) {
        switch (this.tabChar) {
            case 1: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = 0;
                if (!useTabsForLeadingIndents) ** GOTO lbl27
                while (this.column <= this.indentationLevel) {
                    if (indentationsAsTab < numberOfLeadingIndents) {
                        buffer.append('\t');
                        ++indentationsAsTab;
                        complement = this.tabLength - (this.column - 1) % this.tabLength;
                        this.column += complement;
                        this.needSpace = false;
                        continue;
                    }
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    buffer.append('\t');
                    complement = this.tabLength - (this.column - 1) % this.tabLength;
                    this.column += complement;
                    this.needSpace = false;
lbl27:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel - this.indentationLevel % this.tabLength)
                }
lbl28:
                // 2 sources

                while (this.column <= this.indentationLevel) {
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 2: {
                while (this.column <= this.indentationLevel) {
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 4: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = false;
                if (!useTabsForLeadingIndents) ** GOTO lbl100
                columnForLeadingIndents = numberOfLeadingIndents * this.indentationSize;
                while (this.column <= this.indentationLevel) {
                    if (this.column <= columnForLeadingIndents) {
                        if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                            buffer.append('\t');
                            this.column += this.tabLength;
                        } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                            i = 0;
                            max = this.indentationSize;
                            while (i < max) {
                                buffer.append(' ');
                                ++this.column;
                                ++i;
                            }
                        } else {
                            buffer.append(' ');
                            ++this.column;
                        }
                    } else {
                        i = this.column;
                        max = this.indentationLevel;
                        while (i <= max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    }
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                        buffer.append('\t');
                        this.column += this.tabLength;
                    } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                        i = 0;
                        max = this.indentationSize;
                        while (i < max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    } else {
                        buffer.append(' ');
                        ++this.column;
                    }
                    this.needSpace = false;
lbl100:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
            }
        }
lbl101:
        // 6 sources

    }

    public void enterNode() {
        this.lastLineComment.contiguous = false;
    }

    public void startNewLine() {
        if (this.column > 1) {
            this.printNewLine();
        }
    }

    public void printNewLine() {
        this.printNewLine(this.scanner.getCurrentPosition());
    }

    public void printNewLine(int insertPosition) {
        if (this.shouldSkip(this.scanner.getCurrentPosition())) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            if (!this.preserveLineBreakIndentation) {
                this.column = 1;
            }
            this.preserveLineBreakIndentation = false;
            return;
        }
        this.addInsertEdit(insertPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        this.preserveLineBreakIndentation = false;
        this.lastLineComment.contiguous = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        switch (expectedTokenType) {
            case 12: 
            case 13: {
                this.formatBrace = true;
                this.lastLineComment.contiguous = false;
            }
        }
        try {
            this.printComment();
            if (this.shouldSkip(this.scanner.getCurrentPosition())) {
                return;
            }
            this.currentToken = this.scanner.nextToken();
            if (this.currentToken == null || expectedTokenType != this.currentToken.type) {
                if (this.pendingSpace) {
                    this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), SPACE);
                }
                this.pendingSpace = false;
                this.needSpace = true;
                throw new AbortFormatting("[" + (this.line + 1) + "/" + this.column + "] Unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(this.currentToken.getLength(), considerSpaceIfAny);
        }
        finally {
            this.formatBrace = false;
        }
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printNextToken(expectedTokenTypes, false);
    }

    public void printNextToken(int[] expectedTokenTypes, boolean considerSpaceIfAny) {
        this.printComment();
        if (this.shouldSkip(this.scanner.getCurrentPosition())) {
            return;
        }
        this.currentToken = this.scanner.nextToken();
        if (Arrays.binarySearch(expectedTokenTypes, this.currentToken.type) < 0) {
            if (this.pendingSpace) {
                this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), SPACE);
            }
            this.pendingSpace = false;
            this.needSpace = true;
            StringBuilder expectations = new StringBuilder(5);
            int i = 0;
            while (i < expectedTokenTypes.length) {
                if (i > 0) {
                    expectations.append(',');
                }
                expectations.append(expectedTokenTypes[i]);
                ++i;
            }
            throw new AbortFormatting("[" + (this.line + 1) + "/" + this.column + "] unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
        }
        this.print(this.currentToken.getLength(), considerSpaceIfAny);
    }

    private void printRuler(StringBuilder stringBuffer) {
        int i = 0;
        while (i < this.pageWidth) {
            if (i % this.tabLength == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++i;
        }
        stringBuffer.append(this.lineSeparator);
        i = 0;
        while (i < this.pageWidth / this.tabLength) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
            ++i;
        }
    }

    public void printSpaces(int numSpaces) {
        if (numSpaces > 0) {
            int currentPosition = this.scanner.getCurrentPosition();
            StringBuilder spaces = new StringBuilder(numSpaces);
            int i = 0;
            while (i < numSpaces) {
                spaces.append(' ');
                ++i;
            }
            this.addInsertEdit(currentPosition, spaces);
            this.pendingSpace = false;
            this.needSpace = false;
        }
    }

    public void printTrailingComment() {
        this.printComment(256);
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition);
        this.currentAlignment.chunkKind = 0;
        this.currentAlignmentException = null;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition);
        this.memberAlignment.chunkKind = 0;
        this.currentAlignmentException = null;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.numberOfIndentations = location.numberOfIndentations;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.editsIndex = location.editsIndex;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
        this.setTailFormatter(location.tailFormatter);
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        if (this.shouldSkip(this.scanner.getCurrentPosition())) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    public void undoSpace() {
        if (this.pendingSpace) {
            this.pendingSpace = false;
            this.needSpace = true;
            --this.column;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(page width = ").append(this.pageWidth).append(") - (tabChar = ");
        switch (this.tabChar) {
            case 1: {
                buffer.append("TAB");
                break;
            }
            case 2: {
                buffer.append("SPACE");
                break;
            }
            default: {
                buffer.append("MIXED");
            }
        }
        buffer.append(") - (tabSize = ").append(this.tabLength).append(')').append(this.lineSeparator).append("(line = ").append(this.line).append(") - (column = ").append(this.column).append(") - (identationLevel = ").append(this.indentationLevel).append(')').append(this.lineSeparator).append("(needSpace = ").append(this.needSpace).append(") - (lastNumberOfNewLines = ").append(this.lastNumberOfNewLines).append(") - (checkLineWrapping = ").append(this.checkLineWrapping).append(')').append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRuler(buffer);
        return buffer.toString();
    }

    public void unIndent() {
        if (this.shouldSkip(this.scanner.getCurrentPosition())) {
            --this.fSkippedIndentations;
            return;
        }
        this.indentationLevel -= this.indentationSize;
        --this.numberOfIndentations;
    }

    public boolean printModifiers() {
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        if (this.shouldSkip(currentTokenStartPosition)) {
            return false;
        }
        boolean isFirstModifier = true;
        boolean hasComment = false;
        block11: while ((this.currentToken = this.scanner.nextToken()) != null) {
            switch (this.currentToken.type) {
                case 57: 
                case 67: 
                case 78: 
                case 80: 
                case 84: 
                case 87: 
                case 90: 
                case 101: 
                case 106: 
                case 108: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 136: {
                    this.print(this.currentToken.getLength(), !isFirstModifier);
                    isFirstModifier = false;
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1002: {
                    this.printBlockComment(false);
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = true;
                    break;
                }
                case 1001: {
                    this.printLineComment();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1000: {
                    this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    int count = 0;
                    char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                    int i = 0;
                    int max = whiteSpaces.length;
                    while (i < max) {
                        switch (whiteSpaces[i]) {
                            case '\r': {
                                if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                    ++i;
                                }
                                ++count;
                                break;
                            }
                            case '\n': {
                                ++count;
                            }
                        }
                        ++i;
                    }
                    if (count >= 1 && hasComment) {
                        this.printNewLine();
                    }
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = false;
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    if (this.column != 1) {
                        this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                    }
                    this.printPreprocessorDirective();
                    this.printNewLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = false;
                    break;
                }
                default: {
                    if (this.currentToken.getType() == 1 && this.currentToken.getText().startsWith("__")) {
                        this.print(this.currentToken.getLength(), !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.getCurrentPosition();
                        this.currentToken = this.scanner.nextToken();
                        if (this.currentToken == null || this.currentToken.getType() != 8 || !this.skipToToken(9)) continue block11;
                        this.currentToken = this.scanner.nextToken();
                        this.currentToken = this.scanner.nextToken();
                        currentTokenStartPosition = this.scanner.getCurrentPosition();
                        break;
                    }
                    this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition);
                    return !isFirstModifier;
                }
            }
        }
        return !isFirstModifier;
    }

    public boolean skipToToken(int expectedTokenType) {
        int skipStart = this.scanner.getCurrentPosition();
        if (this.shouldSkip(skipStart)) {
            return true;
        }
        int tokenStart = this.findToken(expectedTokenType);
        if (tokenStart < 0) {
            return false;
        }
        this.printRaw(skipStart, tokenStart - skipStart);
        this.currentToken = this.scanner.nextToken();
        this.scanner.resetTo(tokenStart, this.scannerEndPosition);
        return true;
    }

    public int findToken(int tokenType) {
        return this.findToken(tokenType, this.scannerEndPosition - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findToken(int tokenType, int endPosition) {
        int startPosition = this.scanner.getCurrentPosition();
        if (startPosition >= endPosition) {
            return -1;
        }
        try {
            Token token;
            int braceLevel = 0;
            int parenLevel = 0;
            switch (tokenType) {
                case 13: {
                    ++braceLevel;
                    break;
                }
                case 9: {
                    ++parenLevel;
                }
            }
            block16: while ((token = this.scanner.nextToken()) != null) {
                if (this.scanner.getCurrentTokenEndPosition() > endPosition) {
                    return -1;
                }
                switch (token.type) {
                    case 12: {
                        if (tokenType == 12) break;
                        ++braceLevel;
                        break;
                    }
                    case 13: {
                        --braceLevel;
                        break;
                    }
                    case 8: {
                        if (tokenType == 8) break;
                        ++parenLevel;
                        break;
                    }
                    case 9: {
                        --parenLevel;
                        break;
                    }
                    case 1000: 
                    case 1001: 
                    case 1002: 
                    case 1003: 
                    case 1004: 
                    case 1005: {
                        continue block16;
                    }
                }
                if (braceLevel <= 0 && parenLevel <= 0 && token.type == tokenType) {
                    int n = this.scanner.getCurrentTokenStartPosition();
                    return n;
                }
                if (braceLevel < 0) return -1;
                if (parenLevel >= 0) continue;
                return -1;
            }
            return -1;
        }
        finally {
            this.scanner.resetTo(startPosition, this.scannerEndPosition);
        }
    }

    public int findToken(int tokenType, int startPosition, int endPosition) {
        int currentPosition = this.scanner.getCurrentPosition();
        try {
            this.scanner.resetTo(startPosition, this.scannerEndPosition);
            int n = this.findToken(tokenType, endPosition);
            return n;
        }
        finally {
            this.scanner.resetTo(currentPosition, this.scannerEndPosition);
        }
    }

    public boolean printCommentPreservingNewLines() {
        boolean savedPreserveNL = this.preserveNewLines;
        this.preserveNewLines = true;
        try {
            boolean bl = this.printComment();
            return bl;
        }
        finally {
            this.preserveNewLines = savedPreserveNL;
        }
    }

    boolean shouldSkip(int offset) {
        return offset >= this.fSkipStartOffset && offset < this.fSkipEndOffset;
    }

    void skipRange(int offset, int endOffset) {
        if (offset == this.fSkipStartOffset) {
            return;
        }
        int currentPosition = this.scanner.getCurrentPosition();
        if (offset > currentPosition) {
            this.fSkipStartOffset = Integer.MAX_VALUE;
            this.printRaw(currentPosition, offset - currentPosition);
        }
        this.fSkipStartOffset = offset;
        this.fSkipEndOffset = endOffset;
    }

    boolean skipRange() {
        return this.fSkipEndOffset > 0;
    }

    void restartAtOffset(int offset) {
        int currentPosition = this.scanner.getCurrentPosition();
        if (this.fSkipEndOffset > 0) {
            this.fSkipStartOffset = Integer.MAX_VALUE;
            this.fSkipEndOffset = 0;
            while (this.fSkippedIndentations < 0) {
                this.unIndent();
                ++this.fSkippedIndentations;
            }
            if (offset > currentPosition) {
                this.printRaw(currentPosition, offset - currentPosition);
                this.scanner.resetTo(offset, this.scannerEndPosition);
            }
            while (this.fSkippedIndentations > 0) {
                this.indent();
                --this.fSkippedIndentations;
            }
        } else if (offset > currentPosition) {
            boolean hasSpace = this.printComment();
            int nextPosition = this.scanner.getCurrentPosition();
            if (offset > nextPosition) {
                if (hasSpace) {
                    this.space();
                }
                this.printRaw(nextPosition, offset - nextPosition);
                this.scanner.resetTo(offset, this.scannerEndPosition);
            }
        }
    }

    public Runnable getTailFormatter() {
        if (this.currentAlignment != null) {
            return this.currentAlignment.tailFormatter;
        }
        return this.tailFormatter;
    }

    public Runnable takeTailFormatter() {
        Runnable formatter;
        if (this.currentAlignment != null) {
            formatter = this.currentAlignment.tailFormatter;
            this.currentAlignment.tailFormatter = null;
        } else {
            formatter = this.tailFormatter;
            this.tailFormatter = null;
        }
        return formatter;
    }

    public void setTailFormatter(Runnable tailFormatter) {
        if (this.currentAlignment != null) {
            this.currentAlignment.tailFormatter = tailFormatter;
        } else {
            this.tailFormatter = tailFormatter;
        }
    }

    public void runTailFormatter() {
        Runnable formatter = this.getTailFormatter();
        if (formatter != null) {
            formatter.run();
        }
    }

    static class LineComment {
        boolean contiguous;
        int currentIndentation;
        int indentation;
        int lines;
        char[] leadingSpaces = CharArrayUtils.EMPTY_CHAR_ARRAY;

        LineComment() {
        }
    }
}

