/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPSpecialization
extends PlatformObject
implements ICPPSpecialization,
ICPPInternalBinding {
    private final IBinding owner;
    private final IBinding specialized;
    private final ICPPTemplateParameterMap argumentMap;
    protected IASTNode definition;
    private IASTNode[] declarations;

    public CPPSpecialization(IBinding specialized, IBinding owner, ICPPTemplateParameterMap argumentMap) {
        this.specialized = specialized;
        this.owner = owner;
        this.argumentMap = argumentMap;
    }

    @Override
    public IBinding getSpecializedBinding() {
        return this.specialized;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.definition;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.definition = node;
    }

    @Override
    public void addDeclaration(IASTNode node) {
        this.declarations = this.declarations == null ? new IASTNode[]{node} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)this.declarations[0]).getOffset() ? ArrayUtil.prepend(IASTNode.class, this.declarations, node) : ArrayUtil.append(IASTNode.class, this.declarations, node));
    }

    @Override
    public String getName() {
        return this.specialized.getName();
    }

    @Override
    public char[] getNameCharArray() {
        return this.specialized.getNameCharArray();
    }

    @Override
    public IBinding getOwner() {
        return this.owner;
    }

    @Override
    public IScope getScope() throws DOMException {
        if (this.owner instanceof ICPPClassType) {
            return ((ICPPClassType)this.owner).getCompositeScope();
        }
        if (this.owner instanceof ICPPNamespace) {
            return ((ICPPNamespace)this.owner).getNamespaceScope();
        }
        if (this.owner instanceof ICPPFunction) {
            return ((ICPPFunction)this.owner).getFunctionScope();
        }
        if (this.definition != null) {
            return CPPVisitor.getContainingScope(this.definition);
        }
        if (this.declarations != null && this.declarations.length > 0) {
            return CPPVisitor.getContainingScope(this.declarations[0]);
        }
        return this.specialized.getScope();
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        if (this.specialized instanceof ICPPBinding) {
            return ((ICPPBinding)this.specialized).isGloballyQualified();
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public ICPPTemplateParameterMap getTemplateParameterMap() {
        return this.argumentMap;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getName());
        if (this.argumentMap != null) {
            result.append(" ");
            result.append(this.argumentMap.toString());
        }
        return result.toString();
    }
}

