/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.Nullable;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static boolean deepEquals(@Nullable Object o1, @Nullable Object o2) {
        Class<?> class2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> class1 = o1.getClass();
        if (!class1.equals(class2 = o2.getClass())) {
            return false;
        }
        if (class1.isArray()) {
            int length = Array.getLength(o1);
            if (Array.getLength(o2) != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!ObjectUtils.deepEquals(Array.get(o1, i), Array.get(o2, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (o1 instanceof Collection) {
            Collection c1 = (Collection)o1;
            Collection c2 = (Collection)o2;
            int size = c1.size();
            if (c2.size() != size) {
                return false;
            }
            if (o1 instanceof Set && !(o1 instanceof SortedSet)) {
                for (Object e1 : c1) {
                    boolean contains = false;
                    for (Object e2 : c2) {
                        if (!ObjectUtils.deepEquals(e1, e2)) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    return false;
                }
                return true;
            }
            Iterator i1 = c1.iterator();
            Iterator i2 = c2.iterator();
            while (i1.hasNext()) {
                if (ObjectUtils.deepEquals(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static int deepHashCode(@Nullable Object o) {
        if (o == null) {
            return 0;
        }
        if (o.getClass().isArray()) {
            int result = 1;
            int i = 0;
            while (i < Array.getLength(o)) {
                result = 31 * result + ObjectUtils.deepHashCode(Array.get(o, i));
                ++i;
            }
            return result;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (o instanceof Set && !(o instanceof SortedSet)) {
                int result = 0;
                for (Object e : c) {
                    result += ObjectUtils.deepHashCode(e);
                }
                return result;
            }
            int result = 1;
            for (Object e : c) {
                result = 31 * result + ObjectUtils.deepHashCode(e);
            }
            return result;
        }
        return o.hashCode();
    }
}

