/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;

public class YModel
implements IYModel {
    private final transient long fId;
    @SerializedName(value="label")
    private final String fName;
    @SerializedName(value="yValues")
    private final double[] fYValues;
    private final @Nullable TmfXYAxisDescription fYAxis;

    public YModel(long id, String name, double[] yValues) {
        this.fId = id;
        this.fName = name;
        this.fYValues = yValues;
        this.fYAxis = null;
    }

    public YModel(long id, double[] yValues) {
        this(id, String.valueOf(id), yValues, null);
    }

    public YModel(long id, String name, double[] yValues, @Nullable TmfXYAxisDescription yAxis) {
        this.fId = id;
        this.fName = name;
        this.fYValues = yValues;
        this.fYAxis = yAxis;
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public @Nullable TmfXYAxisDescription getYAxisDescription() {
        return this.fYAxis;
    }

    @Override
    public double[] getData() {
        return this.fYValues;
    }

    public int hashCode() {
        return Objects.hash(this.fName, Arrays.hashCode(this.fYValues));
    }

    public boolean equals(@Nullable Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 == null || !(arg0 instanceof IYModel)) {
            return false;
        }
        IYModel otherSeries = (IYModel)arg0;
        return this.fName.equals(otherSeries.getName()) && Arrays.equals(this.fYValues, otherSeries.getData());
    }

    public String toString() {
        return String.valueOf(this.fName) + ':' + Arrays.toString(this.fYValues);
    }
}

