/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.io;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IODataPalette;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ICoreElementResolver;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.tree.AbstractTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class IoPerProcessDataProvider
extends AbstractTreeDataProvider<IoAnalysis, TmfTreeDataModel>
implements ITmfTreeXYDataProvider<TmfTreeDataModel>,
IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.kernel.core.io.per.process";
    private static final String READ_TITLE = "Read";
    private static final String WRITE_TITLE = "Write";
    private static final double SECONDS_PER_NANOSECOND = 1.0E-9;
    private static final String BASE_STYLE = "base";
    private static final Map<String, OutputElementStyle> STATE_MAP;
    private static final List<Pair<String, String>> COLOR_LIST;
    private static final String BINARY_SPEED_UNIT = "B/s";
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION;
    private static final List<String> SUPPORTED_STYLES;
    private static final Comparator<ITmfStateInterval> INTERVAL_COMPARATOR;
    private final Map<Integer, String> fQuarkToString = new HashMap<Integer, String>();

    static {
        COLOR_LIST = IODataPalette.getColors();
        Y_AXIS_DESCRIPTION = new TmfXYAxisDescription(Objects.requireNonNull("File throughput"), BINARY_SPEED_UNIT, DataType.BINARY_NUMBER);
        SUPPORTED_STYLES = ImmutableList.of((Object)"SOLID", (Object)"DASH", (Object)"DOT", (Object)"DASHDOT", (Object)"DASHDOTDOT");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)BASE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)"line", (Object)"width", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f))));
        STATE_MAP = builder.build();
        INTERVAL_COMPARATOR = Comparator.comparing(ITmfStateInterval::getStartTime);
    }

    public IoPerProcessDataProvider(ITmfTrace trace, IoAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
        analysisModule.schedule();
    }

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace) {
        IoAnalysis module = (IoAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, IoAnalysis.class, (String)"org.eclipse.tracecompass.incubator.internal.kernel.core.io");
        return module != null ? new IoPerProcessDataProvider(trace, module) : null;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        LinkedHashSet<TmfTreeDataModel> entryList = new LinkedHashSet<TmfTreeDataModel>();
        String traceName = Objects.requireNonNull(this.getTrace().getName());
        long rootId = this.getId(-1);
        entryList.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(traceName), false, null));
        List<Long> times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null) {
            times = Collections.emptyList();
        }
        long start = Long.MAX_VALUE;
        long end = 0L;
        for (Long time : times) {
            start = Math.min(start, time);
            end = Math.max(end, time);
        }
        start = Math.max(start, ss.getStartTime());
        end = Math.min(end, ss.getCurrentEndTime());
        HashMap<Integer, IoTreeDataModel> allModels = new HashMap<Integer, IoTreeDataModel>();
        ArrayList<Integer> quarksToQuery = new ArrayList<Integer>();
        int i = 0;
        for (Integer quark : ss.getQuarks(new String[]{"TID", "*"})) {
            int currentQuark;
            int readQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"READ"});
            int writeQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"WRITE"});
            if (readQuark == -2 && writeQuark == -2) continue;
            Pair<String, String> pair = COLOR_LIST.get(i % COLOR_LIST.size());
            String seriesStyle = SUPPORTED_STYLES.get(i / COLOR_LIST.size() % SUPPORTED_STYLES.size());
            String tid = ss.getAttributeName(quark.intValue());
            String tidName = this.resolveThreadName(tid, ss.getCurrentEndTime());
            Long id = this.getId(quark);
            allModels.put(quark, new IoTreeDataModel(id, rootId, tidName, tid));
            if (readQuark != -2) {
                quarksToQuery.add(readQuark);
                currentQuark = ss.optQuarkRelative(readQuark, new String[]{"CURRENT"});
                if (currentQuark != -2) {
                    quarksToQuery.add(currentQuark);
                }
                Long readId = this.getId(readQuark);
                allModels.put(readQuark, new IoTreeDataModel(readId, id, READ_TITLE, tid, (String)pair.getFirst(), seriesStyle));
                this.fQuarkToString.put(readQuark, traceName + "/" + tidName + "/Read");
            }
            if (writeQuark != -2) {
                quarksToQuery.add(writeQuark);
                currentQuark = ss.optQuarkRelative(writeQuark, new String[]{"CURRENT"});
                if (currentQuark != -2) {
                    quarksToQuery.add(currentQuark);
                }
                Long writeId = this.getId(writeQuark);
                allModels.put(writeQuark, new IoTreeDataModel(writeId, id, WRITE_TITLE, tid, (String)pair.getSecond(), seriesStyle));
                this.fQuarkToString.put(writeQuark, traceName + "/" + tidName + "/Write");
            }
            ++i;
        }
        long endTime = end;
        Iterable intervals = StreamSupport.stream(ss.query2D(quarksToQuery, Collections.singleton(start)).spliterator(), false).filter(interval -> interval.getValue() != null || interval.getEndTime() <= endTime).collect(Collectors.toList());
        for (ITmfStateInterval interval2 : intervals) {
            int quark = interval2.getAttribute();
            if (ss.getAttributeName(quark).equals("CURRENT")) {
                quark = ss.getParentAttributeQuark(quark);
            } else if (interval2.getEndTime() > endTime) continue;
            entryList.add(Objects.requireNonNull((TmfTreeDataModel)allModels.get(ss.getParentAttributeQuark(quark))));
            entryList.add(Objects.requireNonNull((TmfTreeDataModel)allModels.get(quark)));
        }
        return new TmfTreeModel(Collections.emptyList(), new ArrayList(entryList));
    }

    private @Nullable String resolveThreadName(String tidStr, long time) {
        try {
            int tid = Integer.parseInt(tidStr);
            IHostModel model = ModelManager.getModelFor((String)this.getTrace().getHostId());
            String tname = model.getExecName(tid, time);
            return tname == null ? tidStr : tname + " (" + tidStr + ")";
        }
        catch (NumberFormatException numberFormatException) {
            return tidStr;
        }
    }

    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((IoAnalysis)this.getAnalysisModule()).getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<SeriesBuilder> builders = new ArrayList<SeriesBuilder>();
        List selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        Map selectedEntries = this.getSelectedEntries(selectedItems);
        List<Long> times = IoPerProcessDataProvider.getTimes(ss, DataProviderParameterUtils.extractTimeRequested(fetchParameters));
        ArrayList<Integer> quarksToQuery = new ArrayList<Integer>();
        long currentEnd = ss.getCurrentEndTime();
        boolean complete = ss.waitUntilBuilt(0L) || !times.isEmpty() && times.get(times.size() - 1) <= currentEnd;
        for (Map.Entry entry : selectedEntries.entrySet()) {
            if (!this.fQuarkToString.containsKey(entry.getValue())) continue;
            SeriesBuilder seriesBuilder = new SeriesBuilder((Long)entry.getKey(), (Integer)entry.getValue(), ss.optQuarkRelative(((Integer)entry.getValue()).intValue(), new String[]{"CURRENT"}), times.size());
            builders.add(seriesBuilder);
            quarksToQuery.addAll(seriesBuilder.getQuarks());
        }
        long[] nativeTimes = new long[times.size()];
        int i = 0;
        while (i < times.size()) {
            nativeTimes[i] = times.get(i);
            ++i;
        }
        HashMap<Integer, Set<ITmfStateInterval>> intervals = new HashMap<Integer, Set<ITmfStateInterval>>();
        try {
            for (ITmfStateInterval interval : ss.query2D(quarksToQuery, times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                intervals.computeIfAbsent(interval.getAttribute(), q -> new TreeSet<ITmfStateInterval>(INTERVAL_COMPARATOR)).add(interval);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        long prevTime = -1L;
        int i2 = 0;
        while (i2 < times.size()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            long time = nativeTimes[i2];
            if (time > currentEnd) break;
            if (time >= ss.getStartTime()) {
                for (SeriesBuilder builder : builders) {
                    builder.updateValue(intervals, time, prevTime, i2);
                }
            }
            prevTime = time;
            ++i2;
        }
        ArrayList<IYModel> models = new ArrayList<IYModel>();
        for (SeriesBuilder builder : builders) {
            models.add(builder.build());
        }
        return TmfXyResponseFactory.create((String)"Example XY data provider", (long[])nativeTimes, models, (boolean)complete);
    }

    private static List<Long> getTimes(ITmfStateSystem key, @Nullable List<Long> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> times = new ArrayList<Long>();
        for (long t : list) {
            if (key.getStartTime() > t || t > key.getCurrentEndTime()) continue;
            times.add(t);
        }
        Collections.sort(times);
        return times;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static final class IoTreeDataModel
    extends TmfTreeDataModel
    implements ICoreElementResolver {
        private Multimap<String, Object> fMetadata = HashMultimap.create();

        public IoTreeDataModel(Long id, long parentId, String name, String tid, @Nullable String color, @Nullable String seriesStyle) {
            super(id.longValue(), parentId, Collections.singletonList(name), color != null, IoTreeDataModel.makeStyle(color, seriesStyle));
            try {
                int intTid = Integer.parseInt(tid);
                this.fMetadata.put((Object)OsStrings.tid(), (Object)intTid);
            }
            catch (NumberFormatException numberFormatException) {}
        }

        private static @Nullable OutputElementStyle makeStyle(@Nullable String color, @Nullable String seriesStyle) {
            if (color == null || seriesStyle == null) {
                return null;
            }
            return new OutputElementStyle(IoPerProcessDataProvider.BASE_STYLE, (Map)ImmutableMap.of((Object)"color", (Object)color, (Object)"series-style", (Object)seriesStyle));
        }

        public IoTreeDataModel(Long id, long parentId, String name, String tid) {
            this(id, parentId, name, tid, null, null);
        }

        public Multimap<String, Object> getMetadata() {
            return this.fMetadata;
        }
    }

    private static final class SeriesBuilder {
        private final long fId;
        private final int fMainQuark;
        private final double[] fValues;
        private double fPrevCount;
        private List<Integer> fRunning;

        private SeriesBuilder(long id, int sectorQuark, Integer currentOpQuark, int length) {
            this.fId = id;
            this.fMainQuark = sectorQuark;
            this.fRunning = currentOpQuark == -2 ? Collections.emptyList() : Collections.singletonList(currentOpQuark);
            this.fValues = new double[length];
            this.fPrevCount = -1.0;
        }

        private List<Integer> getQuarks() {
            ArrayList<Integer> quarks = new ArrayList<Integer>(this.fRunning);
            quarks.add(this.fMainQuark);
            return quarks;
        }

        private void updateValue(Map<Integer, Set<ITmfStateInterval>> intervals, long time, long prevTime, int currentIndex) {
            long deltaT = time - prevTime;
            if (deltaT == 0L) {
                if (currentIndex > 0) {
                    this.fValues[currentIndex] = this.fValues[currentIndex - 1];
                }
                return;
            }
            double valueAtTime = SeriesBuilder.getValueAtTime(intervals.get(this.fMainQuark), time);
            for (Integer quark : this.fRunning) {
                valueAtTime += SeriesBuilder.interpolateAtTime(intervals.get(quark), time);
            }
            if (prevTime == -1L) {
                this.fPrevCount = valueAtTime;
                return;
            }
            this.fValues[currentIndex] = (valueAtTime - this.fPrevCount) / ((double)deltaT * 1.0E-9);
            this.fPrevCount = valueAtTime;
        }

        private static double interpolateAtTime(@Nullable Set<ITmfStateInterval> intervals, long time) {
            if (intervals == null) {
                return 0.0;
            }
            ITmfStateInterval interval = SeriesBuilder.findInterval(intervals, time);
            if (interval == null) {
                return 0.0;
            }
            Object value = interval.getValue();
            return value instanceof Number ? SeriesBuilder.interpolate(time, interval, (Number)value) : 0.0;
        }

        private static double interpolate(long time, ITmfStateInterval interval, Number size) {
            long runningTime = interval.getEndTime() - interval.getStartTime() + 1L;
            return (double)(time - interval.getStartTime()) * size.doubleValue() / (double)runningTime;
        }

        private static double getValueAtTime(@Nullable Set<ITmfStateInterval> intervals, long time) {
            if (intervals == null) {
                return 0.0;
            }
            ITmfStateInterval interval = SeriesBuilder.findInterval(intervals, time);
            if (interval == null) {
                return 0.0;
            }
            Object value = interval.getValue();
            return value instanceof Number ? ((Number)value).doubleValue() : 0.0;
        }

        private static @Nullable ITmfStateInterval findInterval(Set<ITmfStateInterval> intervals, long time) {
            for (ITmfStateInterval interval : intervals) {
                if (interval.getStartTime() > time) {
                    return null;
                }
                if (time < interval.getStartTime() || time > interval.getEndTime()) continue;
                return interval;
            }
            return null;
        }

        private IYModel build() {
            return new YModel(this.fId, String.valueOf(this.fId), this.fValues, Y_AXIS_DESCRIPTION);
        }
    }
}

