/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ConnectionEndpoint {
    private static final @NonNull String ADDRESS_SEP = ".";
    private static final @NonNull String PORT_SEP = ":";
    private final long[] fAddress;
    private final long fPort;

    public ConnectionEndpoint(long[] address, long port) {
        this.fAddress = address;
        this.fPort = port;
    }

    public long[] getAddress() {
        return this.fAddress;
    }

    public long getPort() {
        return this.fPort;
    }

    public static String formatAddressPort(long[] address, long port) {
        return StringUtils.join((Object[])ArrayUtils.toObject((long[])address), (String)ADDRESS_SEP) + PORT_SEP + String.valueOf(port);
    }

    public String toString() {
        return ConnectionEndpoint.formatAddressPort(this.fAddress, this.fPort);
    }

    public static @Nullable ConnectionEndpoint fromStringFormat(String f) {
        @NonNull String[] split = f.split(PORT_SEP);
        if (split.length != 2) {
            return null;
        }
        @NonNull String[] addressStr = split[0].split(Objects.requireNonNull(Pattern.quote(ADDRESS_SEP)));
        long[] address = new long[addressStr.length];
        int i = 0;
        while (i < addressStr.length) {
            address[i] = Long.parseLong(addressStr[i]);
            ++i;
        }
        long port = Long.parseLong(split[1]);
        return new ConnectionEndpoint(address, port);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hash(this.fPort);
        result = 31 * result + Arrays.hashCode(this.fAddress);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionEndpoint)) {
            return false;
        }
        ConnectionEndpoint other = (ConnectionEndpoint)obj;
        return Arrays.equals(this.fAddress, other.fAddress) && this.fPort == other.fPort;
    }
}

