/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.experiment;

import java.util.Arrays;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public final class TmfLocationArray
implements Comparable<TmfLocationArray> {
    private final ITmfLocation[] fLocations;
    private final long[] fRanks;

    public TmfLocationArray(ITmfLocation[] locations, long[] ranks) {
        this.fLocations = Arrays.copyOf(locations, locations.length);
        this.fRanks = Arrays.copyOf(ranks, ranks.length);
    }

    public TmfLocationArray(TmfLocationArray locationArray, int index, ITmfLocation location, long rank) {
        this.fLocations = Arrays.copyOf(locationArray.fLocations, locationArray.fLocations.length);
        this.fLocations[index] = location;
        this.fRanks = Arrays.copyOf(locationArray.fRanks, locationArray.fRanks.length);
        this.fRanks[index] = rank;
    }

    public TmfLocationArray(int size) {
        this.fLocations = new ITmfLocation[size];
        this.fRanks = new long[size];
    }

    public int size() {
        return this.fLocations.length;
    }

    public ITmfLocation[] getLocations() {
        return Arrays.copyOf(this.fLocations, this.fLocations.length);
    }

    public ITmfLocation getLocation(int index) {
        if (index >= 0 && index < this.fLocations.length) {
            return this.fLocations[index];
        }
        return null;
    }

    public long[] getRanks() {
        return Arrays.copyOf(this.fRanks, this.fRanks.length);
    }

    public long getRank(int index) {
        if (index >= 0 && index < this.fRanks.length) {
            return this.fRanks[index];
        }
        return 0L;
    }

    @Override
    public int compareTo(TmfLocationArray o) {
        int i = 0;
        while (i < this.fRanks.length) {
            long rank1 = this.fRanks[i];
            long rank2 = o.fRanks[i];
            if (rank1 < rank2) {
                return -1;
            }
            if (rank1 > rank2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fLocations);
        result = 31 * result + Arrays.hashCode(this.fRanks);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfLocationArray other = (TmfLocationArray)obj;
        if (!Arrays.equals(this.fLocations, other.fLocations)) {
            return false;
        }
        return Arrays.equals(this.fRanks, other.fRanks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        int i = 0;
        while (i < this.fLocations.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[location=");
            sb.append(this.fLocations[i]);
            sb.append(",rank=");
            sb.append(this.fRanks[i]);
            sb.append(']');
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

