/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionSpecialization
extends CPPSpecialization
implements ICPPFunctionSpecialization,
ICPPInternalFunction {
    private final ICPPFunctionType fType;
    private ICPPParameter[] fParams;
    private final IType[] fExceptionSpecs;

    public CPPFunctionSpecialization(ICPPFunction orig, IBinding owner, ICPPTemplateParameterMap argMap, ICPPFunctionType type, IType[] exceptionSpecs) {
        super(orig, owner, argMap);
        this.fType = type;
        this.fExceptionSpecs = exceptionSpecs;
    }

    private ICPPFunction getFunction() {
        return (ICPPFunction)this.getSpecializedBinding();
    }

    public void setParameters(ICPPParameter[] params) {
        assert (this.fParams == null);
        this.fParams = params;
    }

    @Override
    public ICPPParameter[] getParameters() {
        return this.fParams;
    }

    @Override
    public int getRequiredArgumentCount() {
        return CPPFunction.getRequiredArgumentCount(this.getParameters());
    }

    @Override
    public boolean hasParameterPack() {
        return CPPFunction.hasParameterPack(this.getParameters());
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPFunctionType getDeclaredType() {
        return this.fType;
    }

    @Override
    public ICPPFunctionType getType() {
        return this.fType;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isInline() {
        if (this.getDefinition() != null) {
            IASTNode def = this.getDefinition();
            while (!(def instanceof IASTFunctionDefinition)) {
                def = def.getParent();
            }
            return ((IASTFunctionDefinition)def).getDeclSpecifier().isInline();
        }
        return this.getFunction().isInline();
    }

    @Override
    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        return this.getFunction().isExternC();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic(true);
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)f).isStatic(resolveAll);
        }
        if (f instanceof IIndexBinding && f instanceof ICPPFunction) {
            return ((ICPPFunction)f).isStatic();
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    @Override
    public boolean isExtern() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isExtern();
        }
        return CPPFunction.hasStorageClass(this, 2);
    }

    @Override
    public boolean isAuto() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isAuto();
        }
        return CPPFunction.hasStorageClass(this, 4);
    }

    @Override
    public boolean isConstexpr() {
        IASTNode def = this.getDefinition();
        if (def != null) {
            ICPPASTFunctionDefinition functionDefinition = CPPFunction.getFunctionDefinition(def);
            return ((ICPPASTDeclSpecifier)functionDefinition.getDeclSpecifier()).isConstexpr();
        }
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPFunction) {
            return ((ICPPFunction)f).isConstexpr();
        }
        return false;
    }

    @Override
    public boolean isDeleted() {
        IASTNode def = this.getDefinition();
        if (def != null) {
            return CPPFunction.isDeletedDefinition(def);
        }
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPFunction) {
            return ((ICPPFunction)f).isDeleted();
        }
        return false;
    }

    @Override
    public boolean isRegister() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isRegister();
        }
        return CPPFunction.hasStorageClass(this, 5);
    }

    @Override
    public boolean takesVarArgs() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.takesVarArgs();
        }
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        if (dtor != null) {
            return dtor.takesVarArgs();
        }
        ICPPASTFunctionDeclarator[] ds = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        if (ds != null && ds.length > 0) {
            return ds[0].takesVarArgs();
        }
        return false;
    }

    @Override
    public boolean isNoReturn() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isNoReturn();
        }
        return false;
    }

    @Override
    public IBinding resolveParameter(CPPParameter param) {
        int pos = param.getParameterPosition();
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen) {
            block4: {
                ICPPASTParameterDeclaration[] params;
                ICPPASTFunctionDeclarator tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = (ICPPASTFunctionDeclarator)this.getDefinition();
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = (ICPPASTFunctionDeclarator)decls[i]) == null) break;
                }
                if (pos < (params = tdecl.getParameters()).length) {
                    IASTName oName = this.getParamName(params[pos]);
                    return oName.resolvePreBinding();
                }
            }
            ++i;
        }
        return param;
    }

    protected void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        ICPPASTParameterDeclaration[] updateParams = fdtor.getParameters();
        int k = 0;
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block4: {
                ICPPASTFunctionDeclarator tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = (ICPPASTFunctionDeclarator)this.getDefinition();
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = (ICPPASTFunctionDeclarator)decls[i]) == null) break;
                }
                ICPPASTParameterDeclaration[] params = tdecl.getParameters();
                int end = Math.min(params.length, updateParams.length);
                while (k < end) {
                    IASTName oName = this.getParamName(params[k]);
                    IBinding b = oName.resolvePreBinding();
                    IASTName n = this.getParamName(updateParams[k]);
                    n.setBinding(b);
                    ASTInternal.addDeclaration(b, n);
                    ++k;
                }
            }
            ++i;
        }
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    private ICPPASTFunctionDeclarator extractFunctionDtor(IASTNode node) {
        if (node instanceof IASTName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        if (!((node = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node)) instanceof ICPPASTFunctionDeclarator)) {
            return null;
        }
        return (ICPPASTFunctionDeclarator)node;
    }

    @Override
    public void addDefinition(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateFunctionParameterBindings(dtor);
            super.addDefinition(dtor);
        }
    }

    @Override
    public void addDeclaration(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateFunctionParameterBindings(dtor);
            super.addDeclaration(dtor);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        ICPPTemplateParameterMap tpmap = this.getTemplateParameterMap();
        if (tpmap != null) {
            result.append(" ");
            result.append(tpmap.toString());
        }
        return result.toString();
    }

    @Override
    public IType[] getExceptionSpecification() {
        return this.fExceptionSpecs;
    }

    @Override
    public ICPPExecution getFunctionBodyExecution() {
        if (!this.isConstexpr()) {
            return null;
        }
        IASTNode def = this.getDefinition();
        if (def != null) {
            return CPPFunction.computeFunctionBodyExecution(def);
        }
        return CPPTemplates.instantiateFunctionBody(this);
    }
}

