/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ease.lang.python.debugger.IPyFrame;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFunction;
import org.python.core.PyJavaPackage;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;

public class JythonFrame
implements IPyFrame {
    private final PyObject fJythonFrame;

    public JythonFrame(PyObject frame) {
        this.fJythonFrame = frame;
    }

    private static boolean isNull(PyObject object) {
        return object != null && !Py.None.equals((Object)object);
    }

    public String getFilename() {
        if (JythonFrame.isNull(this.fJythonFrame)) {
            PyObject filename = this.fJythonFrame.invoke("getFilename");
            return filename.asString();
        }
        return "<No Filename>";
    }

    public int getLineNumber() {
        if (JythonFrame.isNull(this.fJythonFrame)) {
            PyObject lineNumber = this.fJythonFrame.invoke("getLineNumber");
            return Py.py2int((PyObject)lineNumber);
        }
        return -1;
    }

    public IPyFrame getParent() {
        if (JythonFrame.isNull(this.fJythonFrame)) {
            return new JythonFrame(this.fJythonFrame.invoke("getParent"));
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getFilename()) + ": #" + this.getLineNumber();
    }

    public Object getVariable(String name) {
        return null;
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        PyObject pyVariables = this.fJythonFrame.invoke("getVariables");
        if (pyVariables instanceof PyDictionary) {
            PyList keys = ((PyDictionary)pyVariables).keys();
            for (Object key : keys) {
                Object[] value = ((PyDictionary)pyVariables).get(key);
                if (value instanceof PyObjectDerived) {
                    value = ((PyObjectDerived)value).__tojava__(Object.class);
                }
                if (value instanceof PyList) {
                    value = ((PyList)value).toArray();
                }
                if (value instanceof PyFunction || value instanceof PyJavaPackage || value instanceof PyJavaType) continue;
                variables.put(key.toString(), value);
            }
        }
        return variables;
    }

    public void setVariable(String name, Object value) {
        this.fJythonFrame.invoke("setVariable", Py.java2py((Object)name), Py.java2py((Object)value));
    }
}

