/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.expressions.definitions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.expressions.Expression;

public class ExpressionFactory {
    private static ExpressionFactory fInstance = new ExpressionFactory();

    public static ExpressionFactory getInstance() {
        return fInstance;
    }

    public static Class<?> loadClazz(String name) {
        try {
            return ExpressionFactory.class.getClassLoader().loadClass("org.eclipse.core.internal.expressions." + name);
        }
        catch (ClassNotFoundException e) {
            try {
                return ExpressionFactory.class.getClassLoader().loadClass("org.eclipse.core.expressions." + name);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Could not find class " + name, e1);
            }
        }
    }

    public Expression createAndExpression(List<Expression> children) {
        return this.createCompositeExpression("AndExpression", children);
    }

    public Expression createOrExpression(List<Expression> children) {
        return this.createCompositeExpression("OrExpression", children);
    }

    private Expression createCompositeExpression(String type, List<Expression> children) {
        Class<?> clazz = ExpressionFactory.loadClazz(type);
        try {
            Object instance = clazz.newInstance();
            if (instance instanceof Expression) {
                this.addChildren(instance, children);
                return (Expression)instance;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not create instance of " + type, e);
        }
        throw new RuntimeException("Created instance is not an Expression");
    }

    public void addChildren(Object instance, List<Expression> children) {
        try {
            Method addMethod = instance.getClass().getMethod("add", Expression.class);
            for (Expression child : children) {
                addMethod.invoke(instance, child);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not add child expressions", e);
        }
    }

    public Expression createWithExpression(String parameter) {
        Class<?> clazz = ExpressionFactory.loadClazz("WithExpression");
        try {
            Object instance = clazz.getConstructor(String.class).newInstance(parameter);
            if (instance instanceof Expression) {
                return (Expression)instance;
            }
            throw new RuntimeException("Created instance is not an Expression");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of WithExpression");
        }
    }

    public Expression createReferenceExpression(String parameter) {
        Class<?> clazz = ExpressionFactory.loadClazz("ReferenceExpression");
        try {
            Object instance = clazz.getConstructor(String.class).newInstance(parameter);
            if (instance instanceof Expression) {
                return (Expression)instance;
            }
            throw new RuntimeException("Created instance is not an Expression");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of ReferenceExpression");
        }
    }

    public Expression createEqualsExpression(String parameter) {
        Class<?> clazz = ExpressionFactory.loadClazz("EqualsExpression");
        try {
            Object instance = clazz.getConstructor(Object.class).newInstance(parameter);
            if (instance instanceof Expression) {
                return (Expression)instance;
            }
            throw new RuntimeException("Created instance is not an Expression");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of EqualsExpression");
        }
    }

    public Expression createCountExpression(String parameter) {
        Class<?> clazz = ExpressionFactory.loadClazz("CountExpression");
        try {
            Object instance = clazz.getConstructor(String.class).newInstance(parameter);
            if (instance instanceof Expression) {
                return (Expression)instance;
            }
            throw new RuntimeException("Created instance is not an Expression");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of CountExpression");
        }
    }

    public Expression createTestExpression(String namespace, String property, Object[] args, Object expectedValue, boolean forcePluginActivation) {
        Class<?> clazz = ExpressionFactory.loadClazz("TestExpression");
        try {
            Object instance = clazz.getConstructor(String.class, String.class, Object[].class, Object.class, Boolean.TYPE).newInstance(namespace, property, args, expectedValue, forcePluginActivation);
            if (instance instanceof Expression) {
                return (Expression)instance;
            }
            throw new RuntimeException("Created instance is not an Expression");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of TestExpression");
        }
    }
}

