/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.interfaces.data.IUpdatable;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseWizardConfigurationPanelControl
extends BaseDialogPageControl {
    private final Map<String, IWizardConfigurationPanel> configurationPanels = new Hashtable<String, IWizardConfigurationPanel>();
    private boolean isGroup;
    private Composite panel;
    private StackLayout panelLayout;
    private String activeConfigurationPanelKey = null;
    private IWizardConfigurationPanel activeConfigurationPanel = null;
    private final AbstractWizardConfigurationPanel EMPTY_PANEL = new EmptySettingsPanel(this);

    @Override
    public void dispose() {
        this.EMPTY_PANEL.dispose();
        super.dispose();
    }

    public BaseWizardConfigurationPanelControl(IDialogPage parentPage) {
        super(parentPage);
        this.clear();
        this.setPanelIsGroup(false);
    }

    public void setPanelIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public boolean isPanelIsGroup() {
        return this.isGroup;
    }

    public Composite getPanel() {
        return this.panel;
    }

    public String getGroupLabel() {
        return null;
    }

    public void setupPanel(Composite parent, String[] configurationPanelKeys, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        this.setFormToolkit(toolkit);
        if (this.isPanelIsGroup()) {
            this.panel = new Group(parent, 0);
            if (this.getGroupLabel() != null) {
                ((Group)this.panel).setText(this.getGroupLabel());
            }
        } else {
            this.panel = new Composite(parent, 0);
        }
        Assert.isNotNull((Object)this.panel);
        this.panel.setFont(parent.getFont());
        this.panel.setBackground(parent.getBackground());
        this.panelLayout = new StackLayout();
        this.panel.setLayout((Layout)this.panelLayout);
        this.setupConfigurationPanels(this.panel, configurationPanelKeys, toolkit);
        this.EMPTY_PANEL.setupPanel(this.panel, toolkit);
    }

    public void clear() {
        this.configurationPanels.clear();
    }

    public String[] getConfigurationPanelIds() {
        return this.configurationPanels.keySet().toArray(new String[this.configurationPanels.keySet().size()]);
    }

    public IWizardConfigurationPanel getConfigurationPanel(String key) {
        IWizardConfigurationPanel panel = key != null ? this.configurationPanels.get(key) : null;
        return panel != null ? panel : this.EMPTY_PANEL;
    }

    public final boolean isEmptyConfigurationPanel(IWizardConfigurationPanel panel) {
        return this.EMPTY_PANEL == panel;
    }

    public void addConfigurationPanel(String key, IWizardConfigurationPanel panel) {
        if (key == null) {
            return;
        }
        if (panel != null) {
            this.configurationPanels.put(key, panel);
        } else {
            this.configurationPanels.remove(key);
        }
    }

    public void setupConfigurationPanels(Composite parent, String[] configurationPanelKeys, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        if (configurationPanelKeys != null) {
            int i = 0;
            while (i < configurationPanelKeys.length) {
                IWizardConfigurationPanel configPanel = this.getConfigurationPanel(configurationPanelKeys[i]);
                Assert.isNotNull((Object)configPanel);
                configPanel.setupPanel(parent, toolkit);
                ++i;
            }
        }
    }

    public void showConfigurationPanel(String key) {
        String activeKey = this.getActiveConfigurationPanelKey();
        if (key != null && key.equals(activeKey) && this.activeConfigurationPanel != null) {
            return;
        }
        IWizardConfigurationPanel configPanel = this.getActiveConfigurationPanel();
        PropertiesContainer data = new PropertiesContainer();
        if (configPanel instanceof IDataExchangeNode) {
            ((IDataExchangeNode)configPanel).extractData((IPropertiesContainer)data);
        }
        configPanel = this.getConfigurationPanel(key);
        Assert.isNotNull((Object)configPanel);
        if (configPanel.getControl() != null) {
            this.activeConfigurationPanel = configPanel;
            this.activeConfigurationPanelKey = key;
            this.panelLayout.topControl = configPanel.getControl();
            this.panel.layout();
            if (!data.isEmpty() && configPanel instanceof IUpdatable) {
                ((IUpdatable)configPanel).updateData((IPropertiesContainer)data);
            }
            configPanel.activate();
        } else {
            this.activeConfigurationPanelKey = key;
        }
    }

    public IWizardConfigurationPanel getActiveConfigurationPanel() {
        return this.activeConfigurationPanel;
    }

    public String getActiveConfigurationPanelKey() {
        return this.activeConfigurationPanelKey;
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        IWizardConfigurationPanel configPanel;
        super.doSaveWidgetValues(settings, idPrefix);
        if (settings != null && (configPanel = this.getActiveConfigurationPanel()) != null && !this.isEmptyConfigurationPanel(configPanel)) {
            String key = configPanel.getDialogSettingsSectionName();
            key = key != null ? key : this.getActiveConfigurationPanelKey();
            IDialogSettings configPanelSettings = settings.getSection(key);
            if (configPanelSettings == null) {
                configPanelSettings = settings.addNewSection(key);
            }
            configPanel.doSaveWidgetValues(configPanelSettings, idPrefix);
        }
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doRestoreWidgetValues(settings, idPrefix);
        if (settings != null) {
            for (String panelKey : this.configurationPanels.keySet()) {
                IWizardConfigurationPanel configPanel = this.getConfigurationPanel(panelKey);
                if (configPanel == null || this.isEmptyConfigurationPanel(configPanel)) continue;
                String settingsKey = configPanel.getDialogSettingsSectionName();
                settingsKey = settingsKey != null ? settingsKey : panelKey;
                IDialogSettings configPanelSettings = settings.getSection(settingsKey);
                if (configPanelSettings == null) {
                    configPanelSettings = settings.addNewSection(settingsKey);
                }
                configPanel.doRestoreWidgetValues(configPanelSettings, idPrefix);
            }
        }
    }

    private static final class EmptySettingsPanel
    extends AbstractWizardConfigurationPanel {
        public EmptySettingsPanel(BaseDialogPageControl parentControl) {
            super(parentControl);
        }

        @Override
        public void setupPanel(Composite parent, FormToolkit toolkit) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            panel.setBackground(parent.getBackground());
            this.setControl(panel);
        }

        @Override
        public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

