/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.activator;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.runtime.tracing.TraceHandler;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.listeners.WorkbenchWindowListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private static volatile ScopedEclipsePreferences scopedPreferences;
    private static volatile TraceHandler traceHandler;
    private IWindowListener windowListener;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.ui.views";
    }

    public static ScopedEclipsePreferences getScopedPreferences() {
        if (scopedPreferences == null) {
            scopedPreferences = new ScopedEclipsePreferences(UIPlugin.getUniqueIdentifier());
        }
        return scopedPreferences;
    }

    public static TraceHandler getTraceHandler() {
        if (traceHandler == null) {
            traceHandler = new TraceHandler(UIPlugin.getUniqueIdentifier());
        }
        return traceHandler;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (this.windowListener == null && PlatformUI.getWorkbench() != null) {
            this.windowListener = new WorkbenchWindowListener();
            PlatformUI.getWorkbench().addWindowListener(this.windowListener);
            this.activateContexts();
        }
    }

    void activateContexts() {
        if (Display.getCurrent() != null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && this.windowListener != null) {
                this.windowListener.windowOpened(window);
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UIPlugin.this.activateContexts();
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.windowListener != null && PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
            this.windowListener = null;
        }
        Managers.dispose();
        plugin = null;
        scopedPreferences = null;
        traceHandler = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        if (bundle != null) {
            url = bundle.getEntry("icons/full/elcl16/refresh_nav.gif");
            registry.put("RefreshAction_enabled", ImageDescriptor.createFromURL((URL)url));
        }
        url = UIPlugin.getDefault().getBundle().getEntry("icons/eview16/prop_ps.gif");
        registry.put("Editor", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/eview16/targets_view.gif");
        registry.put("View", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/etool16/menu.gif");
        registry.put("MenuAction", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/etool16/help.gif");
        registry.put("HelpAction", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/favorites.gif");
        registry.put("Favorites", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }
}

