/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import java.util.List;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.Dispatch;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.GlobalStatement;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.TraitAlias;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.ApplyAll;

public class PHPElementConciliator {
    private static final String THIS = "this";
    public static final int CONCILIATOR_UNKNOWN = 0;
    public static final int CONCILIATOR_GLOBAL_VARIABLE = 1;
    public static final int CONCILIATOR_FUNCTION = 2;
    public static final int CONCILIATOR_LOCAL_VARIABLE = 3;
    public static final int CONCILIATOR_CLASSNAME = 4;
    public static final int CONCILIATOR_CONSTANT = 5;
    public static final int CONCILIATOR_CLASS_MEMBER = 6;
    public static final int CONCILIATOR_PROGRAM = 7;
    public static final int CONCILIATOR_TRAITNAME = 8;

    public static int concile(ASTNode locateNode) {
        if (locateNode == null || PHPElementConciliator.isProgram(locateNode)) {
            return 7;
        }
        if (PHPElementConciliator.isGlobalVariable(locateNode)) {
            return 1;
        }
        if (PHPElementConciliator.isFunction(locateNode)) {
            return 2;
        }
        if (PHPElementConciliator.isClassName(locateNode)) {
            return 4;
        }
        if (PHPElementConciliator.isTraitName(locateNode)) {
            return 8;
        }
        if (PHPElementConciliator.isConstant(locateNode)) {
            return 5;
        }
        if (PHPElementConciliator.isLocalVariable(locateNode)) {
            return 3;
        }
        if (PHPElementConciliator.isDispatch(locateNode)) {
            return 6;
        }
        if (PHPElementConciliator.isGlobalNamespacedConstant(locateNode)) {
            return 5;
        }
        if (PHPElementConciliator.isGlobalConstDeclaration(locateNode)) {
            return 5;
        }
        return 0;
    }

    public static boolean isGlobalNamespacedConstant(ASTNode locateNode) {
        assert (locateNode != null);
        if (locateNode.getType() != 33) {
            return false;
        }
        ASTNode parent = locateNode.getParent();
        if (parent.getType() != 65) {
            return false;
        }
        NamespaceName namespaceName = (NamespaceName)parent;
        return (parent = namespaceName.getParent()).getType() != 31 && parent.getType() != 14 && parent.getType() != 64 && parent.getType() != 66 && parent.getType() != 71 && parent.getType() != 78 && parent.getType() != 77;
    }

    public static boolean isGlobalConstDeclaration(ASTNode locateNode) {
        assert (locateNode != null);
        if (locateNode.getType() != 33) {
            return false;
        }
        ASTNode parent = locateNode.getParent();
        if (parent.getType() == 11) {
            while (parent.getParent() != null) {
                if ((parent = parent.getParent()).getType() != 12 && parent.getType() != 40 && parent.getType() != 77) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isDispatch(ASTNode locateNode) {
        if (!PHPElementConciliator.$assertionsDisabled && locateNode == null) {
            throw new AssertionError();
        }
        parent = null;
        type = locateNode.getType();
        if (locateNode instanceof Identifier && ((Identifier)locateNode).getParent() instanceof Variable) {
            parent = ((Identifier)locateNode).getParent();
            parent = parent.getParent();
        } else {
            parent = type == 63 || type == 25 || type == 90 || type == 42 ? locateNode : locateNode.getParent();
        }
        if (parent instanceof TraitAlias) {
            return true;
        }
        if (parent.getType() == 29) {
            return parent.getParent() != null && (parent = parent.getParent()).getType() == 42;
        }
        if (parent.getType() == 73) {
            reference = (FullyQualifiedTraitMethodReference)parent;
            return reference.getFunctionName() == locateNode;
        }
        if (parent.getType() == 63 && (parent.getParent().getType() == 25 || parent.getParent().getType() == 63)) {
            return true;
        }
        if (parent.getType() == 25 || parent.getType() == 90 || parent.getType() == 42) {
            return true;
        }
        if (parent.getType() == 60 && (parent.getParent().getType() == 25 || parent.getParent().getType() == 63)) {
            return true;
        }
        if (parent.getType() != 11 || PHPElementConciliator.isGlobalConstDeclaration(locateNode)) ** GOTO lbl28
        return true;
lbl-1000:
        // 1 sources

        {
            if (parent instanceof Dispatch || parent instanceof StaticDispatch) {
                return true;
            }
            parent = parent.getParent();
lbl28:
            // 2 sources

            ** while (parent != null)
        }
lbl29:
        // 1 sources

        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isConstant(ASTNode locateNode) {
        assert (locateNode != null);
        Scalar scalar = null;
        if (locateNode.getType() != 51) {
            ASTNode parent = locateNode.getParent();
            ASTNode node = null;
            node = parent instanceof NamespaceName ? parent.getParent().getParent() : parent.getParent();
            if (!(locateNode instanceof Identifier) || !"define".equals(((Identifier)locateNode).getName()) || !(node instanceof FunctionInvocation)) return false;
            FunctionInvocation inv = (FunctionInvocation)node;
            List<Expression> parameters = inv.parameters();
            if (parameters != null && parameters.size() > 0) {
                Expression param = parameters.get(0);
                if (!(param instanceof Scalar)) return false;
                scalar = (Scalar)param;
            }
        } else {
            scalar = (Scalar)locateNode;
        }
        if (scalar == null || scalar.getScalarType() != 2 || scalar.getStringValue().length() == 0) {
            return false;
        }
        int length = scalar.getStringValue().length() - 1;
        char charAtBegining = scalar.getStringValue().charAt(0);
        char charAtEnd = scalar.getStringValue().charAt(length);
        if (!PHPElementConciliator.detectString(charAtEnd) && !PHPElementConciliator.detectString(charAtBegining)) {
            return true;
        }
        ASTNode previous = locateNode.getParent();
        if (previous instanceof NamespaceName) {
            previous = previous.getParent();
        }
        if (previous.getType() == 31) {
            previous = previous.getParent();
        }
        if (previous.getType() != 30) {
            return false;
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)previous;
        if (functionInvocation.getFunctionName().getName() instanceof Identifier) Identifier identifier;
        return "define".equalsIgnoreCase((identifier = (Identifier)functionInvocation.getFunctionName().getName()).getName()) || "constant".equalsIgnoreCase(identifier.getName());
        return false;
    }

    private static boolean isClassName(ASTNode locateNode) {
        StaticDispatch staticDispatch;
        assert (locateNode != null);
        ASTNode parent = null;
        if (locateNode.getType() == 12 || locateNode.getType() == 40 || locateNode.getType() == 89) {
            parent = locateNode;
        } else if (locateNode.getType() == 33) {
            parent = locateNode.getParent();
        } else {
            return false;
        }
        if (parent.getType() == 65) {
            locateNode = parent;
            parent = parent.getParent();
        }
        if (parent instanceof TraitDeclaration) {
            return false;
        }
        int parentType = parent.getType();
        if (parentType == 14 || parentType == 82 || parentType == 12 || parentType == 40 || parentType == 89 || parentType == 9 || parentType == 27 || parentType == 66 || parentType == 78 || parentType == 77) {
            return true;
        }
        return (parentType == 53 || parentType == 52 || parentType == 10) && (staticDispatch = (StaticDispatch)parent).getClassName() == locateNode;
    }

    private static boolean isTraitName(ASTNode locateNode) {
        int parentType;
        assert (locateNode != null);
        ASTNode parent = null;
        if (locateNode.getType() == 12) {
            parent = locateNode;
        } else if (locateNode.getType() == 33) {
            parent = locateNode.getParent();
        } else {
            return false;
        }
        if (parent.getType() == 65) {
            locateNode = parent;
            parent = parent.getParent();
        }
        if ((parentType = parent.getType()) == 12 || parentType == 71 || parentType == 73) {
            FullyQualifiedTraitMethodReference reference;
            return parentType != 73 || (reference = (FullyQualifiedTraitMethodReference)parent).getFunctionName() != locateNode;
        }
        return false;
    }

    private static boolean isLocalVariable(ASTNode locateNode) {
        assert (locateNode != null);
        Variable parent = null;
        if (locateNode instanceof Identifier && ((Identifier)locateNode).getParent() instanceof Variable) {
            parent = (Variable)((Identifier)locateNode).getParent();
        } else if (locateNode.getType() == 60) {
            parent = (Variable)locateNode;
        } else {
            return false;
        }
        if (!parent.isDollared() && !ASTNodes.isQuotedDollaredCurlied(parent) || PHPElementConciliator.isThisVariable(parent) || parent.getType() == 25) {
            return false;
        }
        if (parent.isDollared() && parent.getParent() != null && parent.getParent().getType() == 52) {
            return false;
        }
        if (parent.isDollared() && parent.getParent() != null && parent.getParent().getType() == 0 && parent != ((ArrayAccess)parent.getParent()).getIndex() && parent.getParent().getParent().getType() == 52) {
            return false;
        }
        ASTNode node = parent;
        while (node != null) {
            int type = ((ASTNode)node).getType();
            if (type == 29) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static final boolean isThisVariable(Variable variable) {
        return (variable.isDollared() || ASTNodes.isQuotedDollaredCurlied(variable)) && variable.getName() instanceof Identifier && THIS.equalsIgnoreCase(((Identifier)variable.getName()).getName());
    }

    private static boolean isGlobalVariable(ASTNode locateNode) {
        assert (locateNode != null);
        if (locateNode.getType() == 60) {
            return PHPElementConciliator.checkGlobalVariable((Variable)locateNode);
        }
        return PHPElementConciliator.checkGlobalIdentifier(locateNode);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkGlobalIdentifier(ASTNode locateNode) {
        if (locateNode.getType() == 51) {
            scalar = (Scalar)locateNode;
            return PHPElementConciliator.checkGLOBALS(scalar);
        }
        if (locateNode.getType() != 33) {
            return false;
        }
        targetIdentifier = (Identifier)locateNode;
        parent = locateNode.getParent();
        if (parent == null || parent.getType() != 60) {
            return false;
        }
        variable = (Variable)parent;
        if (!variable.isDollared() && !ASTNodes.isQuotedDollaredCurlied(variable) || variable.getParent().getType() == 25) {
            return false;
        }
        if (parent.getParent().getType() == 52 && (staticFieldAccess = (StaticFieldAccess)parent.getParent()).getMember() == variable) {
            return false;
        }
        if (parent.getParent().getLocationInParent() != FieldsDeclaration.FIELDS_PROPERTY) ** GOTO lbl23
        return false;
lbl-1000:
        // 1 sources

        {
            if (parent.getType() == 29) {
                end = parent.getEnd();
                searchGlobal = new GlobalSeacher(end, targetIdentifier);
                parent.accept(searchGlobal);
                return searchGlobal.offset <= targetIdentifier.getStart();
            }
            parent = parent.getParent();
lbl23:
            // 2 sources

            ** while (parent != null)
        }
lbl24:
        // 1 sources

        return true;
    }

    private static boolean checkGlobalVariable(Variable locateNode) {
        assert (locateNode.getType() == 60);
        if (locateNode.getParent().getType() == 52) {
            return false;
        }
        return locateNode.getParent().getType() == 32 || locateNode.getEnclosingBodyNode() != null && locateNode.getEnclosingBodyNode().getType() == 46;
    }

    private static boolean checkGLOBALS(Scalar scalar) {
        Variable var;
        ArrayAccess arrayAccess;
        VariableBase variableName;
        String stringValue = scalar.getStringValue();
        if (scalar.getScalarType() != 2 || stringValue.length() < 3) {
            return false;
        }
        char charAtZero = stringValue.charAt(0);
        char charAtEnd = stringValue.charAt(stringValue.length() - 1);
        if (!PHPElementConciliator.detectString(charAtZero) || !PHPElementConciliator.detectString(charAtEnd)) {
            return false;
        }
        if (scalar.getParent().getType() == 0 && (variableName = (arrayAccess = (ArrayAccess)scalar.getParent()).getName()).getType() == 60 && ((var = (Variable)variableName).isDollared() || ASTNodes.isQuotedDollaredCurlied(var)) && var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            return id.getName().equals("_GLOBALS") || id.getName().equals("GLOBALS");
        }
        return false;
    }

    private static boolean checkGlobal(Identifier targetIdentifier, GlobalStatement globalStatement) {
        List<Variable> variables = globalStatement.variables();
        for (Variable current : variables) {
            Identifier id;
            if (!current.isDollared() || !(current.getName() instanceof Identifier) || !(id = (Identifier)current.getName()).getName().equals(targetIdentifier.getName())) continue;
            return true;
        }
        return false;
    }

    private static final boolean detectString(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private static boolean isFunction(ASTNode locateNode) {
        int parentParentType;
        assert (locateNode != null);
        ASTNode parent = null;
        Identifier targetIdentifier = null;
        boolean isNamespaceName = false;
        if (locateNode.getType() == 29) {
            parent = locateNode;
            targetIdentifier = ((FunctionDeclaration)locateNode).getFunctionName();
        } else if (locateNode instanceof Identifier && !"define".equals(((Identifier)locateNode).getName())) {
            targetIdentifier = (Identifier)locateNode;
            parent = targetIdentifier.getParent();
            if (parent != null && parent.getType() == 65) {
                parent = parent.getParent();
                isNamespaceName = true;
            }
        } else {
            return false;
        }
        if (parent == null || parent.getType() != 29 && parent.getType() != 31 || parent.getParent().getType() == 42 || parent.getType() == 73 || isNamespaceName && parent.getType() == 29) {
            return false;
        }
        if (parent instanceof TraitAlias) {
            return false;
        }
        int type = parent.getParent().getType();
        return !(type == 30 ? (parentParentType = parent.getParent().getParent().getType()) == 42 || parentParentType == 53 : type == 42);
    }

    private static boolean isProgram(ASTNode locateNode) {
        assert (locateNode != null);
        return locateNode.getType() == 46;
    }

    public static boolean constantAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        DefinedSearcher checkConstantVisitor = new DefinedSearcher(name);
        program.accept(checkConstantVisitor);
        return checkConstantVisitor.constantAlreadyExists();
    }

    public static boolean classNameAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        ClassSearcher checkClassVisitor = new ClassSearcher(name);
        program.accept(checkClassVisitor);
        return checkClassVisitor.classNameAlreadyExists();
    }

    public static boolean classMemberAlreadyExists(TypeDeclaration typeDeclaration, String name, int type) {
        assert (typeDeclaration != null && name != null);
        ClassMemberSearcher checkClassVisitor = new ClassMemberSearcher(name, type);
        typeDeclaration.accept(checkClassVisitor);
        return checkClassVisitor.classMemberAlreadyExists();
    }

    public static boolean localVariableAlreadyExists(FunctionDeclaration functionDeclaration, String name) {
        assert (functionDeclaration != null && name != null);
        LocalVariableSearcher checkLocalVariable = new LocalVariableSearcher(name);
        functionDeclaration.accept(checkLocalVariable);
        return checkLocalVariable.localVariableAlreadyExists();
    }

    public static boolean functionAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        FunctionSearcher checkFunctionVisitor = new FunctionSearcher(name);
        program.accept(checkFunctionVisitor);
        return checkFunctionVisitor.functionAlreadyExists();
    }

    public static boolean globalVariableAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        GlobalVariableSearcher checkGlobalVisitor = new GlobalVariableSearcher(name);
        program.accept(checkGlobalVisitor);
        return checkGlobalVisitor.globalVariableAlreadyExists();
    }

    private static class ClassMemberSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;
        private int type;

        public ClassMemberSearcher(String name, int type) {
            if (name == null) {
                throw new IllegalArgumentException("member name should not be null");
            }
            this.name = name;
            this.type = type;
        }

        @Override
        public boolean apply(ASTNode node) {
            Identifier id;
            if (this.exists) {
                return false;
            }
            if (node instanceof Identifier && this.name.equals((id = (Identifier)node).getName()) && id.getParent().getType() == this.type) {
                this.exists = true;
            }
            return true;
        }

        public boolean classMemberAlreadyExists() {
            return this.exists;
        }
    }

    private static class ClassSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public ClassSearcher(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(ASTNode node) {
            TypeDeclaration typeDeclaration;
            if (this.exists) {
                return false;
            }
            if ((node.getType() == 12 || node.getType() == 40) && (typeDeclaration = (TypeDeclaration)node).getName().getName().equals(this.name)) {
                this.exists = true;
            }
            return true;
        }

        public boolean classNameAlreadyExists() {
            return this.exists;
        }
    }

    private static class DefinedSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public DefinedSearcher(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(ASTNode node) {
            if (this.exists) {
                return false;
            }
            if (node.getType() == 51) {
                Scalar scalar = (Scalar)node;
                String stringValue = scalar.getStringValue();
                if (scalar.getScalarType() != 2 || stringValue.length() == 0) {
                    return false;
                }
                int length = stringValue.length() - 1;
                if (stringValue.charAt(0) != '\"' && stringValue.charAt(length) != '\"' && stringValue.equals(this.name)) {
                    this.exists = true;
                }
            } else if (node.getType() == 30) {
                FunctionInvocation functionInvocation = (FunctionInvocation)node;
                Expression functionName = functionInvocation.getFunctionName().getName();
                if (!(functionName instanceof Identifier)) {
                    return false;
                }
                Identifier identifier = (Identifier)functionName;
                List<Expression> parameters = functionInvocation.parameters();
                if (!"define".equalsIgnoreCase(identifier.getName()) || parameters == null || parameters.size() == 0) {
                    return false;
                }
                Expression expression = parameters.get(0);
                if (expression.getType() != 51) {
                    return false;
                }
                Scalar scalar = (Scalar)expression;
                String stringValue = scalar.getStringValue();
                if (stringValue.length() < 2 || stringValue.charAt(0) != '\"') {
                    return false;
                }
                this.exists = this.name.equals(stringValue.substring(1, stringValue.length() - 1));
            }
            return true;
        }

        public boolean constantAlreadyExists() {
            return this.exists;
        }
    }

    private static class FunctionSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public FunctionSearcher(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(ASTNode node) {
            FunctionDeclaration functionDeclaration;
            Identifier identifier;
            if (this.exists) {
                return false;
            }
            if (node.getType() != 12 && node.getType() == 29 && (identifier = (functionDeclaration = (FunctionDeclaration)node).getFunctionName()).getName().equalsIgnoreCase(this.name)) {
                this.exists = true;
            }
            return true;
        }

        public boolean functionAlreadyExists() {
            return this.exists;
        }
    }

    private static class GlobalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private boolean isGlobalScope = true;
        private final String name;

        public GlobalVariableSearcher(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(ASTNode node) {
            if (this.exists) {
                return false;
            }
            if (node.getType() == 12 || node.getType() == 29) {
                this.isGlobalScope = false;
                node.childrenAccept(this);
                this.isGlobalScope = true;
                return false;
            }
            if (node instanceof Identifier) {
                Variable variable;
                Identifier identifier = (Identifier)node;
                if (identifier.getParent().getType() == 60 && ((variable = (Variable)identifier.getParent()).isDollared() || ASTNodes.isQuotedDollaredCurlied(variable)) && this.isGlobalScope && this.name.equals(identifier.getName())) {
                    this.exists = true;
                }
            } else if (node.getType() == 32) {
                GlobalStatement globalStatement = (GlobalStatement)node;
                List<Variable> variables = globalStatement.variables();
                for (Variable variable : variables) {
                    Identifier identifier;
                    Expression variableName = variable.getName();
                    if (!variable.isDollared() || !(variableName instanceof Identifier) || !this.name.equals((identifier = (Identifier)variableName).getName())) continue;
                    this.exists = true;
                }
            }
            return true;
        }

        public boolean globalVariableAlreadyExists() {
            return this.exists;
        }
    }

    private static class LocalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public LocalVariableSearcher(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(ASTNode node) {
            Variable variable;
            if (this.exists) {
                return false;
            }
            if (node.getType() == 60 && ((variable = (Variable)node).isDollared() || ASTNodes.isQuotedDollaredCurlied(variable))) {
                assert (variable.getName().getType() == 33);
                Identifier identifier = (Identifier)variable.getName();
                if (identifier.getName().equals(this.name)) {
                    this.exists = true;
                }
            }
            return true;
        }

        public boolean localVariableAlreadyExists() {
            return this.exists;
        }
    }
}

