/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import org.eclipse.php.astview.views.Binding;
import org.eclipse.php.astview.views.ExceptionAttribute;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.swt.graphics.Image;

public abstract class DynamicBindingProperty
extends ExceptionAttribute {
    protected static final String N_A = "N/A";
    private final Binding fParent;
    private Binding fViewerElement;
    private String fLabel = "<unknown>";

    public DynamicBindingProperty(Binding parent) {
        this.fParent = parent;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        return EMPTY;
    }

    public void setViewerElement(Binding viewerElement) {
        if (this.fViewerElement == viewerElement) {
            return;
        }
        this.fViewerElement = viewerElement;
        this.fException = null;
        IBinding trayBinding = this.fParent.getBinding();
        StringBuilder buf = new StringBuilder(this.getName());
        if (viewerElement != null) {
            IBinding viewerBinding = viewerElement.getBinding();
            try {
                String queryResult = this.executeQuery(viewerBinding, trayBinding);
                buf.append(queryResult);
            }
            catch (RuntimeException e) {
                this.fException = e;
                buf.append(e.getClass().getName());
                buf.append(" for \"");
                if (viewerBinding == null) {
                    buf.append("null");
                } else {
                    buf.append('\"').append(viewerBinding.getKey());
                }
                buf.append("\" and ");
                buf.append(trayBinding.getKey()).append('\"');
            }
        } else {
            buf.append(N_A);
        }
        this.fLabel = buf.toString();
    }

    protected abstract String executeQuery(IBinding var1, IBinding var2);

    protected abstract String getName();

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public Image getImage() {
        return null;
    }
}

