/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import org.eclipse.php.astview.views.ASTView;
import org.eclipse.php.astview.views.ExceptionAttribute;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.swt.graphics.Image;

public abstract class DynamicAttributeProperty
extends ExceptionAttribute {
    protected static final String N_A = "N/A";
    private final Object fParent;
    private final String fName;
    private Object fViewerElement;
    private String fLabel = "<unknown>";

    public DynamicAttributeProperty(Object parentAttribute, String name) {
        this.fParent = parentAttribute;
        this.fName = name;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        return EMPTY;
    }

    public void setViewerElement(Object viewerAttribute) {
        if (this.fViewerElement == viewerAttribute) {
            return;
        }
        this.fViewerElement = viewerAttribute;
        this.fException = null;
        Object trayObject = ASTView.unwrapAttribute(this.fParent);
        StringBuilder buf = new StringBuilder(this.fName);
        if (viewerAttribute != null) {
            Object viewerObject = ASTView.unwrapAttribute(viewerAttribute);
            try {
                String queryResult = this.executeQuery(viewerObject, trayObject);
                buf.append(queryResult);
            }
            catch (RuntimeException e) {
                this.fException = e;
                buf.append(e.getClass().getName());
                buf.append(" for \"");
                if (viewerObject == null) {
                    buf.append("null");
                } else {
                    buf.append('\"').append(this.objectToString(viewerObject));
                }
                buf.append("\" and ");
                buf.append(this.objectToString(trayObject)).append('\"');
            }
        } else {
            buf.append(N_A);
        }
        this.fLabel = buf.toString();
    }

    private String objectToString(Object object) {
        if (object instanceof IBinding) {
            return ((IBinding)object).getKey();
        }
        return String.valueOf(object);
    }

    protected abstract String executeQuery(Object var1, Object var2);

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public Image getImage() {
        return null;
    }
}

