/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDBGpValue
extends DBGpElement
implements IValue,
IPHPDataType {
    protected IPHPDataType.DataType fDataType;
    protected boolean fHasVariables = false;
    protected DBGpVariable fOwner;
    protected String fValueString = "";
    protected Node fDescriptor;

    public AbstractDBGpValue(DBGpVariable owner) {
        super(owner.getDebugTarget());
        this.fOwner = owner;
    }

    @Override
    public IPHPDataType.DataType getDataType() {
        return this.fDataType;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fDataType.getText();
    }

    public String getValueString() throws DebugException {
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return this.fHasVariables;
    }

    public String getValueDetail() throws DebugException {
        return this.getValueString();
    }

    protected abstract String createValueString(DBGpValueData var1);

    protected abstract boolean supportsValueModification();

    protected abstract boolean verifyValue(String var1);

    protected void setValue(String value) {
        this.fValueString = value;
    }

    protected DBGpVariable getOwner() {
        return this.fOwner;
    }

    protected Node getDescriptor() {
        return this.fDescriptor;
    }

    protected void update(Node descriptor) {
        this.fDescriptor = descriptor;
        String t = DBGpResponse.getAttribute(this.fDescriptor, "type");
        this.fDataType = IPHPDataType.DataType.find(t);
        this.fValueString = this.createValueString(new DBGpValueData(this.fDescriptor));
    }

    protected class DBGpValueData {
        private byte[] fValueBytes = null;
        private String fValueString;

        protected DBGpValueData(Node property) {
            this.decode(property);
        }

        private void decode(Node property) {
            if (property.hasChildNodes()) {
                NodeList childProperties = property.getChildNodes();
                int nbChildrens = childProperties.getLength();
                int i = nbChildrens - 1;
                while (i >= 0) {
                    Node childProperty = childProperties.item(i);
                    if (childProperty.getNodeName().equals("value")) {
                        property = childProperty;
                        break;
                    }
                    --i;
                }
            }
            DBGpTarget target = (DBGpTarget)AbstractDBGpValue.this.getDebugTarget();
            this.fValueString = DBGpUtils.getEncodedStringValue(property, target.getBinaryEncoding());
        }

        public byte[] getValueBytes() {
            return this.fValueBytes;
        }

        public String getValueString() {
            return this.fValueString;
        }
    }
}

