/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.format.IProfile;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.internal.ui.actions.OrganizeUseStatementsAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class OrganizeUseStatementsActionTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected IProject project;
    protected IFile testFile;
    protected IFile[] otherFiles = new IFile[0];
    protected PHPVersion phpVersion;
    protected PHPStructuredEditor fEditor;
    protected IScopeContext scopeContext;
    protected ProfileManager profileManager;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.getLatestVersion(), new String[]{"/workspace/organize-imports/php53", "/workspace/organize-imports/php54", "/workspace/organize-imports/php56"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public OrganizeUseStatementsActionTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("OrganizeUseStatements_" + String.valueOf(this.phpVersion)));
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("indentationChar", "\t");
        settings.put("org.eclipse.php.formatter.core.formatter.indentation.size", "1");
        ProfileManager.CustomProfile profile = new ProfileManager.CustomProfile("test", settings);
        this.scopeContext = InstanceScope.INSTANCE;
        this.profileManager = new ProfileManager(new ArrayList(), this.scopeContext);
        this.profileManager.addProfile(profile);
        this.profileManager.setSelected((IProfile)profile);
        this.profileManager.commitChanges(this.scopeContext);
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        OrganizeUseStatementsActionTests.setDefaultFormatter(this.scopeContext, this.profileManager);
        TestUtils.deleteProject((IProject)this.project);
    }

    private static void setDefaultFormatter(IScopeContext scopeContext, ProfileManager profileManager) {
        profileManager.clearAllSettings(scopeContext);
        if (profileManager.getSelected().getID() != "org.eclipse.php.formatter.ui.default") {
            profileManager.setSelected((IProfile)profileManager.getProfile("org.eclipse.php.formatter.ui.default"));
        }
        profileManager.commitChanges(scopeContext);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
        if (this.otherFiles != null) {
            IFile[] iFileArray = this.otherFiles;
            int n = this.otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                TestUtils.deleteFile((IFile)f);
                ++n2;
            }
            this.otherFiles = null;
        }
    }

    @Test
    public void assist(String fileName) throws Exception {
        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        final String[] result = new String[1];
        final Exception[] err = new Exception[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    OrganizeUseStatementsActionTests.this.createFile(pdttFile.getFile(), Long.toString(System.currentTimeMillis()), OrganizeUseStatementsActionTests.this.prepareOtherStreams(pdttFile));
                    OrganizeUseStatementsActionTests.this.openEditor();
                    result[0] = OrganizeUseStatementsActionTests.this.execute();
                    OrganizeUseStatementsActionTests.this.closeEditor();
                }
                catch (Exception e) {
                    err[0] = e;
                }
            }
        });
        if (err[0] != null) {
            throw err[0];
        }
        PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)result[0]);
    }

    protected InputStream[] prepareOtherStreams(PdttFile file) {
        String[] contents = file.getOtherFiles();
        InputStream[] result = new InputStream[contents.length];
        int i = 0;
        while (i < contents.length) {
            result[i] = new ByteArrayInputStream(contents[i].getBytes());
            ++i;
        }
        return result;
    }

    protected void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.test.editor", false);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    protected void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
        if (this.testFile.exists()) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    protected String execute() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        if (this.fEditor instanceof PHPStructuredEditor) {
            OrganizeUseStatementsAction action = new OrganizeUseStatementsAction((IEditorPart)this.fEditor);
            action.run(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false));
        }
        return this.fEditor.getDocument().get();
    }

    protected void createFile(String data, String fileName, InputStream[] other) throws Exception {
        this.testFile = TestUtils.createFile((IProject)this.project, (String)new Path(fileName).removeFileExtension().addFileExtension("php").lastSegment(), (String)data);
        this.otherFiles = new IFile[other.length];
        int i = 0;
        while (i < other.length) {
            this.otherFiles[i] = this.project.getFile(new Path(i + fileName).addFileExtension("php").lastSegment());
            this.otherFiles[i].create(other[i], true, null);
            ++i;
        }
        TestUtils.waitForIndexer();
    }
}

