/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.preference;

import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.launch.PHPUnitLaunchUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PHPUnitPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.php.phpunit.preferences";
    private static final String PHAR_FILE = "phpunit.phar";
    private IntegerFieldEditor fPHPUnitPortField;
    private FileFieldEditor fPHPUnitPharField;

    public PHPUnitPreferencePage() {
        super(PHPUnitMessages.PHPUnitPreferencePage_Name, PHPUnitPlugin.getImageDescriptor("main.png"), 1);
        this.setPreferenceStore(PHPUnitPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
    }

    protected void createFieldEditors() {
        this.fPHPUnitPharField = new FileFieldEditor("PHPUnit_Phar_Path", PHPUnitMessages.PHPUnitPreferencePage_Phpunit_phar, this.getFieldEditorParent());
        this.fPHPUnitPharField.setFileExtensions(new String[]{"*.phar"});
        GridData gridData = (GridData)this.fPHPUnitPharField.getTextControl(this.getFieldEditorParent()).getLayoutData();
        gridData.widthHint = 120;
        this.addField((FieldEditor)this.fPHPUnitPharField);
        this.fPHPUnitPortField = new IntegerFieldEditor("PHPUnit_Port", PHPUnitMessages.PHPUnitPreferencePage_Port, this.getFieldEditorParent(), 5);
        this.addField((FieldEditor)this.fPHPUnitPortField);
        this.addField((FieldEditor)new BooleanFieldEditor("PHPUnit_CodeCoverage", PHPUnitMessages.PHPUnitPreferencePage_Coverage, 1, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("PHPUnit_Reporting", PHPUnitMessages.PHPUnitPreferencePage_Generate_Report, 1, this.getFieldEditorParent()));
        DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("PHPUnit_ReportPath", PHPUnitMessages.PHPUnitPreferencePage_TransformedXMLOutput0, this.getFieldEditorParent());
        gridData = (GridData)directoryFieldEditor.getTextControl(this.getFieldEditorParent()).getLayoutData();
        gridData.widthHint = 120;
        this.addField((FieldEditor)directoryFieldEditor);
    }

    public boolean performOk() {
        if (this.portIsOccupied()) {
            this.setErrorMessage(PHPUnitMessages.PHPUnitPreferencePage_PortOccupied);
            return false;
        }
        return super.performOk();
    }

    public void performDefaults() {
        IPath pharPath;
        IPath resourcesPath = PHPUnitLaunchUtils.getResourcesPath();
        if (resourcesPath != null && (pharPath = resourcesPath.append(PHAR_FILE)).toFile().exists()) {
            this.getPreferenceStore().setDefault("PHPUnit_Phar_Path", pharPath.toOSString());
        }
        super.performDefaults();
    }

    private boolean portIsOccupied() {
        int portNumber = this.fPHPUnitPortField.getIntValue();
        ServerSocket serverSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(portNumber);
            }
            catch (IOException e) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        return true;
                    }
                }
                return true;
            }
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    return true;
                }
            }
        }
        return false;
    }
}

