/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.phpunit.ui.launch.PHPUnitOptionsList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPUnitBasicLauncher {
    protected ILaunchConfiguration configuration;
    protected ILaunch launch;
    protected PHPUnitOptionsList optionsList;

    public PHPUnitBasicLauncher(ILaunchConfiguration configuration, ILaunch launch, PHPUnitOptionsList optionsList) {
        this.configuration = configuration;
        this.launch = launch;
        this.optionsList = optionsList;
    }

    public void launch(String mode, IProject project, File workingDir, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        if (!PHPLaunchUtilities.notifyPreviousLaunches((ILaunch)this.launch)) {
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        String phpExeString = this.configuration.getAttribute("ATTR_LOCATION", null);
        String fileName = this.configuration.getAttribute("ATTR_FILE_FULL_PATH", null);
        if (monitor.isCanceled()) {
            return;
        }
        if (phpExeString == null) {
            this.displayErrorMessage(PHPDebugCoreMessages.PHPExecutableLaunchDelegate_4);
            return;
        }
        if (mode.equals("profile")) {
            this.launchProfileMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
        } else if (mode.equals("debug")) {
            this.launchDebugMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
        } else if (mode.equals("run")) {
            this.launchRunMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
        }
    }

    protected void launchRunMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        PHPexeItem[] items;
        Path phpExe = new Path(phpExeString);
        Object[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(this.configuration);
        File phpExeFile = new File(phpExeString);
        String phpIniLocation = this.launch.getAttribute("PHPIniLocation");
        String phpConfigDir = phpExeFile.getParent();
        if (phpIniLocation != null && !phpIniLocation.equals("")) {
            phpConfigDir = new File(phpIniLocation).getParent();
        }
        String sapiType = null;
        PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.getExecutable().equals(phpExeFile)) {
                sapiType = item.getSapiType();
                break;
            }
            ++n2;
        }
        String[] args = PHPLaunchUtilities.getProgramArguments((ILaunchConfiguration)this.launch.getLaunchConfiguration());
        Object[] cmdLine = this.getCommandLine(project, phpExeString, phpConfigDir, fileName, (String[])("CLI".equals(sapiType) ? args : null));
        String libPath = PHPLaunchUtilities.getLibrarySearchPathEnv((File)phpExeFile.getParentFile());
        if (libPath != null) {
            String[] envpNew = new String[envp == null ? 1 : envp.length + 1];
            if (envp != null) {
                System.arraycopy(envp, 0, envpNew, 0, envp.length);
            }
            envpNew[envpNew.length - 1] = libPath;
            envp = envpNew;
        }
        if (monitor.isCanceled()) {
            return;
        }
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.addAll(Arrays.asList(cmdLine));
        allArgs.addAll(this.optionsList.getList());
        cmdLine = allArgs.toArray(new String[0]);
        if (PHPDebugPlugin.DEBUG) {
            System.out.println("Executing: " + Arrays.toString(cmdLine));
            System.out.println("Process environment: " + Arrays.toString(envp));
        }
        Process p = workingDir.exists() ? DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp) : DebugPlugin.exec((String[])cmdLine, null, (String[])envp);
        new Thread((Runnable)new ProcessCrashDetector(this.launch, p)).start();
        IProcess process = null;
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = phpExe.lastSegment();
        String extension = phpExe.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        if (p != null) {
            subMonitor = new SubProgressMonitor(monitor, 80);
            process = DebugPlugin.newProcess((ILaunch)this.launch, (Process)p, (String)phpExe.toOSString(), processAttributes);
            if (process == null) {
                p.destroy();
                throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
            }
            subMonitor.done();
        }
        process.setAttribute(IProcess.ATTR_CMDLINE, fileName);
        if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)this.configuration)) {
            while (!process.isTerminated()) {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            subMonitor = new SubProgressMonitor(monitor, 10);
            RefreshTab.refreshResources((ILaunchConfiguration)this.configuration, (IProgressMonitor)subMonitor);
        }
    }

    protected void launchDebugMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.launchRunMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
    }

    protected void launchProfileMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.launchRunMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
    }

    public String[] getCommandLine(IProject project, String phpExe, String phpConfigDir, String scriptPath, String[] args) throws CoreException {
        String aspTags = ProjectOptions.isSupportingASPTags((IProject)project) ? "on" : "off";
        String shortOpenTag = ProjectOptions.useShortTags((IProject)project) ? "on" : "off";
        LinkedList<String> cmdLineList = new LinkedList<String>();
        cmdLineList.addAll(Arrays.asList(phpExe, "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, "-d", "short_open_tag=" + shortOpenTag, scriptPath));
        if (args != null) {
            cmdLineList.addAll(Arrays.asList(args));
        }
        return cmdLineList.toArray(new String[cmdLineList.size()]);
    }

    protected void displayErrorMessage(String message) {
        Display display = Display.getDefault();
        display.asyncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)message));
    }
}

