/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.AbstractDebugOutputView;
import org.eclipse.php.ui.util.PartListenerAdapter;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class DebugBrowserView
extends AbstractDebugOutputView
implements ISelectionListener {
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private Browser fSWTBrowser;
    private IDebugEventSetListener fTerminateListener;
    private DebugViewPartListener fPartListener;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 1;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        try {
            this.fSWTBrowser = new Browser(container, 0);
            this.fSWTBrowser.setLayoutData((Object)gridData);
        }
        catch (SWTError error) {
            this.fSWTBrowser = null;
            Label label = new Label(container, 64);
            label.setText(PHPDebugUIMessages.DebugBrowserView_swtBrowserNotAvailable0);
            label.setLayoutData((Object)gridData);
        }
        this.fTerminateListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        Object obj = events[i].getSource();
                        if (obj instanceof IPHPDebugTarget && events[i].getKind() == 8) {
                            final IPHPDebugTarget target = (IPHPDebugTarget)obj;
                            UIJob job = new UIJob(PHPDebugUIMessages.PHPDebugUIPlugin_0){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DebugBrowserView.this.update(target);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.fTerminateListener);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        if (this.fPartListener == null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.browser_output_view");
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener(this.fTerminateListener);
        if (this.fSWTBrowser != null && !this.fSWTBrowser.isDisposed()) {
            this.fSWTBrowser.dispose();
        }
        if (this.fPartListener != null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IPHPDebugTarget target = this.fDebugViewHelper.getSelectionElement(selection);
        this.update(target);
    }

    public void setFocus() {
    }

    @Override
    protected AbstractDebugOutputView.IUpdater createUpdater() {
        return new Updater();
    }

    private final class DebugViewPartListener
    extends PartListenerAdapter {
        private DebugViewPartListener() {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == DebugBrowserView.this) {
                IPHPDebugTarget target = DebugBrowserView.this.fDebugViewHelper.getSelectionElement(null);
                DebugBrowserView.this.update(target);
            }
        }
    }

    private final class Updater
    implements AbstractDebugOutputView.IUpdater {
        private int fUpdateCount;

        private Updater() {
        }

        @Override
        public void update(IPHPDebugTarget target) {
            if (DebugBrowserView.this.fSWTBrowser != null && !DebugBrowserView.this.fSWTBrowser.isDisposed()) {
                int oldcount = this.fUpdateCount;
                DebugOutput debugOutput = null;
                if (target != null) {
                    if (target.isSuspended() || target.isTerminated() || target.isWaiting()) {
                        debugOutput = target.getOutputBuffer();
                        this.fUpdateCount = debugOutput.getUpdateCount();
                        if (this.fUpdateCount == oldcount) {
                            return;
                        }
                        String contentType = debugOutput.getContentType();
                        if (contentType != null && !contentType.startsWith("text")) {
                            return;
                        }
                        DebugBrowserView.this.fSWTBrowser.setText(debugOutput.getOutput());
                    } else {
                        return;
                    }
                }
            }
        }
    }
}

