/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.editor;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.zend.communication.RemoteFileStorage;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.ui.editor.input.IPlatformIndependentPathEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class RemoteFileStorageEditorInput
extends ExternalStorageEditorInput
implements IURIEditorInput,
IPlatformIndependentPathEditorInput {
    private URI storageURI;

    public RemoteFileStorageEditorInput(RemoteFileStorage storage) {
        super((IStorage)storage);
    }

    public ImageDescriptor getImageDescriptor() {
        return PHPDebugUIImages.getImageDescriptor("IMG_OBJ_REMOTE_FILE");
    }

    public URI getURI() {
        if (this.storageURI == null) {
            try {
                RemoteFileStorage storage = (RemoteFileStorage)this.getStorage();
                this.storageURI = URIUtil.toURI((String)storage.getFileName());
            }
            catch (Exception e) {
                Logger.log(4, "Could not determine the storage URI (Storage = " + this.getStorage() + ")");
            }
        }
        return this.storageURI;
    }

    public String getToolTipText() {
        return this.getStorage().getFullPath().toString();
    }

    public String getPath() {
        return ((RemoteFileStorage)this.getStorage()).getFileName();
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            if (object instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)object;
                URI otherURI = uriEditorInput.getURI();
                return otherURI != null && otherURI.equals(this.getURI());
            }
        }
        catch (Exception e) {
            DebugPlugin.log((Throwable)e);
        }
        return false;
    }
}

