/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.move.MoveUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeIncludePath
extends AbstractVisitor {
    private IFile participateFile;
    private boolean isIncluded;
    protected final List<TextEditGroup> groups = new LinkedList<TextEditGroup>();
    private IFile file;
    private IPath destinationPath;
    private IResource[] selectedResource;

    public ChangeIncludePath(IFile file, IFile participateFile, IPath fMainDestinationPath, boolean isIncluded, IResource[] selectedResources) {
        this.file = file;
        this.participateFile = participateFile;
        this.isIncluded = isIncluded;
        this.destinationPath = fMainDestinationPath;
        this.selectedResource = selectedResources;
    }

    public boolean visit(Include include) {
        String stringValue;
        ParenthesisExpression exp;
        Expression expression;
        Scalar scalar = null;
        if (include.getExpression() instanceof ParenthesisExpression && (expression = (exp = (ParenthesisExpression)include.getExpression()).getExpression()) instanceof Scalar) {
            scalar = (Scalar)expression;
        }
        if (include.getExpression() instanceof Scalar) {
            scalar = (Scalar)include.getExpression();
        }
        if (scalar != null && this.isScalarNeedChange(scalar, stringValue = scalar.getStringValue())) {
            this.addChange(scalar, stringValue, PHPRefactoringCoreMessages.getString("RenameIncludeAndClassName.1"));
        }
        return false;
    }

    private boolean isScalarNeedChange(Scalar scalar, String stringValue) {
        String value = this.getUnQuotedString(stringValue);
        Path includePath = new Path(value);
        if (includePath.toString().startsWith("..")) {
            includePath = this.participateFile.getParent().getFullPath().append((IPath)includePath).makeRelativeTo(this.file.getProject().getFullPath());
        }
        IPath fileDirectory = this.file.getParent().getProjectRelativePath();
        if (this.isIncluded) {
            return true;
        }
        if (fileDirectory.isPrefixOf((IPath)includePath)) {
            return includePath.equals((Object)this.file.getProjectRelativePath());
        }
        IPath fullPath = this.participateFile.getParent().getProjectRelativePath().append((IPath)includePath);
        return fullPath.equals((Object)this.file.getProjectRelativePath());
    }

    private void addChange(Scalar scalar, String oldString, String description) {
        char charAt = scalar.getStringValue().charAt(0);
        int isQuotedOffset = charAt == '\"' || charAt == '\'' ? 1 : 0;
        this.addChange(scalar.getStart() + isQuotedOffset, oldString, description);
    }

    protected void addChange(int start, String oldString, String description) {
        String newValue;
        TextEditGroup textEditGroup = new TextEditGroup(description);
        String value = this.getUnQuotedString(oldString);
        if (!value.equals(newValue = this.getNewPath(value))) {
            ReplaceEdit replaceEdit = new ReplaceEdit(start, value.length(), newValue);
            textEditGroup.addTextEdit((TextEdit)replaceEdit);
            this.groups.add(textEditGroup);
        }
    }

    private String getUnQuotedString(String oldString) {
        String value = oldString;
        if (oldString.charAt(0) == '\"' && oldString.charAt(oldString.length() - 1) == '\"') {
            value = oldString.substring(1, oldString.length() - 1);
        }
        if (oldString.charAt(0) == '\'' && oldString.charAt(oldString.length() - 1) == '\'') {
            value = oldString.substring(1, oldString.length() - 1);
        }
        return value;
    }

    private String getNewPath(String value) {
        if (!this.isIncluded) {
            return MoveUtils.getMovedIncludingString(this.file, this.destinationPath, this.participateFile, value, this.selectedResource);
        }
        return MoveUtils.getMovedIncludedString(this.file, this.destinationPath, value, this.selectedResource);
    }

    public boolean hasChanges() {
        return this.groups.size() != 0;
    }

    public void updateChange(TextFileChange change) {
        if (!this.hasChanges()) {
            return;
        }
        ChangeIncludePath.addGroups(change, this.groups);
    }

    private static final void addGroups(TextFileChange change, List<TextEditGroup> groups) {
        assert (change != null && groups != null);
        TextEditChangeGroup[] textEditChangeGroups = change.getTextEditChangeGroups();
        block0: for (TextEditGroup editGroup : groups) {
            TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, editGroup);
            TextEdit textEdit = editGroup.getTextEdits()[0];
            TextEditChangeGroup[] textEditChangeGroupArray = textEditChangeGroups;
            int n = textEditChangeGroups.length;
            int n2 = 0;
            while (n2 < n) {
                TextEditChangeGroup existingTextEditChangeGroup = textEditChangeGroupArray[n2];
                TextEdit existingTextEdit = existingTextEditChangeGroup.getTextEdits()[0];
                if (existingTextEdit.getOffset() == textEdit.getOffset()) continue block0;
                ++n2;
            }
            change.addTextEditChangeGroup(textEditChangeGroup);
            change.addEdit(textEdit);
        }
    }
}

