/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.generation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.ui.actions.AddGetterSetterOperation;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class AddGetterSetterTests {
    protected IProject project;
    protected IFile testFile;
    protected IDocument testDocument;
    protected PHPVersion phpVersion;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static final char SELECTION_CHAR = '|';

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/generation/gettersetter"});
    }

    public AddGetterSetterTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("Add_GetterSetter_" + this.phpVersion));
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core");
        node.put("formatterProfile", "org.eclipse.php.formatter.ui.default");
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    @Test
    public void generate(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        IField field = this.createFile(pdttFile.getFile());
        IType type = (IType)field.getParent();
        IField[] input = new IField[]{field};
        CodeGenerationSettings settings = new CodeGenerationSettings();
        settings.createComments = true;
        ASTParser parser = ASTParser.newParser((PHPVersion)this.phpVersion, (ISourceModule)type.getSourceModule());
        Program unit = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        AddGetterSetterOperation operation = new AddGetterSetterOperation(type, input, input, new IField[0], unit, this.testDocument, null, settings, true);
        Exception[] err = new Exception[1];
        Display.getDefault().syncExec(() -> {
            try {
                operation.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        });
        if (err[0] != null) {
            throw err[0];
        }
        PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)this.testDocument.get());
    }

    protected InputStream[] prepareOtherStreams(PdttFile file) {
        String[] contents = file.getOtherFiles();
        InputStream[] result = new InputStream[contents.length];
        int i = 0;
        while (i < contents.length) {
            result[i] = new ByteArrayInputStream(contents[i].getBytes());
            ++i;
        }
        return result;
    }

    protected IField createFile(String data) throws Exception {
        IModelElement[] elements;
        int left = data.indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        this.testDocument = new Document();
        this.testDocument.set(data);
        this.testFile = TestUtils.createFile((IProject)this.project, (String)"test.php", (String)data);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        TestUtils.waitForIndexer();
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        IModelElement[] iModelElementArray = elements = sourceModule.codeSelect(left, right - left);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement modelElement = iModelElementArray[n2];
            if (modelElement instanceof IField) {
                return (IField)modelElement;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No field found under selection");
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }
}

