/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import org.eclipse.php.astview.views.ASTAttribute;
import org.eclipse.php.astview.views.Binding;
import org.eclipse.swt.graphics.Image;

public class GeneralAttribute
extends ASTAttribute {
    private final Object fParent;
    private final String fLabel;
    private final Object[] fChildren;

    public GeneralAttribute(Object parent, String name, Object value) {
        this.fParent = parent;
        this.fLabel = String.valueOf(name) + ": " + String.valueOf(value);
        this.fChildren = EMPTY;
    }

    public GeneralAttribute(Object parent, String label) {
        this.fParent = parent;
        this.fLabel = label;
        this.fChildren = EMPTY;
    }

    public GeneralAttribute(Object parent, String name, Object[] children) {
        this.fParent = parent;
        if (children == null) {
            this.fLabel = String.valueOf(name) + ": null";
            this.fChildren = EMPTY;
        } else if (children.length == 0) {
            this.fLabel = String.valueOf(name) + " (0)";
            this.fChildren = EMPTY;
        } else {
            this.fChildren = this.createChildren(children);
            this.fLabel = String.valueOf(name) + " (" + String.valueOf(this.fChildren.length) + ')';
        }
    }

    private Object[] createChildren(Object[] children) {
        Object[] res = new ASTAttribute[children.length];
        int i = 0;
        while (i < res.length) {
            Object child = children[i];
            String name = String.valueOf(i);
            res[i] = Binding.createValueAttribute(this, name, child);
            ++i;
        }
        return res;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        return this.fChildren;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GeneralAttribute other = (GeneralAttribute)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fLabel == null ? other.fLabel != null : !this.fLabel.equals(other.fLabel));
    }

    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fLabel != null ? this.fLabel.hashCode() : 0);
    }
}

