/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.text;

import javax.swing.text.Segment;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public final class TextSequenceUtilities {
    private TextSequenceUtilities() {
    }

    @NonNull
    public static TextSequence createTextSequence(@NonNull IStructuredDocumentRegion source) {
        return TextSequenceUtilities.createTextSequence(source, 0, source.getLength());
    }

    @NonNull
    public static TextSequence createTextSequence(@NonNull IStructuredDocumentRegion source, int startOffset, int length) {
        String s = "";
        try {
            s = source.getParentDocument().get(startOffset, length);
        }
        catch (BadLocationException badLocationException) {}
        Segment segment = new Segment(s.toCharArray(), 0, s.length());
        return new SimpleTextSequence(source, segment, 0, segment.count, startOffset);
    }

    @Nullable
    public static String getType(@NonNull TextSequence textSequence, int index) {
        int sourceOffset = textSequence.getOriginalOffset(index);
        return TextSequenceUtilities.getTypeByAbsoluteOffset(textSequence, sourceOffset);
    }

    @Nullable
    public static String getTypeByAbsoluteOffset(@NonNull TextSequence textSequence, int sourceOffset) {
        ITextRegion tRegion;
        IStructuredDocumentRegion source = textSequence.getSource();
        if (source.getEndOffset() == sourceOffset && source.getEndOffset() > 0) {
            --sourceOffset;
        }
        if ((tRegion = source.getRegionAtCharacterOffset(sourceOffset)) == null) {
            return null;
        }
        if (tRegion.getType() == "PHP_CONTENT") {
            try {
                return ((IPHPScriptRegion)tRegion).getPHPTokenType(sourceOffset - source.getStartOffset() - tRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
                return null;
            }
        }
        return tRegion.getType();
    }

    private static abstract class AbstractTextSequence
    implements TextSequence {
        IStructuredDocumentRegion source;
        Segment segment;
        int segmentOriginalStart;

        protected AbstractTextSequence(@NonNull IStructuredDocumentRegion source, @NonNull Segment segment, int segmentOriginalStart) {
            this.source = source;
            this.segment = segment;
            this.segmentOriginalStart = segmentOriginalStart;
        }

        @Override
        @NonNull
        public IStructuredDocumentRegion getSource() {
            return this.source;
        }

        @Override
        public char charAt(int index) {
            return this.segment.array[this.getSegmentOffset(index)];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.subTextSequence(start, end);
        }

        protected abstract int getSegmentOffset(int var1);
    }

    private static class CompositeTextSequence
    extends AbstractTextSequence
    implements TextSequence {
        private final int[] indexes;
        private int length = -1;

        CompositeTextSequence(@NonNull IStructuredDocumentRegion source, @NonNull Segment segment, @NonNull int[] indexes, int segmentOriginalStart) {
            super(source, segment, segmentOriginalStart);
            this.indexes = indexes;
        }

        @Override
        public int length() {
            if (this.length == -1) {
                int rv = 0;
                int i = 1;
                while (i < this.indexes.length) {
                    rv += this.indexes[i];
                    i += 2;
                }
                this.length = rv;
            }
            return this.length;
        }

        @Override
        public int getOriginalOffset(int index) {
            int rv = this.segmentOriginalStart;
            int i = 0;
            while (i < this.indexes.length) {
                if (index - this.indexes[i + 1] < 0) {
                    rv += this.indexes[i] + index;
                    break;
                }
                index -= this.indexes[i + 1];
                i += 2;
            }
            return rv;
        }

        @Override
        protected int getSegmentOffset(int index) {
            int rv = this.segment.offset;
            int i = 0;
            while (i < this.indexes.length) {
                if (index - this.indexes[i + 1] < 0) {
                    rv += this.indexes[i] + index;
                    break;
                }
                index -= this.indexes[i + 1];
                i += 2;
            }
            return rv;
        }

        @Override
        @NonNull
        public TextSequence subTextSequence(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            int startPart = 0;
            int endPart = 0;
            int startPartLength = 0;
            int i = 0;
            while (i < this.indexes.length) {
                if (startPartLength + this.indexes[i + 1] > start) {
                    startPart = i >> 1;
                    break;
                }
                startPartLength += this.indexes[i + 1];
                i += 2;
            }
            int endPartLength = startPartLength;
            int i2 = startPart << 1;
            while (i2 < this.indexes.length) {
                if (endPartLength + this.indexes[i2 + 1] >= end) {
                    endPart = i2 >> 1;
                    break;
                }
                endPartLength += this.indexes[i2 + 1];
                i2 += 2;
            }
            int newNumberOfParts = endPart - startPart + 1;
            if (newNumberOfParts == 1) {
                int newStart = this.indexes[startPart << 1] + start - startPartLength;
                int newLength = end - start;
                return new SimpleTextSequence(this.source, this.segment, newStart, newLength, this.segmentOriginalStart);
            }
            int[] newIndexes = new int[newNumberOfParts << 1];
            newIndexes[0] = this.indexes[startPart << 1] + start - startPartLength;
            newIndexes[1] = this.indexes[(startPart << 1) + 1] - (start - startPartLength);
            int i3 = 2;
            while (i3 < newIndexes.length - 3) {
                newIndexes[i3] = this.indexes[i3 + (startPart << 1)];
                newIndexes[i3 + 1] = this.indexes[i3 + (startPart << 1) + 1];
                ++i3;
            }
            newIndexes[newIndexes.length - 2] = this.indexes[endPart << 1];
            newIndexes[newIndexes.length - 1] = end - endPartLength;
            return new CompositeTextSequence(this.source, this.segment, newIndexes, this.segmentOriginalStart);
        }

        @Override
        @NonNull
        public TextSequence cutTextSequence(int start, int end) {
            int startPart = 0;
            int endPart = 0;
            int startPartLength = 0;
            int i = 0;
            while (i < this.indexes.length) {
                if (startPartLength + this.indexes[i + 1] > start) {
                    startPart = i >> 1;
                    break;
                }
                startPartLength += this.indexes[i + 1];
                i += 2;
            }
            int endPartLength = startPartLength;
            int i2 = startPart << 1;
            while (i2 < this.indexes.length) {
                if (endPartLength + this.indexes[i2 + 1] >= end) {
                    endPart = i2 >> 1;
                    break;
                }
                endPartLength += this.indexes[i2 + 1];
                i2 += 2;
            }
            int numberOfParts = this.indexes.length >> 1;
            int newNumberOfParts = startPart + numberOfParts - endPart + 1;
            int[] newIndexes = new int[newNumberOfParts << 1];
            int part = 0;
            while (part < startPart) {
                newIndexes[part << 1] = this.indexes[part << 1];
                newIndexes[(part << 1) + 1] = this.indexes[(part << 1) + 1];
                ++part;
            }
            newIndexes[part << 1] = this.indexes[startPart << 1];
            newIndexes[(part << 1) + 1] = start - startPartLength;
            newIndexes[++part << 1] = this.indexes[endPart << 1] + (end - endPartLength);
            newIndexes[(part << 1) + 1] = this.indexes[(endPart << 1) + 1] - (end - endPartLength);
            ++part;
            int diff = numberOfParts - newNumberOfParts;
            while (part + diff < numberOfParts) {
                newIndexes[part << 1] = this.indexes[part + diff << 1];
                newIndexes[(part << 1) + 1] = this.indexes[(part + diff << 1) + 1];
                ++part;
            }
            return new CompositeTextSequence(this.source, this.segment, newIndexes, this.segmentOriginalStart);
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder(this.length());
            int i = 0;
            while (i < this.indexes.length) {
                buffer.append(this.segment.array, this.segment.offset + this.indexes[i], this.indexes[i + 1]);
                i += 2;
            }
            return buffer.toString();
        }
    }

    private static class SimpleTextSequence
    extends AbstractTextSequence
    implements TextSequence {
        private final int offset;
        private final int length;

        SimpleTextSequence(@NonNull IStructuredDocumentRegion source, @NonNull Segment segment, int offset, int length, int segmentOriginalStart) {
            super(source, segment, segmentOriginalStart);
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int getOriginalOffset(int index) {
            return this.segmentOriginalStart + this.offset + index;
        }

        @Override
        protected int getSegmentOffset(int index) {
            return this.segment.offset + this.offset + index;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        @NonNull
        public TextSequence subTextSequence(int start, int end) {
            return new SimpleTextSequence(this.source, this.segment, this.offset + start, end - start, this.segmentOriginalStart);
        }

        @Override
        @NonNull
        public TextSequence cutTextSequence(int start, int end) {
            if (start == 0) {
                return this.subTextSequence(end, this.length);
            }
            if (end == this.length) {
                return this.subTextSequence(0, start);
            }
            int[] newIndexes = new int[]{this.offset, start, this.offset + end, this.length - end};
            return new CompositeTextSequence(this.source, this.segment, newIndexes, this.segmentOriginalStart);
        }

        @Override
        public String toString() {
            return new String(this.segment.array, this.segment.offset + this.offset, this.length);
        }
    }
}

