/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.php.internal.core.Logger;

public class PHPCallProcessor
implements ICallProcessor {
    private static final String EMPTY_STRING = "";
    private SearchEngine engine = new SearchEngine();

    public Map process(IModelElement parent, IModelElement member, IDLTKSearchScope scope, IProgressMonitor monitor) {
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)member, (int)1, (int)16, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        Requestor req = new Requestor(member);
        try {
            this.engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)req, monitor);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return req.result;
    }

    private class Requestor
    extends SearchRequestor {
        public Map<Object, Object> result = new HashMap<Object, Object>();
        private IModelElement search;

        public Requestor(IModelElement member) {
            this.search = member;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() != 0) {
                return;
            }
            if (match.isInsideDocComment()) {
                return;
            }
            if (match.getElement() != null && match.getElement() instanceof IModelElement) {
                IModelElement member = (IModelElement)match.getElement();
                SimpleReference ref = new SimpleReference(match.getOffset(), match.getOffset() + match.getLength(), PHPCallProcessor.EMPTY_STRING);
                this.result.put(ref, member);
            }
        }
    }
}

