/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public abstract class AbstractCompletionStrategy
implements ICompletionStrategy {
    private IElementFilter elementFilter;
    private ICompletionContext context;
    private CompletionCompanion companion;

    public AbstractCompletionStrategy(ICompletionContext context) {
        this.context = context;
    }

    public AbstractCompletionStrategy(ICompletionContext context, IElementFilter elementFilter) {
        this.context = context;
        this.elementFilter = elementFilter;
    }

    @Override
    public void init(CompletionCompanion companion) {
        this.companion = companion;
    }

    protected CompletionCompanion getCompanion() {
        return this.companion;
    }

    public ICompletionContext getContext() {
        return this.context;
    }

    public ISourceRange getReplacementRangeWithSpaceAtPrefixEnd(ICompletionContext context) throws BadLocationException {
        int prefixEnd;
        AbstractCompletionContext completionContext = (AbstractCompletionContext)context;
        int length = completionContext.getPrefix().length();
        int start = completionContext.getOffset() - length;
        if (start + length < (prefixEnd = completionContext.getPrefixEnd())) {
            length = prefixEnd - start;
        }
        if (completionContext.hasSpaceAtPosition(start + length)) {
            return new SourceRange(start, length + 1);
        }
        return new SourceRange(start, length);
    }

    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        int prefixEnd;
        AbstractCompletionContext completionContext = (AbstractCompletionContext)context;
        int length = completionContext.getPrefix().length();
        int start = completionContext.getOffset() - length;
        if (start + length < (prefixEnd = completionContext.getPrefixEnd())) {
            length = prefixEnd - start;
        }
        return new SourceRange(start, length);
    }

    public String getNSSuffix(ICompletionContext context) {
        AbstractCompletionContext completionContext = (AbstractCompletionContext)context;
        String nextWord = null;
        try {
            nextWord = completionContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "\\".equals(nextWord) ? "" : "\\";
    }

    public ISourceRange getReplacementRangeWithBraces(ICompletionContext context) throws BadLocationException {
        int prefixEnd;
        AbstractCompletionContext completionContext = (AbstractCompletionContext)context;
        int length = completionContext.getPrefix().length();
        int start = completionContext.getOffset() - length;
        if (start + length < (prefixEnd = completionContext.getPrefixEnd())) {
            length = prefixEnd - start;
        }
        IStructuredDocument document = completionContext.getDocument();
        int endOfReplacement = start + length;
        if (document.getLength() == start) {
            endOfReplacement = start;
        } else if (endOfReplacement < document.getLength() - 2 && document.getChar(endOfReplacement) == '(' && document.getChar(endOfReplacement + 1) == ')') {
            endOfReplacement += 2;
        }
        return new SourceRange(start, endOfReplacement - start);
    }

    public IElementFilter getElementFilter() {
        return this.elementFilter;
    }

    public void setElementFilter(IElementFilter elementFilter) {
        this.elementFilter = elementFilter;
    }

    protected boolean isCaseSensitive() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistCaseSensitivity", false, null);
    }

    protected IModelElement[] filterByCase(IModelElement[] elements, String prefix) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(elements.length);
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            if (element.getElementName().startsWith(prefix)) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    protected IDLTKSearchScope createSearchScope() {
        ISourceModule sourceModule = ((AbstractCompletionContext)this.context).getSourceModule();
        IScriptProject scriptProject = sourceModule.getScriptProject();
        if (scriptProject != null) {
            return SearchEngine.createSearchScope((IModelElement)scriptProject);
        }
        IProjectFragment projectFragment = (IProjectFragment)sourceModule.getAncestor(3);
        if (projectFragment != null) {
            return SearchEngine.createSearchScope((IModelElement)projectFragment);
        }
        return SearchEngine.createSearchScope((IModelElement)sourceModule);
    }

    protected boolean isInsertMode() {
        IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.php.core");
        boolean noOverwrite = preferenceStore.getBoolean("contentAssistInsertCompletion", true);
        return noOverwrite;
    }
}

