/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.Arrays;
import java.util.List;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.rewrite.IndentManipulation;

public class LineCommentEndOffsets {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] offsets;
    private final List commentList;

    public LineCommentEndOffsets(List commentList) {
        this.commentList = commentList;
        this.offsets = null;
    }

    private int[] getOffsets() {
        if (this.offsets == null) {
            if (this.commentList != null) {
                int nComments = this.commentList.size();
                int count = 0;
                int i = 0;
                while (i < nComments) {
                    Object curr = this.commentList.get(i);
                    if (this.isLineComment(curr)) {
                        ++count;
                    }
                    ++i;
                }
                this.offsets = new int[count];
                i = 0;
                int k = 0;
                while (i < nComments) {
                    Object curr = this.commentList.get(i);
                    if (this.isLineComment(curr)) {
                        Comment comment = (Comment)curr;
                        this.offsets[k++] = comment.getEnd();
                    }
                    ++i;
                }
            } else {
                this.offsets = EMPTY_INT_ARRAY;
            }
        }
        return this.offsets;
    }

    private boolean isLineComment(Object curr) {
        return curr instanceof Comment && ((Comment)curr).getCommentType() == 0;
    }

    public boolean isEndOfLineComment(int offset) {
        return offset >= 0 && Arrays.binarySearch(this.getOffsets(), offset) >= 0;
    }

    public boolean isEndOfLineComment(int offset, char[] content) {
        if (offset < 0 || offset < content.length && !IndentManipulation.isLineDelimiterChar(content[offset])) {
            return false;
        }
        return Arrays.binarySearch(this.getOffsets(), offset) >= 0;
    }

    public boolean remove(int offset) {
        int[] offsetArray = this.getOffsets();
        int index = Arrays.binarySearch(offsetArray, offset);
        if (index >= 0) {
            if (index > 0) {
                System.arraycopy(offsetArray, 0, offsetArray, 1, index);
            }
            offsetArray[0] = -1;
            return true;
        }
        return false;
    }
}

