/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.core.ast.nodes.ASTError;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.ArrayElement;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.BackTickExpression;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.BreakStatement;
import org.eclipse.php.core.ast.nodes.CastExpression;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.ClassName;
import org.eclipse.php.core.ast.nodes.CloneExpression;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.ContinueStatement;
import org.eclipse.php.core.ast.nodes.DeclareStatement;
import org.eclipse.php.core.ast.nodes.DoStatement;
import org.eclipse.php.core.ast.nodes.EchoStatement;
import org.eclipse.php.core.ast.nodes.EmptyStatement;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FinallyClause;
import org.eclipse.php.core.ast.nodes.ForEachStatement;
import org.eclipse.php.core.ast.nodes.ForStatement;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.GlobalStatement;
import org.eclipse.php.core.ast.nodes.GotoLabel;
import org.eclipse.php.core.ast.nodes.GotoStatement;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.IfStatement;
import org.eclipse.php.core.ast.nodes.IgnoreError;
import org.eclipse.php.core.ast.nodes.InLineHtml;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.InfixExpression;
import org.eclipse.php.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.core.ast.nodes.ListVariable;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.core.ast.nodes.PostfixExpression;
import org.eclipse.php.core.ast.nodes.PrefixExpression;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Quote;
import org.eclipse.php.core.ast.nodes.Reference;
import org.eclipse.php.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.StaticStatement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SwitchCase;
import org.eclipse.php.core.ast.nodes.SwitchStatement;
import org.eclipse.php.core.ast.nodes.ThrowStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TryStatement;
import org.eclipse.php.core.ast.nodes.UnaryOperation;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.WhileStatement;
import org.eclipse.php.core.ast.nodes.YieldExpression;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;

public class ASTRewriteFlattener
extends AbstractVisitor {
    protected StringBuilder result;
    private RewriteEventStore store;

    public static String asString(ASTNode node, RewriteEventStore store) {
        ASTRewriteFlattener flattener = new ASTRewriteFlattener(store);
        node.accept(flattener);
        return flattener.getResult();
    }

    public ASTRewriteFlattener(RewriteEventStore store) {
        this.store = store;
        this.result = new StringBuilder();
    }

    public String getResult() {
        return new String(this.result.toString());
    }

    public void reset() {
        this.result.setLength(0);
    }

    public static void printModifiers(int modifiers, StringBuilder buf) {
        if (PHPFlags.isPublic((int)modifiers)) {
            buf.append("public ");
        }
        if (PHPFlags.isProtected((int)modifiers)) {
            buf.append("protected ");
        }
        if (PHPFlags.isPrivate((int)modifiers)) {
            buf.append("private ");
        }
        if (PHPFlags.isStatic((int)modifiers)) {
            buf.append("static ");
        }
        if (PHPFlags.isAbstract((int)modifiers)) {
            buf.append("abstract ");
        }
        if (PHPFlags.isFinal((int)modifiers)) {
            buf.append("final ");
        }
    }

    protected List getChildList(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        Object ret = this.getAttribute(parent, childProperty);
        if (ret instanceof List) {
            return (List)ret;
        }
        return Collections.EMPTY_LIST;
    }

    protected ASTNode getChildNode(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (ASTNode)this.getAttribute(parent, childProperty);
    }

    protected int getIntAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Integer)this.getAttribute(parent, childProperty);
    }

    protected boolean getBooleanAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Boolean)this.getAttribute(parent, childProperty);
    }

    protected Object getAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        if (this.store != null) {
            return this.store.getNewValue(parent, childProperty);
        }
        return null;
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator) {
        List list = this.getChildList(parent, childProperty);
        int i = 0;
        while (i < list.size()) {
            if (separator != null && i > 0) {
                this.result.append(separator);
            }
            ((ASTNode)list.get(i)).accept(this);
            ++i;
        }
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator, String lead, String post) {
        List list = this.getChildList(parent, childProperty);
        if (!list.isEmpty()) {
            this.result.append(lead);
            int i = 0;
            while (i < list.size()) {
                if (separator != null && i > 0) {
                    this.result.append(separator);
                }
                ((ASTNode)list.get(i)).accept(this);
                ++i;
            }
            this.result.append(post);
        }
    }

    @Override
    public boolean visit(ArrayAccess arrayAccess) {
        boolean isVariableHashtable;
        if (arrayAccess.getName() != null) {
            arrayAccess.getName().accept(this);
        }
        boolean bl = isVariableHashtable = arrayAccess.getArrayType() == 2;
        if (isVariableHashtable) {
            this.result.append('{');
        } else {
            this.result.append('[');
        }
        if (arrayAccess.getIndex() != null) {
            arrayAccess.getIndex().accept(this);
        }
        if (isVariableHashtable) {
            this.result.append('}');
        } else {
            this.result.append(']');
        }
        return false;
    }

    @Override
    public boolean visit(ArrayCreation arrayCreation) {
        this.result.append("array(");
        Iterator<ArrayElement> elements = arrayCreation.elements().iterator();
        if (elements.hasNext()) {
            elements.next().accept(this);
            while (elements.hasNext()) {
                this.result.append(",");
                elements.next().accept(this);
            }
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(ArrayElement arrayElement) {
        if (arrayElement.getKey() != null) {
            arrayElement.getKey().accept(this);
            this.result.append("=>");
        }
        arrayElement.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Assignment assignment) {
        assignment.getLeftHandSide().accept(this);
        this.result.append(Assignment.getOperator(assignment.getOperator()));
        assignment.getRightHandSide().accept(this);
        return false;
    }

    @Override
    public boolean visit(ASTError astError) {
        return false;
    }

    @Override
    public boolean visit(BackTickExpression backTickExpression) {
        this.result.append("`");
        for (Expression expr : backTickExpression.expressions()) {
            expr.accept(this);
        }
        this.result.append("`");
        return false;
    }

    @Override
    public boolean visit(Block block) {
        if (block.isBracketed()) {
            this.result.append("{\n");
        } else if (block.isColon()) {
            this.result.append(":\n");
        }
        this.visitList(block, Block.STATEMENTS_PROPERTY, null);
        if (block.isBracketed()) {
            this.result.append("}\n");
        } else if (block.isColon()) {
            StructuralPropertyDescriptor locationInParent = block.getLocationInParent();
            if (locationInParent == IfStatement.TRUE_STATEMENT_PROPERTY) {
                if (((IfStatement)block.getParent()).getFalseStatement() == null) {
                    this.result.append("endif;\n");
                } else {
                    this.result.append("\n");
                }
            } else if (locationInParent == IfStatement.FALSE_STATEMENT_PROPERTY) {
                this.result.append("endif;\n");
            } else if (locationInParent == WhileStatement.BODY_PROPERTY) {
                this.result.append("endwhile;\n");
            } else if (locationInParent == ForStatement.BODY_PROPERTY) {
                this.result.append("endfor;\n");
            } else if (locationInParent == ForEachStatement.STATEMENT_PROPERTY) {
                this.result.append("endforeach;\n");
            } else if (locationInParent == SwitchStatement.BODY_PROPERTY) {
                this.result.append("endswitch;\n");
            }
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement breakStatement) {
        this.result.append("break");
        if (breakStatement.getExpression() != null) {
            this.result.append(' ');
            breakStatement.getExpression().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(CastExpression castExpression) {
        this.result.append("(");
        this.result.append(CastExpression.getCastType(castExpression.getCastingType()));
        this.result.append(")");
        castExpression.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(CatchClause catchClause) {
        this.result.append("catch (");
        catchClause.getClassNames().get(0).accept(this);
        int i = 1;
        while (i < catchClause.getClassNames().size()) {
            this.result.append(" | ");
            Expression className = catchClause.getClassNames().get(0);
            className.accept(this);
            ++i;
        }
        this.result.append(" ");
        catchClause.getVariable().accept(this);
        this.result.append(") ");
        catchClause.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(FinallyClause finallyClause) {
        this.result.append("finally ");
        finallyClause.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        this.result.append("const ");
        boolean isFirst = true;
        List<Identifier> variableNames = classConstantDeclaration.names();
        List<Expression> constantValues = classConstantDeclaration.initializers();
        int i = 0;
        while (i < variableNames.size()) {
            if (!isFirst) {
                this.result.append(", ");
            }
            variableNames.get(i).accept(this);
            this.result.append(" = ");
            constantValues.get(i).accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(TraitDeclaration traitDeclaration) {
        this.result.append("trait ");
        traitDeclaration.getName().accept(this);
        if (traitDeclaration.getSuperClass() != null) {
            this.result.append(" extends ");
            traitDeclaration.getSuperClass().accept(this);
        }
        traitDeclaration.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        Iterator<Identifier> iterator;
        int modifier = classDeclaration.getModifier();
        if (modifier != 0) {
            this.result.append(ClassDeclaration.getModifier(modifier));
            this.result.append(' ');
        }
        this.result.append("class ");
        classDeclaration.getName().accept(this);
        if (classDeclaration.getSuperClass() != null) {
            this.result.append(" extends ");
            classDeclaration.getSuperClass().accept(this);
        }
        if (!(iterator = classDeclaration.interfaces().iterator()).hasNext()) {
            this.result.append(" implements ");
            iterator.next().accept(this);
            while (iterator.hasNext()) {
                this.result.append(" , ");
                iterator.next().accept(this);
            }
        }
        classDeclaration.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        Iterator<Expression> ctorParams;
        this.result.append("new ");
        classInstanceCreation.getClassName().accept(this);
        if (classInstanceCreation.getEnd() != classInstanceCreation.getClassName().getEnd() || classInstanceCreation.getClassName().getStart() == -1) {
            this.result.append("(");
        }
        if ((ctorParams = classInstanceCreation.ctorParams().iterator()).hasNext()) {
            ctorParams.next().accept(this);
            while (ctorParams.hasNext()) {
                this.result.append(",");
                ctorParams.next().accept(this);
            }
        }
        if (classInstanceCreation.getEnd() != classInstanceCreation.getClassName().getEnd() || classInstanceCreation.getClassName().getStart() == -1) {
            this.result.append(")");
        }
        return false;
    }

    @Override
    public boolean visit(ClassName className) {
        className.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(CloneExpression cloneExpression) {
        this.result.append("clone ");
        cloneExpression.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(Comment comment) {
        this.result.append(this.getComment(comment));
        this.result.append("\n");
        return false;
    }

    public String getComment(Comment comment) {
        if (comment.getCommentType() == 0) {
            return "//";
        }
        if (comment.getCommentType() == 1) {
            return "/* */";
        }
        if (comment.getCommentType() == 2) {
            return "/** */";
        }
        return null;
    }

    @Override
    public boolean visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getCondition().accept(this);
        this.result.append(" ? ");
        conditionalExpression.getIfTrue().accept(this);
        this.result.append(" : ");
        conditionalExpression.getIfFalse().accept(this);
        return false;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement) {
        this.result.append("continue ");
        if (continueStatement.getExpression() != null) {
            continueStatement.getExpression().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(DeclareStatement declareStatement) {
        this.result.append("declare (");
        boolean isFirst = true;
        List<Identifier> directiveNames = declareStatement.directiveNames();
        List<Expression> directiveValues = declareStatement.directiveValues();
        int i = 0;
        while (i < directiveNames.size()) {
            if (!isFirst) {
                this.result.append(", ");
            }
            directiveNames.get(i).accept(this);
            this.result.append(" = ");
            directiveValues.get(i).accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(")");
        declareStatement.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(DoStatement doStatement) {
        this.result.append("do ");
        Statement body = doStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.result.append("while (");
        Expression cond = doStatement.getCondition();
        if (cond != null) {
            cond.accept(this);
        }
        this.result.append(");\n");
        return false;
    }

    @Override
    public boolean visit(EchoStatement echoStatement) {
        this.result.append("echo ");
        List<Expression> expressions = echoStatement.expressions();
        int i = 0;
        while (i < expressions.size()) {
            expressions.get(i).accept(this);
            if (i + 1 < expressions.size()) {
                this.result.append(", ");
            }
            ++i;
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement emptyStatement) {
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement expressionStatement) {
        if (expressionStatement.getExpression() != null) {
            expressionStatement.getExpression().accept(this);
            this.result.append(";");
        } else {
            this.result.append("Missing();");
        }
        return false;
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        fieldAccess.getDispatcher().accept(this);
        this.result.append("->");
        fieldAccess.getField().accept(this);
        return false;
    }

    @Override
    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        Variable[] variableNames = fieldsDeclaration.getVariableNames();
        Expression[] initialValues = fieldsDeclaration.getInitialValues();
        int i = 0;
        while (i < variableNames.length) {
            this.result.append(String.valueOf(fieldsDeclaration.getModifierString()) + " ");
            variableNames[i].accept(this);
            if (initialValues[i] != null) {
                this.result.append(" = ");
                initialValues[i].accept(this);
            }
            this.result.append(";\n");
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        Expression value;
        this.result.append("foreach (");
        Expression express = forEachStatement.getExpression();
        if (express != null) {
            express.accept(this);
        }
        this.result.append(" as ");
        if (forEachStatement.getKey() != null) {
            forEachStatement.getKey().accept(this);
            this.result.append(" => ");
        }
        if ((value = forEachStatement.getValue()) != null) {
            value.accept(this);
        }
        this.result.append(")");
        forEachStatement.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        this.result.append("namespace ");
        namespaceDeclaration.getName().accept(this);
        if (namespaceDeclaration.getBody() == null) {
            this.result.append(";\n");
        } else {
            if (!namespaceDeclaration.getBody().isBracketed()) {
                this.result.append(";\n");
            }
            namespaceDeclaration.getBody().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(NamespaceName namespaceName) {
        if (namespaceName.isGlobal()) {
            this.result.append("\\");
        }
        if (namespaceName.isCurrent()) {
            this.result.append("namespace\\");
        }
        List<Identifier> segments = namespaceName.segments();
        Iterator<Identifier> it = segments.iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.result.append("\\");
        }
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        this.result.append("use ");
        if (useStatement.getStatementType() == 1) {
            this.result.append("function ");
        } else if (useStatement.getStatementType() == 2) {
            this.result.append("const ");
        }
        Iterator<UseStatementPart> it = useStatement.parts().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.result.append(", ");
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(UseStatementPart useStatementPart) {
        useStatementPart.getName().accept(this);
        Identifier alias = useStatementPart.getAlias();
        if (alias != null) {
            this.result.append(" as ");
            alias.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FormalParameter formalParameter) {
        Expression paramType = formalParameter.getParameterType();
        if (paramType != null) {
            paramType.accept(this);
            this.result.append(' ');
        }
        if (formalParameter.isVariadic()) {
            this.result.append("...");
        }
        formalParameter.getParameterName().accept(this);
        Expression defaultValue = formalParameter.getDefaultValue();
        if (defaultValue != null) {
            this.result.append(" = ");
            defaultValue.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        this.result.append("for (");
        Iterator<Expression> expressions = forStatement.initializers().iterator();
        if (expressions.hasNext()) {
            expressions.next().accept(this);
            while (expressions.hasNext()) {
                this.result.append(", ");
                expressions.next().accept(this);
            }
        }
        this.result.append(" ; ");
        expressions = forStatement.conditions().iterator();
        if (expressions.hasNext()) {
            expressions.next().accept(this);
            while (expressions.hasNext()) {
                this.result.append(", ");
                expressions.next().accept(this);
            }
        }
        this.result.append(" ; ");
        expressions = forStatement.updaters().iterator();
        if (expressions.hasNext()) {
            expressions.next().accept(this);
            while (expressions.hasNext()) {
                this.result.append(", ");
                expressions.next().accept(this);
            }
        }
        this.result.append(" ) ");
        Statement body = forStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionDeclaration functionDeclaration) {
        Block body;
        this.result.append(" function ");
        if (functionDeclaration.isReference()) {
            this.result.append('&');
        }
        functionDeclaration.getFunctionName().accept(this);
        this.result.append('(');
        List<FormalParameter> formalParametersList = functionDeclaration.formalParameters();
        FormalParameter[] formalParameters = formalParametersList.toArray(new FormalParameter[formalParametersList.size()]);
        if (formalParameters.length != 0) {
            formalParameters[0].accept(this);
            int i = 1;
            while (i < formalParameters.length) {
                this.result.append(", ");
                formalParameters[i].accept(this);
                ++i;
            }
        }
        this.result.append(')');
        if (functionDeclaration.getReturnType() != null) {
            this.result.append(':');
            functionDeclaration.getReturnType().accept(this);
        }
        if ((body = functionDeclaration.getBody()) != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        functionInvocation.getFunctionName().accept(this);
        this.result.append('(');
        Iterator<Expression> parameters = functionInvocation.parameters().iterator();
        if (parameters.hasNext()) {
            parameters.next().accept(this);
            while (parameters.hasNext()) {
                this.result.append(',');
                parameters.next().accept(this);
            }
        }
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(FunctionName functionName) {
        functionName.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(GlobalStatement globalStatement) {
        this.result.append("global ");
        Iterator<Variable> variables = globalStatement.variables().iterator();
        if (variables.hasNext()) {
            variables.next().accept(this);
            while (variables.hasNext()) {
                this.result.append(", ");
                variables.next().accept(this);
            }
        }
        this.result.append(";\n ");
        return false;
    }

    @Override
    public boolean visit(GotoLabel gotoLabel) {
        gotoLabel.getName().accept(this);
        this.result.append(":\n ");
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        this.result.append("goto ");
        gotoStatement.getLabel().accept(this);
        this.result.append(";\n ");
        return false;
    }

    @Override
    public boolean visit(Identifier identifier) {
        this.result.append(identifier.getName());
        return false;
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        this.result.append("if(");
        Expression cond = ifStatement.getCondition();
        if (cond != null) {
            cond.accept(this);
        }
        this.result.append(")");
        Statement trueStatement = ifStatement.getTrueStatement();
        if (trueStatement != null) {
            trueStatement.accept(this);
        }
        if (ifStatement.getFalseStatement() != null) {
            this.result.append("else");
            ifStatement.getFalseStatement().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(IgnoreError ignoreError) {
        this.result.append("@");
        ignoreError.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(Include include) {
        this.result.append(Include.getType(include.getIncludeType()));
        this.result.append(" (");
        include.getExpression().accept(this);
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(InfixExpression infixExpression) {
        infixExpression.getLeft().accept(this);
        this.result.append(' ');
        this.result.append(InfixExpression.getOperator(infixExpression.getOperator()));
        this.result.append(' ');
        infixExpression.getRight().accept(this);
        return false;
    }

    @Override
    public boolean visit(InLineHtml inLineHtml) {
        return false;
    }

    @Override
    public boolean visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getExpression().accept(this);
        this.result.append(" instanceof ");
        instanceOfExpression.getClassName().accept(this);
        return false;
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.result.append("interface ");
        interfaceDeclaration.getName().accept(this);
        if (interfaceDeclaration.interfaces().size() > 0) {
            this.result.append(" extends ");
            boolean isFirst = true;
            List<Identifier> interfaces = interfaceDeclaration.interfaces();
            for (Identifier interfaceItem : interfaces) {
                if (!isFirst) {
                    this.result.append(", ");
                }
                interfaceItem.accept(this);
                isFirst = false;
            }
        }
        interfaceDeclaration.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ListVariable listVariable) {
        this.result.append("list(");
        Iterator<Expression> variables = listVariable.variables().iterator();
        if (variables.hasNext()) {
            variables.next().accept(this);
            while (variables.hasNext()) {
                this.result.append(", ");
                variables.next().accept(this);
            }
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(LambdaFunctionDeclaration functionDeclaration) {
        this.result.append(" function ");
        if (functionDeclaration.isReference()) {
            this.result.append('&');
        }
        this.result.append('(');
        List<FormalParameter> formalParametersList = functionDeclaration.formalParameters();
        Iterator<FormalParameter> paramIt = formalParametersList.iterator();
        while (paramIt.hasNext()) {
            paramIt.next().accept(this);
            if (!paramIt.hasNext()) continue;
            this.result.append(", ");
        }
        this.result.append(')');
        List<Expression> lexicalVariables = functionDeclaration.lexicalVariables();
        if (lexicalVariables.size() > 0) {
            this.result.append(" use (");
            Iterator<Expression> it = lexicalVariables.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.result.append(", ");
            }
            this.result.append(')');
        }
        if (functionDeclaration.getBody() != null) {
            functionDeclaration.getBody().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration) {
        Comment comment = methodDeclaration.getComment();
        if (comment != null) {
            comment.accept(this);
        }
        this.result.append(methodDeclaration.getModifierString());
        methodDeclaration.getFunction().accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodInvocation methodInvocation) {
        methodInvocation.getDispatcher().accept(this);
        this.result.append("->");
        methodInvocation.getMethod().accept(this);
        return false;
    }

    @Override
    public boolean visit(ParenthesisExpression parenthesisExpression) {
        this.result.append("(");
        if (parenthesisExpression.getExpression() != null) {
            parenthesisExpression.getExpression().accept(this);
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression postfixExpressions) {
        postfixExpressions.getVariable().accept(this);
        this.result.append(PostfixExpression.getOperator(postfixExpressions.getOperator()));
        return false;
    }

    @Override
    public boolean visit(PrefixExpression prefixExpression) {
        prefixExpression.getVariable().accept(this);
        this.result.append(PrefixExpression.getOperator(prefixExpression.getOperator()));
        return false;
    }

    @Override
    public boolean visit(Program program) {
        boolean isPhpState = false;
        for (Statement statement : program.statements()) {
            boolean isHtml = statement instanceof InLineHtml;
            if (!isHtml && !isPhpState) {
                this.result.append("<?php\n");
                statement.accept(this);
                isPhpState = true;
                continue;
            }
            if (!isHtml && isPhpState) {
                statement.accept(this);
                this.result.append("\n");
                continue;
            }
            if (isHtml && isPhpState) {
                this.result.append("?>\n");
                statement.accept(this);
                this.result.append("\n");
                isPhpState = false;
                continue;
            }
            statement.accept(this);
            this.result.append("\n");
        }
        if (isPhpState) {
            this.result.append("?>\n");
        }
        for (Comment comment : program.comments()) {
            comment.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Quote quote) {
        switch (quote.getQuoteType()) {
            case 0: {
                this.result.append("\"");
                this.acceptQuoteExpression(quote.expressions());
                this.result.append("\"");
                break;
            }
            case 1: {
                this.result.append("'");
                this.acceptQuoteExpression(quote.expressions());
                this.result.append("'");
                break;
            }
            case 2: {
                this.result.append("<<<Heredoc\n");
                this.acceptQuoteExpression(quote.expressions());
                this.result.append("\nHeredoc");
            }
        }
        return false;
    }

    @Override
    public boolean visit(Reference reference) {
        this.result.append("&");
        reference.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(ReflectionVariable reflectionVariable) {
        this.result.append("$");
        reflectionVariable.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        this.result.append("return ");
        if (returnStatement.getExpression() != null) {
            returnStatement.getExpression().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(YieldExpression returnStatement) {
        this.result.append("yield ");
        if (returnStatement.getExpression() != null) {
            returnStatement.getExpression().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(Scalar scalar) {
        if (scalar.getScalarType() != 3) {
            this.result.append(scalar.getStringValue());
        }
        return false;
    }

    @Override
    public boolean visit(StaticConstantAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.result.append("::");
        staticFieldAccess.getConstant().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticFieldAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.result.append("::");
        staticFieldAccess.getField().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticMethodInvocation staticMethodInvocation) {
        staticMethodInvocation.getClassName().accept(this);
        this.result.append("::");
        staticMethodInvocation.getMethod().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticStatement staticStatement) {
        this.result.append("static ");
        Iterator<Expression> expressions = staticStatement.expressions().iterator();
        if (expressions.hasNext()) {
            expressions.next().accept(this);
            while (expressions.hasNext()) {
                this.result.append(", ");
                expressions.next().accept(this);
            }
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.result.append("default:\n");
        } else {
            this.result.append("case ");
            if (switchCase.getValue() != null) {
                switchCase.getValue().accept(this);
                this.result.append(":\n");
            }
        }
        for (Statement act : switchCase.actions()) {
            act.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SwitchStatement switchStatement) {
        this.result.append("switch (");
        Expression express = switchStatement.getExpression();
        if (express != null) {
            express.accept(this);
        }
        this.result.append(")");
        Block statment = switchStatement.getBody();
        if (statment != null) {
            statment.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        this.result.append("throw ");
        throwStatement.getExpression().accept(this);
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.result.append("try ");
        Block body = tryStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        List<CatchClause> catchClauses = tryStatement.catchClauses();
        int i = 0;
        while (i < catchClauses.size()) {
            catchClauses.get(i).accept(this);
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(UnaryOperation unaryOperation) {
        this.result.append(UnaryOperation.getOperator(unaryOperation.getOperator()));
        unaryOperation.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(Variable variable) {
        if (variable.isDollared()) {
            this.result.append("$");
        }
        variable.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        this.result.append("while (");
        Expression condition = whileStatement.getCondition();
        if (condition != null) {
            whileStatement.getCondition().accept(this);
        }
        this.result.append(")\n");
        Statement body = whileStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SingleFieldDeclaration singleFieldDeclaration) {
        singleFieldDeclaration.getName().accept(this);
        Expression value = singleFieldDeclaration.getValue();
        if (value != null) {
            this.result.append(" = ");
            value.accept(this);
        }
        return false;
    }

    private void acceptQuoteExpression(List<Expression> expressions) {
        for (Expression expr : expressions) {
            expr.accept(this);
        }
    }
}

