/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class DoStatement
extends Statement {
    private Expression condition;
    private Statement body;
    public static final ChildPropertyDescriptor CONDITION_PROPERTY = new ChildPropertyDescriptor(DoStatement.class, "condition", Expression.class, true, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(DoStatement.class, "body", Statement.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> list = new ArrayList<ChildPropertyDescriptor>(3);
        list.add(CONDITION_PROPERTY);
        list.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public DoStatement(int start, int end, AST ast, Expression condition, Statement body) {
        super(start, end, ast);
        if (condition == null || body == null) {
            throw new IllegalArgumentException();
        }
        this.setCondition(condition);
        this.setBody(body);
    }

    public DoStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.body.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<DoStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.body.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</Condition>\n");
        buffer.append(tab).append("</DoStatement>");
    }

    @Override
    public int getType() {
        return 20;
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.condition;
        this.preReplaceChild(oldChild, expression, CONDITION_PROPERTY);
        this.condition = expression;
        this.postReplaceChild(oldChild, expression, CONDITION_PROPERTY);
    }

    public void setBody(Statement body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CONDITION_PROPERTY) {
            if (get) {
                return this.getCondition();
            }
            this.setCondition((Expression)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Statement body = ASTNode.copySubtree(target, this.getBody());
        Expression condition = ASTNode.copySubtree(target, this.getCondition());
        DoStatement result = new DoStatement(this.getStart(), this.getEnd(), target, condition, body);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

