/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.actions.DeclarationsSearchGroup;
import org.eclipse.dltk.ui.actions.ReferencesSearchGroup;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.ui.actions.WTPToDLTKSelectionProvider;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.actions.OccurrencesSearchGroup;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class PHPSearchActionGroup
extends ActionGroup {
    private OpenSearchDialogAction action;
    private OccurrencesSearchGroup fOccurrencesGroup;
    private ReferencesSearchGroup fReferencesGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;
    private final PHPStructuredEditor fEditor;
    private WTPToDLTKSelectionProvider proxySelectionProvider;

    public PHPSearchActionGroup(PHPStructuredEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.action = new OpenSearchDialogAction();
        this.fOccurrencesGroup = new OccurrencesSearchGroup(editor);
        this.fReferencesGroup = new ReferencesSearchGroup((AbstractDecoratedTextEditor)editor, PHPLanguageToolkit.getDefault());
        ISelectionProvider parentProvider = this.fEditor.getSelectionProvider();
        this.proxySelectionProvider = new WTPToDLTKSelectionProvider(parentProvider);
        this.fDeclarationsGroup = new DeclarationsSearchGroup((AbstractDecoratedTextEditor)editor, PHPLanguageToolkit.getDefault());
        this.fReferencesGroup.setSpecialSelectionProvider((ISelectionProvider)this.proxySelectionProvider);
        this.fDeclarationsGroup.setSpecialSelectionProvider((ISelectionProvider)this.proxySelectionProvider);
    }

    public PHPSearchActionGroup(IWorkbenchSite site) {
        this.fEditor = null;
        this.action = new OpenSearchDialogAction();
        this.fOccurrencesGroup = new OccurrencesSearchGroup(site);
        this.fReferencesGroup = new ReferencesSearchGroup(site, PHPLanguageToolkit.getDefault());
        this.fDeclarationsGroup = new DeclarationsSearchGroup(site, PHPLanguageToolkit.getDefault());
        this.proxySelectionProvider = new WTPToDLTKSelectionProvider(site.getSelectionProvider());
        this.fReferencesGroup.setSpecialSelectionProvider((ISelectionProvider)this.proxySelectionProvider);
        this.fDeclarationsGroup.setSpecialSelectionProvider((ISelectionProvider)this.proxySelectionProvider);
        this.proxySelectionProvider.register();
    }

    public void setContext(ActionContext context) {
        this.fOccurrencesGroup.setContext(context);
        this.fReferencesGroup.setContext(context);
        this.fDeclarationsGroup.setContext(context);
        super.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        this.fOccurrencesGroup.fillActionBars(actionBar);
        this.fReferencesGroup.fillActionBars(actionBar);
        this.fDeclarationsGroup.fillActionBars(actionBar);
        super.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = "SearchMessages.group_search";
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            if (searchSubMenu != null) {
                this.fOccurrencesGroup.fillContextMenu(target);
                searchSubMenu.add((IContributionItem)new Separator());
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
            this.fReferencesGroup.fillContextMenu(target);
            this.fDeclarationsGroup.fillContextMenu(target);
        } else {
            this.fReferencesGroup.fillContextMenu(menu);
            this.fDeclarationsGroup.fillContextMenu(menu);
        }
        IContributionItem item = menu.find("group.open");
        if (item != null) {
            menu.appendToGroup("group.open", (IAction)this.action);
        }
    }

    public void dispose() {
        this.fOccurrencesGroup.dispose();
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        if (this.fEditor == null) {
            this.proxySelectionProvider.dispose();
            this.proxySelectionProvider = null;
        }
        super.dispose();
    }
}

