/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Dimension
implements Cloneable,
Serializable,
Translatable {
    public static final Dimension SINGLETON = new Dimension();
    public int width;
    public int height;
    static final long serialVersionUID = 1L;

    public Dimension() {
    }

    public Dimension(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public Dimension(org.eclipse.swt.graphics.Point pt) {
        this.width = pt.x;
        this.height = pt.y;
    }

    public Dimension(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public Dimension(Image image) {
        Rectangle r = image.getBounds();
        this.width = r.width;
        this.height = r.height;
    }

    public boolean contains(Dimension d) {
        return this.width >= d.width && this.height >= d.height;
    }

    public boolean containsProper(Dimension d) {
        return this.width > d.width && this.height > d.height;
    }

    public void setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public int getArea() {
        return this.width * this.height;
    }

    public Dimension getCopy() {
        return new Dimension(this);
    }

    public Dimension getDifference(Dimension d) {
        return new Dimension(this.width - d.width, this.height - d.height);
    }

    public Dimension getExpanded(Dimension d) {
        return new Dimension(this.width + d.width, this.height + d.height);
    }

    public Dimension getExpanded(int w, int h) {
        return new Dimension(this.width + w, this.height + h);
    }

    public Dimension getIntersected(Dimension d) {
        return new Dimension(this).intersect(d);
    }

    public Dimension getNegated() {
        return new Dimension(0 - this.width, 0 - this.height);
    }

    public boolean equals(Object o) {
        if (o instanceof Dimension) {
            Dimension d = (Dimension)o;
            return d.width == this.width && d.height == this.height;
        }
        return false;
    }

    public boolean equals(int w, int h) {
        return this.width == w && this.height == h;
    }

    public Dimension expand(Dimension d) {
        this.width += d.width;
        this.height += d.height;
        return this;
    }

    public Dimension expand(Point pt) {
        this.width += pt.x;
        this.height += pt.y;
        return this;
    }

    public Dimension expand(int w, int h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public Dimension getScaled(double amount) {
        return new Dimension(this).scale(amount);
    }

    public Dimension getTransposed() {
        return new Dimension(this).transpose();
    }

    public Dimension getUnioned(Dimension d) {
        return new Dimension(this).union(d);
    }

    public int hashCode() {
        return this.width * this.height ^ this.width + this.height;
    }

    public Dimension intersect(Dimension d) {
        this.width = Math.min(d.width, this.width);
        this.height = Math.min(d.height, this.height);
        return this;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public Dimension negate() {
        this.width = 0 - this.width;
        this.height = 0 - this.height;
        return this;
    }

    public void performScale(double factor) {
        this.scale(factor);
    }

    public void performTranslate(int dx, int dy) {
    }

    public Dimension scale(double amount) {
        return this.scale(amount, amount);
    }

    public Dimension scale(double w, double h) {
        this.width = (int)Math.floor((double)this.width * w);
        this.height = (int)Math.floor((double)this.height * h);
        return this;
    }

    public Dimension shrink(int w, int h) {
        return this.expand(-w, -h);
    }

    public String toString() {
        return "Dimension(" + this.width + ", " + this.height + ")";
    }

    public Dimension transpose() {
        int temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Dimension union(Dimension d) {
        this.width = Math.max(this.width, d.width);
        this.height = Math.max(this.height, d.height);
        return this;
    }

    public double preciseWidth() {
        return this.width;
    }

    public double preciseHeight() {
        return this.height;
    }
}

