/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.CaretSearch;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.graphics.Cursor;

public class SelectionRangeDragTracker
extends SimpleDragTracker {
    private static final int STATE_START = 64;
    private static final int STATE_SWIPE = 128;
    private TextLocation beginDrag;
    private TextLocation endDrag;
    private boolean isWordSelection;
    private final TextualEditPart textSource;

    public SelectionRangeDragTracker(TextualEditPart part) {
        this.textSource = part;
    }

    protected Cursor calculateCursor() {
        return Cursors.IBEAM;
    }

    private void doNormalSwipe() {
        this.endDrag = this.getCurrentTextLocation();
        if (this.endDrag != null) {
            TextualEditPart end = this.endDrag.part;
            TextualEditPart begin = this.beginDrag.part;
            boolean inverted = false;
            if (end == begin) {
                inverted = this.endDrag.offset < this.beginDrag.offset;
            } else {
                EditPart ancestor = ToolUtilities.findCommonAncestor((EditPart)end, (EditPart)begin);
                while (end.getParent() != ancestor) {
                    end = end.getParent();
                }
                while (begin.getParent() != ancestor) {
                    begin = begin.getParent();
                }
                inverted = ancestor.getChildren().indexOf(end) < ancestor.getChildren().indexOf(begin);
            }
            GraphicalTextViewer viewer = (GraphicalTextViewer)this.getCurrentViewer();
            if (!inverted) {
                viewer.setSelectionRange(new SelectionRange(this.beginDrag, this.endDrag));
            } else {
                viewer.setSelectionRange(new SelectionRange(this.endDrag, this.beginDrag, false));
            }
        }
    }

    private void doWordSelect() {
        TextLocation wordEnd;
        int[] trailing = new int[1];
        TextLocation exact = this.getSource().getLocation(this.getLocation(), trailing);
        CaretSearch nextWord = new CaretSearch();
        nextWord.type = 3;
        nextWord.isForward = true;
        nextWord.where = exact;
        nextWord.where = wordEnd = this.getSource().getNextLocation(nextWord);
        nextWord.isForward = false;
        TextLocation wordBegin = this.getSource().getNextLocation(nextWord);
        if (wordBegin != null && wordEnd != null) {
            ((GraphicalTextViewer)this.getCurrentViewer()).setSelectionRange(new SelectionRange(wordBegin, wordEnd));
        }
    }

    private void doWordSwipe() {
    }

    protected String getCommandName() {
        return "Drop Text Request";
    }

    private TextLocation getCurrentTextLocation() {
        EditPart part = this.getCurrentViewer().findObjectAt(this.getLocation());
        if (part instanceof TextualEditPart) {
            TextualEditPart textPart = (TextualEditPart)part;
            int[] trailing = new int[1];
            if (textPart.acceptsCaret()) {
                return textPart.getLocation(this.getLocation(), trailing);
            }
        }
        return null;
    }

    private TextualEditPart getSource() {
        return this.textSource;
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            this.beginDrag = this.getCurrentTextLocation();
            ((GraphicalTextViewer)this.getCurrentViewer()).setSelectionRange(new SelectionRange(this.beginDrag));
            this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            this.doWordSelect();
            this.isWordSelection = true;
            return true;
        }
        return super.handleDoubleClick(button);
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.isWordSelection) {
                this.doWordSwipe();
            } else {
                this.doNormalSwipe();
            }
        }
        return super.handleDragInProgress();
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(64, 128);
    }
}

