/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.ExampleTextCommand;

public class PromoteElementCommand
extends ExampleTextCommand {
    private TextRun run;
    private Container oldParent;
    int index;
    private int caretOffset;

    public PromoteElementCommand(TextualEditPart part, int caretOffset) {
        super("decrease indentation");
        this.caretOffset = caretOffset;
        this.run = (TextRun)part.getModel();
        this.oldParent = this.run.getContainer();
    }

    public void execute() {
        this.index = this.oldParent.getChildren().indexOf(this.run);
        Container newParent = this.oldParent.getContainer();
        int where = newParent.getChildren().indexOf(this.oldParent) + 1;
        this.oldParent.remove(this.run);
        this.run.setType(newParent.getChildType());
        newParent.add(this.run, where);
        if (this.oldParent.getChildren().isEmpty()) {
            this.oldParent.getContainer().remove(this.oldParent);
        }
    }

    public boolean canExecute() {
        return this.oldParent.getContainer() != null;
    }

    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        return new SelectionRange(PromoteElementCommand.lookupModel(viewer, this.run), this.caretOffset);
    }

    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }

    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }
}

