/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;
import org.eclipse.jface.util.Assert;

public class InsertString
extends MiniEdit {
    private String pending;
    private char[] insertedChars;
    private final int offset;
    private final TextRun run;

    public InsertString(TextRun run, String c, int offset) {
        this.run = run;
        this.pending = c;
        this.offset = offset;
    }

    public void appendText(String append) {
        Assert.isTrue((this.pending == null ? 1 : 0) != 0);
        this.pending = append;
    }

    public void apply() {
        this.run.insertText(this.pending, this.offset);
        this.insertedChars = this.pending.toCharArray();
        this.pending = null;
    }

    public boolean canApply() {
        return this.pending != null;
    }

    public void commitPending() {
        this.run.insertText(this.pending, this.offset + this.insertedChars.length);
        char[] old = this.insertedChars;
        this.insertedChars = new char[old.length + 1];
        System.arraycopy(old, 0, this.insertedChars, 0, old.length);
        this.insertedChars[this.insertedChars.length - 1] = this.pending.toCharArray()[0];
        this.pending = null;
    }

    public ModelLocation getResultingLocation() {
        return new ModelLocation(this.run, this.offset + this.insertedChars.length);
    }

    public void reapply() {
        this.run.insertText(new String(this.insertedChars), this.offset);
    }

    public void rollback() {
        this.run.removeRange(this.offset, this.insertedChars.length);
    }
}

